<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field

        $key = md5($_REQUEST['m-pin']);

        // Validate Key

        if ($key !== M_KEY) { // Invalid Key

            echo json_encode(['invalidKey' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Commence Maintenance Mode Toggle

        // Determine Status & Message

        $param = 'ON';

        $msg = 'Maintenance mode activated!';

        if (M_MODE == 'ON') {

            $param = 'OFF';

            $msg = 'Maintenance mode deactivated!';

        }

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `settings` SET `m_mode` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $param); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $updated, 'msg' => $msg]); // Encode JSON      

    }

?>