<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $threat1 = !empty($_REQUEST['threat-1']) ? htmlspecialchars($_REQUEST['threat-1']) : null;

        $threat2 = !empty($_REQUEST['threat-2']) ? htmlspecialchars($_REQUEST['threat-2']) : null;

        $threat3 = !empty($_REQUEST['threat-3']) ? htmlspecialchars($_REQUEST['threat-3']) : null;

        $threat4 = !empty($_REQUEST['threat-4']) ? htmlspecialchars($_REQUEST['threat-4']) : null;

        // Commence Blacklist Update

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `settings` SET `blacklistItem_1` = ?, `blacklistItem_2` = ?, `blacklistItem_3` = ?, `blacklistItem_4` = ? LIMIT 1"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ssss", $threat1, $threat2, $threat3, $threat4); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $updated]); // Encode JSON      

    }

?>