<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field

        $code = filter_var($_REQUEST['country-code'], FILTER_SANITIZE_SPECIAL_CHARS);

        $country = $countryCodesNames[$code];

        // Commence Insertion

        $error = null;

        $dropped = false; // Flag

        $stmt = mysqli_prepare($conn, "INSERT INTO `countries_allowlist` (`code`, `country`) VALUES(?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $code, $country); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $dropped = true; // Update Flag

        } else {

            // $error = mysqli_stmt_error($stmt) ?: mysqli_error($conn); // Get Error

            $errno = mysqli_stmt_errno($stmt);
            if ($errno == 1062) {
                $error = "This country is already in the allowlist.";
            } else {
                $error = "Database error [$errno]: " . mysqli_stmt_error($stmt);
            }

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $dropped, 'error' => $error]); // Encode JSON      

    }

?>