<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $fname = filter_var($_REQUEST['nok-fname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $mname = !empty($_REQUEST['nok-mname']) ? filter_var($_REQUEST['nok-mname'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $lname = filter_var($_REQUEST['nok-lname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $rel = filter_var($_REQUEST['nok-rel'], FILTER_SANITIZE_SPECIAL_CHARS);

        $dob = sanitizeDate($_REQUEST['nok-dob']);

        $address = filter_var($_REQUEST['nok-address'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Commence Update

        $update = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `users` SET `nok_fname` = ?, `nok_mname` = ?, `nok_lname` = ?, `nok_dob` = ?, `nok_address` = ?, `nok_rel` = ? WHERE `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssssss", $fname, $mname, $lname, $dob, $address, $rel, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement
  
            $update = true; // Update Flag
        
        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $update]); // Encode JSON Response

    }

?>