<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $secretQ1 = filter_var($_REQUEST['sq-1'], FILTER_SANITIZE_SPECIAL_CHARS);

        $secretQ2 = filter_var($_REQUEST['sq-2'], FILTER_SANITIZE_SPECIAL_CHARS);

        $awsr1 = filter_var($_REQUEST['answer-1'], FILTER_SANITIZE_SPECIAL_CHARS);

        $awsr2 = filter_var($_REQUEST['answer-2'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Commence Update

        $update = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `users` SET `question_1` = ?, `answer_1` = ?, `question_2` = ?, `answer_2` = ? WHERE `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssss", $secretQ1, $awsr1, $secretQ2, $awsr2, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement
  
            $update = true; // Update Flag
        
        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $update]); // Encode JSON Response

    }

?>