<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    require('../../../controls/engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $user = filter_var($_REQUEST['user-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $fname = filter_var($_REQUEST['firstname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $mname = !empty($_REQUEST['middlename']) ? filter_var($_REQUEST['middlename'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $lname = filter_var($_REQUEST['lastname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $email = filter_var(strtolower(trim($_REQUEST['email'])), FILTER_SANITIZE_EMAIL);

        $password = $_REQUEST['password'];

        $key = md5($password); // Hash Password

        $dob = sanitizeDate($_REQUEST['dob']);

        $phone = filter_var($_REQUEST['phone'], FILTER_SANITIZE_SPECIAL_CHARS);

        $citizen = filter_var($_REQUEST['citizen'], FILTER_SANITIZE_SPECIAL_CHARS);

        $zip = filter_var($_REQUEST['zip'], FILTER_SANITIZE_SPECIAL_CHARS);

        $street = filter_var($_REQUEST['street'], FILTER_SANITIZE_SPECIAL_CHARS);

        $city = filter_var($_REQUEST['city'], FILTER_SANITIZE_SPECIAL_CHARS);

        $state = filter_var($_REQUEST['state'], FILTER_SANITIZE_SPECIAL_CHARS);

        $country = filter_var($_REQUEST['country'], FILTER_SANITIZE_SPECIAL_CHARS);

        $emailInUse = emailExists($email, $conn); // Check If Email Is In use

        if ($emailInUse) {

            $userData = userData($user, $conn);

            if ($userData && $userData['email'] != $email) {

                echo json_encode(['emailError' => true]); // Encode JSON Response

                exit; // End Run

            }

        } 

        // Commence Data Update

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `users` SET `fname` = ?, `mname` = ?, `lname` = ?, `email` = ?, `pre_hash` = ?, `password` = ?, `telephone` = ?, `dob` = ?, `zip_code` = ?, `street_address` = ?, `city` = ?, `state` = ?, `resident_country` = ?, `nationality` = ? WHERE `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssssssssssssss", $fname, $mname, $lname, $email, $password, $key, $phone, $dob, $zip, $street, $city, $state, $country, $citizen, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $updated]); // Encode JSON Response

    }

?>