<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['card-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Determine Action

        if ($action == 'DELETE') { // Delete Virtual Card

            $deleted = false; // Flag

            $delete = mysqli_prepare($conn, "DELETE FROM `virtual_cards` WHERE `card_id` = ?"); // Prepare Statement
    
            mysqli_stmt_bind_param($delete, "s", $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($delete)) { // Execute Statement

                $deleted = true; // Update Flag

            } 

            mysqli_stmt_close($delete);

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response

            exit; // End Run

        } else { // Status Update

            $updated = false; // Flag

            $status = ($action == 'ACTIVATE') ? 'ACTIVE' : 'INACTIVE';

            $stmt = mysqli_prepare($conn, "UPDATE `virtual_cards` SET `status` = ? WHERE `card_id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "ss", $status, $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) {

                $updated = true; // Update Status

            }

            mysqli_stmt_close($stmt); // Close Statement

            echo json_encode(['updated' => $updated]); // Encode JSON Response

        }

    }

?>