<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Settings

    require('../../../controls/engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!filter_var($_REQUEST['webURL'], FILTER_VALIDATE_URL) || !filter_var($_REQUEST['webVendor'], FILTER_VALIDATE_URL) || !filter_var($_REQUEST['webSupport'], FILTER_VALIDATE_URL)) {

            echo json_encode(['urlError' => true]); // Enxode JSON Response

            exit;

        }

        // Sanitize Fields

        $wHome = !empty($_REQUEST['webHome']) ? filter_var($_REQUEST['webHome'], FILTER_SANITIZE_URL) : null;

        $wName = filter_var($_REQUEST['webName'], FILTER_SANITIZE_SPECIAL_CHARS);

        $wTitle = filter_var($_REQUEST['webTitle'], FILTER_SANITIZE_SPECIAL_CHARS);

        $wDescr = filter_var($_REQUEST['webDescr'], FILTER_SANITIZE_SPECIAL_CHARS);

        $wURL = filter_var($_REQUEST['webURL'], FILTER_SANITIZE_URL);

        $wMail = filter_var(strtolower(trim($_REQUEST['webMail'])), FILTER_SANITIZE_EMAIL);

        $wCardFee = filter_var($_REQUEST['webCardFee'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $wSwap = filter_var($_REQUEST['webSwap'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        $wCrypto = filter_var($_REQUEST['webVendor'], FILTER_SANITIZE_URL);

        $wSupport = filter_var($_REQUEST['webSupport'], FILTER_SANITIZE_URL);

        $regPref = filter_var($_REQUEST['regPref'], FILTER_SANITIZE_SPECIAL_CHARS);

        $kycPref = filter_var($_REQUEST['kycPref'], FILTER_SANITIZE_SPECIAL_CHARS);

        $payPopup = filter_var($_REQUEST['pay-popup'], FILTER_SANITIZE_SPECIAL_CHARS);

        $transferPref = filter_var($_REQUEST['transfPref'], FILTER_SANITIZE_SPECIAL_CHARS);

        $accPref = filter_var($_REQUEST['accPref'], FILTER_SANITIZE_SPECIAL_CHARS);

        $cardPref = filter_var($_REQUEST['cardPref'], FILTER_SANITIZE_SPECIAL_CHARS);

        $bankName = filter_var($_REQUEST['bankName'], FILTER_SANITIZE_SPECIAL_CHARS);

        $bankPhone = !empty($_REQUEST['webPhone']) ? filter_var($_REQUEST['webPhone'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $bankAddress = !empty($_REQUEST['bankAddr']) ? filter_var($_REQUEST['bankAddr'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $maxCards = !empty($_REQUEST['webCardMax']) ? filter_var($_REQUEST['webCardMax'], FILTER_SANITIZE_NUMBER_INT) : null;

        $displayUI = filter_var($_REQUEST['user-info'], FILTER_SANITIZE_SPECIAL_CHARS);

        // $faceLogin = filter_var($_REQUEST['faceID'], FILTER_SANITIZE_SPECIAL_CHARS);

        $faceLogin = 'DISABLED';

        // Update Data

        $dataUpdated = false; // Flag

        $update = mysqli_prepare($conn, "UPDATE `settings` SET `siteName` = ?, `siteURL` = ?, `siteTitle` = ?, `site_descr` = ?, `siteMail` = ?, `crypto_vendor` = ?, `live_support` = ?, `reg_approval` = ?, `kyc_required` = ?, `transfer_approval` = ?, `card_request` = ?, `account_request` = ?, `face_login` = ?, `swapRate` = ?, `card_fee` = ?, `pay_tip` = ?, `homepage_url` = ?, `display_user_info` = ?, `bank_name` = ?, `max_cards` = ?, `phone` = ?, `bank_address` = ? LIMIT 1"); // Prepare Statement

        mysqli_stmt_bind_param($update, "sssssssssssssddsssssss", $wName, $wURL, $wTitle, $wDescr, $wMail, $wCrypto, $wSupport, $regPref, $kycPref, $transferPref, $cardPref, $accPref, $faceLogin, $wSwap, $wCardFee, $payPopup, $wHome, $displayUI, $bankName, $maxCards, $bankPhone, $bankAddress); // Bind Parameter(s)


        if (mysqli_stmt_execute($update)) {

            $dataUpdated = true;

        }

        mysqli_stmt_close($update); // Close Statement

        // Check Flag
        
        echo json_encode(['updated' => $dataUpdated]); // Encode JSON Response

        exit; // End Run

    }

?>