<?php

    // Credentials

    require('../../../controls/config/config.php'); // Configuration Setup

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Fields

        $id = filter_var($_REQUEST['account-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $action = filter_var($_REQUEST['action'], FILTER_SANITIZE_SPECIAL_CHARS);

        $null = null;

        if ($action == 'RESET') {

            $reset = false; // Flag

            $null = 0;

            $stmt = mysqli_prepare($conn, "UPDATE `accounts` SET `wth_count` = ? WHERE `acc_id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "is", $null, $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement
    
                $reset = true; // Update Flag
            
            }

            mysqli_stmt_close($stmt); // Close Statement

            echo json_encode(['reset' => $reset]); // Encode JSON Response

        } else if ($action == 'DELETE') {

            // Commence Deletion

            $deleted = false; // Flag

            $stmt = mysqli_prepare($conn, "UPDATE `accounts` SET `wth_limit` = ?, `wth_count` = ?, `wth_max` = ? WHERE `acc_id` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "ssss", $null, $null, $null, $id); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt)) { // Execute Statement
    
                $deleted = true; // Update Flag
            
            }

            mysqli_stmt_close($stmt); // Close Statement

            echo json_encode(['deleted' => $deleted]); // Encode JSON Response

        }    

    }

?>