// Dashboard Activity Monitor

let timeLimit = 45 * 60 * 1000; // 45 minutes

let inactivityTimer;

// Function To Unset Sessions

function terminator() {

    fetch ('../controls/engines/force-terminate.php', {

        method: 'POST',

        credentials: 'same-origin'

    }).then(response => {

        if (response.ok) {

            popup({

                header: 'SESSION TERMINATED',

                title: 'Current session has expired!',

                text: 'Please log in again to continue using the dashboard.',

                type: 'warning'

            }).then(() => {

                window.location.reload();

            });
        }

    });

}

// Reset Inactivity timer On User's Activity

function resetInactivityTimer() {

    clearTimeout(inactivityTimer);

    inactivityTimer = setTimeout(terminator, timeLimit);

}

// Listen For User's Activity

window.addEventListener('mousemove', resetInactivityTimer);

window.addEventListener('keydown', resetInactivityTimer);

window.addEventListener('touchstart', resetInactivityTimer);

// Initiate termination timer

resetInactivityTimer();