// Popup System

function popup(options) {
    return new Promise((resolve, reject) => {
        let {header = null, title, text, type, showConfirmBtn = false} = options;

        const popup = document.createElement('div');
        popup.className = 'popup_window popup';

        if (header) {
            header = `<div class="popupBox_header v2"><p>${header}</p></div>`;
        } else {

            header = "";

        }

        let buttons = `<div class="flx jEnd">

            <button class="popup-btn popup-close-btn">Close</button>

        </div>`;

        if (showConfirmBtn) {

            buttons = `<div class="flx jEnd">

                <button class="popup-btn popup-confirm-btn">Yes, proceed</button>

                <button class="popup-btn popup-close-btn">Close</button>

            </div>`;

        }

        // Icon setup (same as your code, shortened here)
        const icon = document.createElement('div');
        icon.classList.add('icon');
        if (type == 'success') {

            icon.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                <path d="M10 1.66666C5.40835 1.66666 1.66669 5.40832 1.66669 9.99999C1.66669 14.5917 5.40835 18.3333 10 18.3333C14.5917 18.3333 18.3334 14.5917 18.3334 9.99999C18.3334 5.40832 14.5917 1.66666 10 1.66666ZM13.9834 8.08332L9.25835 12.8083C9.14169 12.925 8.98335 12.9917 8.81669 12.9917C8.65002 12.9917 8.49169 12.925 8.37502 12.8083L6.01669 10.45C5.77502 10.2083 5.77502 9.80832 6.01669 9.56666C6.25835 9.32499 6.65835 9.32499 6.90002 9.56666L8.81669 11.4833L13.1 7.19999C13.3417 6.95832 13.7417 6.95832 13.9834 7.19999C14.225 7.44166 14.225 7.83332 13.9834 8.08332Z" fill="#19B259"/>
            </svg>`

        } else if (type == 'error') {

            icon.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24" fill="#FFF" style="fill: var(--pg-red);"><path d="M330-120 120-330v-300l210-210h300l210 210v300L630-120H330Zm36-190 114-114 114 114 56-56-114-114 114-114-56-56-114 114-114-114-56 56 114 114-114 114 56 56Z"/></svg>`;

        } else if (type == 'warning') {

            icon.innerHTML = `<svg stroke="#F93A37FF" fill="none" stroke-width="2" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="icon-lg text-yellow-700" aria-hidden="true" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"></path><line x1="12" y1="9" x2="12" y2="13"></line><line x1="12" y1="17" x2="12.01" y2="17"></line></svg>`;

        } else if (type == 'failure') {

            icon.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
            <circle cx="11" cy="11" r="11" fill="#E4002B"/>
            <path fill-rule="evenodd" clip-rule="evenodd" d="M5.62891 15.4717L15.471 5.62964L16.5627 6.72131L6.72058 16.5634L5.62891 15.4717Z" fill="white"/>
            <path fill-rule="evenodd" clip-rule="evenodd" d="M16.5625 15.4717L6.7204 5.62964L5.62872 6.72131L15.4708 16.5634L16.5625 15.4717Z" fill="white"/>
            </svg>`

        } else if (type == 'checked') {

            icon.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
            <circle cx="11" cy="11" r="11" fill="#0B7A35"/>
            <path fill-rule="evenodd" clip-rule="evenodd" d="M17.5289 7.87915L9.07075 16.3373L4.2793 11.5458L5.37097 10.4541L9.07075 14.1539L16.4372 6.78748L17.5289 7.87915Z" fill="white"/>
            </svg>`;

        } else if (type == 'info') {

            icon.innerHTML = `<svg viewBox="0 0 13 13" aria-hidden="true">
                <path fill="rgb(0, 150, 214)"
                    d="M6.5.5c-3.3 0-6 2.7-6 6s2.7 6 6 6 6-2.7 6-6-2.7-6-6-6m0 1c2.757 0 5 2.243 5 5s-2.243 5-5 5-5-2.243-5-5 2.243-5 5-5">
                </path>
                <path fill="rgb(0, 150, 214)"
                    d="M7.75 3.8501c0 .2-.05.35-.2.5-.15.15-.3.2-.5.2s-.35-.05-.5-.2c-.15-.15-.2-.3-.2-.5s.05-.35.2-.5c.15-.15.3-.2.5-.2s.35.05.5.2c.1.15.2.3.2.5M7 7.5001h.45c-.4 1.45-.9 1.85-1.55 1.85-.25 0-.5-.05-.6-.15-.1-.1-.2-.3-.2-.5 0-.15.05-.35.15-.7l.55-1.5c.05-.1.05-.2-.3-.25v-.1c.35-.05.3 0 .25 0-.15 0-.35.2-.55.35h-.45c.4-.6.9-1.05 1.6-1.05.25 0 .45.05.55.2.1.15.2.3.2.5 0 .15-.05.4-.2.75l-.5 1.4c-.05.2-.1.3-.1.35 0 .05 0 .05.05.05s.05.05.1.05c.1 0 .15-.05.3-.2.15-.15.2-.25.25-1.05">
                </path>
            </svg>`;
            
        } else if (type == 'confirm') {

            icon.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" viewBox="0 0 496.158 496.158" xml:space="preserve">
            <path style="fill:#25B7D3;" d="M496.158,248.085c0-137.022-111.069-248.082-248.075-248.082C111.07,0.003,0,111.063,0,248.085  c0,137.001,111.07,248.07,248.083,248.07C385.089,496.155,496.158,385.086,496.158,248.085z"/>
            <path style="fill:#FFFFFF;" d="M138.216,173.592c0-13.915,4.467-28.015,13.403-42.297c8.933-14.282,21.973-26.11,39.111-35.486  c17.139-9.373,37.134-14.062,59.985-14.062c21.238,0,39.99,3.921,56.25,11.755c16.26,7.838,28.818,18.495,37.683,31.97  c8.861,13.479,13.293,28.125,13.293,43.945c0,12.452-2.527,23.367-7.581,32.739c-5.054,9.376-11.062,17.469-18.018,24.279  c-6.959,6.812-19.446,18.275-37.463,34.388c-4.981,4.542-8.975,8.535-11.975,11.976c-3.004,3.443-5.239,6.592-6.702,9.447  c-1.466,2.857-2.603,5.713-3.406,8.57c-0.807,2.855-2.015,7.875-3.625,15.051c-2.784,15.236-11.501,22.852-26.147,22.852  c-7.618,0-14.028-2.489-19.226-7.471c-5.201-4.979-7.8-12.377-7.8-22.192c0-12.305,1.902-22.962,5.713-31.97  c3.808-9.01,8.861-16.92,15.161-23.73c6.296-6.812,14.794-14.904,25.488-24.28c9.373-8.202,16.15-14.392,20.325-18.567  c4.175-4.175,7.69-8.823,10.547-13.953c2.856-5.126,4.285-10.691,4.285-16.699c0-11.718-4.36-21.605-13.074-29.663  c-8.717-8.054-19.961-12.085-33.728-12.085c-16.116,0-27.981,4.065-35.596,12.195c-7.618,8.13-14.062,20.105-19.336,35.925  c-4.981,16.555-14.43,24.829-28.345,24.829c-8.206,0-15.127-2.891-20.764-8.679C141.035,186.593,138.216,180.331,138.216,173.592z   M245.442,414.412c-8.937,0-16.737-2.895-23.401-8.68c-6.667-5.784-9.998-13.877-9.998-24.279c0-9.229,3.22-16.991,9.668-23.291  c6.444-6.297,14.354-9.448,23.73-9.448c9.229,0,16.991,3.151,23.291,9.448c6.296,6.3,9.448,14.062,9.448,23.291  c0,10.255-3.296,18.312-9.888,24.17C261.7,411.481,254.084,414.412,245.442,414.412z"/>
            </svg>`;

            buttons = `<div class="flx jEnd">

                <button class="popup-btn popup-confirm-btn">Yes, proceed</button>

                <button class="popup-btn popup-close-btn">Close</button>

            </div>`;

        }
        
        const content = `<div class="popup_con">
            <div class="popup_box noScrollBar">
                ${header}
                <div class="modal_box notify">
                    <div class="msgHold">
                        ${icon.outerHTML}
                        <div class="txtBox">
                            <div class="title">${title}</div>
                            <p>${text}</p>
                        </div>
                    </div>
                    ${buttons}
                </div>
            </div>
        </div>`;

        popup.innerHTML = content;
        document.body.appendChild(popup);
        document.body.style.overflow = 'hidden';

        // Event handlers
        function cleanup() {
            document.body.removeChild(popup);
            document.body.style.overflow = '';
        }

        // Close buttons
        popup.querySelectorAll('.popup-close-btn').forEach(btn => {
            btn.addEventListener('click', () => {
                cleanup();
                resolve(false);  // false means "closed/cancelled"
            });
        });

        // Confirm button (only if confirm exists)
        const confirmBtn = popup.querySelector('.popup-confirm-btn');
        if (confirmBtn) {
            confirmBtn.addEventListener('click', () => {
                cleanup();
                resolve(true); // true means "confirmed"
            });
        }
    });
}
