<?php

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../controls/config/config.php'); // Configuration Setup

    require('../controls/engines/fxns.php');

    httpErrorCheck('../');

    // Check Inivite

    if (isset($_REQUEST['invite'])) {

        $id = urldecode(decrypt($_REQUEST['invite']));

        // Get Invite Data

        $found = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT `A`.*, `B`.`user_id` AS `user` FROM `invites` AS `A` LEFT JOIN `users` AS `B` ON `A`.`referrer` = `B`.`user_id` WHERE `A`.`ref_code` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) === 1) { // Get Result Mass

            $found = true;

            while ($row = mysqli_fetch_assoc($result)) { // Fetch Result Data

                $referrer = $row['user'];

                $validity = $row['validity'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if ($found) {

            // Check Validity

            if ($validity == 'EXPIRED') { // Expired Invite

                $expiredInvite = true;

                // Redirect

                echo '<script>

                    setTimeout(() => {
                    
                        window.location.href = "../home";
                    
                    }, 5000);
                
                </script>';

            } else {

                if (!is_null($referrer)) {

                    $_SESSION['REF-LINK'] = $id;

                    $_SESSION['REFERRER'] = $referrer;

                }

                // Redirect

                echo '<script>

                    window.location.href = "register";
                    
                </script>';

                exit(); // Terminate Run

            }

        } else {

            $invalidInvite = true;

            // Redirect

            echo '<script>

                setTimeout(() => {
                
                    window.location.href = "../home";
                
                }, 5000);

            </script>';

        }

    } else {

        // http_response_code(401);

        $_SESSION['HTTP-ERROR'] = 401;

        echo'<script>
        
            location.reload();
        
        </script>';

        // Redirect 

        // echo '<script>
            
        //     window.location.href = "../home";
            
        // </script>';

        // exit(); // Terminate Run

    }

?>

<!DOCTYPE html>

<html lang="en">

    <head>

        <meta charset="UTF-8">

        <meta http-equiv="X-UA-compatible" content="ie=edge">

        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

        <link rel="icon" href="<?= SITE_FAVICON ?>">

        <link rel="stylesheet" type="text/css" href="../assets/stylesheets/main.css">

        <script>
            (function() {
                const page = document.documentElement; //|| document.body; // Ensure it's the right element to modify

                // Check system preference and localStorage immediately
                const systemPreferenceDark = window.matchMedia('(prefers-color-scheme: dark)').matches;

                // Apply theme if dark mode is preferred by the user or if stored in localStorage
                if (localStorage.pageClass === 'darkmode' || (systemPreferenceDark && localStorage.pageClass === undefined)) {
                    page.classList.add('darkmode');
                }
            })();
        </script>

        <style>

            p {

                text-align: center;

                font-size: 1.15rem;

            }

            .animate-img {

                animation: 2.3s linear(0 0%, 0.22 2.1%, 0.86 6.5%, 1.11 8.6%, 1.3 10.7%, 1.35 11.8%, 1.37 12.9%, 1.37 13.7%, 1.36 14.5%, 1.32 16.2%, 1.03 21.8%, 0.94 24%, 0.89 25.9%, 0.88 26.85%, 0.87 27.8%, 0.87 29.25%, 0.88 30.7%, 0.91 32.4%, 0.98 36.4%, 1.01 38.3%, 1.04 40.5%, 1.05 42.7%, 1.05 44.1%, 1.04 45.7%, 1 53.3%, 0.99 55.4%, 0.98 57.5%, 0.99 60.7%, 1 68.1%, 1.01 72.2%, 1 86.7%, 1 100%) 0s 3 normal none running JumpPulse;

            }

            .animate-img.shake {

                animation: 2.5s ease 0s 3 normal none running shake;

            }

            .animate-img svg {

                min-width: 2.5em;

            }
            
            @keyframes JumpPulse {

                0% {

                    opacity: 0;

                    transform: translate(0px, 100%)

                }

                70% {

                    /* box-shadow: 0px 0px 0px 7px rgba(23, 191, 99, 0); */

                    transform: translate(0px, -10px) rotate(-5deg);

                }

                /* 75% {

                    transform: translateX(-10px) rotate(5deg);

                } */

                100% {

                    /* box-shadow: 0px 0px 0px 0px rgba(23, 191, 99, 0); */

                    opacity: 1;

                    transform: translate(0px, 0) rotate(-5deg);

                }

            }

        </style>

        <title>Join <?= SITE_NAME ?> | <?= SITE_NAME ?></title>

    </head>    

    <body>

        <div class="n_displ">

            <div class="gtranslate_wrapper"></div>

        </div>

        <div style="position: fixed; top: 0; left: 0; right: 0; bottom: 0; display: flex; flex-direction: column; justify-content: center; align-items: center; gap: 1em;">

                <?php

                    if (isset($invalidInvite)) {

                        echo '<div class="animate-img shake">
                            
                            <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24" fill="#FFF" style="fill: var(--pg-red);"><path d="M330-120 120-330v-300l210-210h300l210 210v300L630-120H330Zm36-190 114-114 114 114 56-56-114-114 114-114-56-56-114 114-114-114-56 56 114 114-114 114 56 56Z"/></svg>

                        </div>
                        
                        <p>Invitation not found!</p>';

                    } else if (isset($expiredInvite)) {

                        echo '<div class="animate-img shake">
                            
                            <svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24" fill="#FFF" style="fill: var(--pg-red);"><path d="M330-120 120-330v-300l210-210h300l210 210v300L630-120H330Zm36-190 114-114 114 114 56-56-114-114 114-114-56-56-114 114-114-114-56 56 114 114-114 114 56 56Z"/></svg>

                        </div>
                        
                        <p>Invitation expired!</p>';

                    }
                
                ?>

        </div>

        <!-- GTranslate -->

        <script>window.gtranslateSettings = {"default_language":"en","native_language_names":true,"detect_browser_language":true,"wrapper_selector":".gtranslate_wrapper","flag_size":16}</script>
        <script src="https://cdn.gtranslate.net/widgets/latest/popup.js" defer></script>

    </body>

</html>