<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../partials/auth-header.php');

    if (isset($_SESSION['ACCESS'])) { // Deny Previous Dashboard Access 

        unset($_SESSION['ACCESS']);

        unset($_SESSION['USER-ID']);

    }

    $cookieLogin = false; // Flag (Determines Cookie Login)

    if (isset($_COOKIE['USER-iD'])) {

        $cookieLogin = true; // Update Flag

        $user = decrypt($_COOKIE['USER-iD']); // Get User ID

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) { // Invalid User

            $cookieLogin = false; // Update Flag

        } else {

            if ($userData['account-status'] === 'BLOCKED' || $userData['account-status'] === 'SUSPENDED' || $userData['account-status'] === 'BANNED') {

                $cookieLogin = false; // Update Flag

            }

        }
        
    }

    $extraScripts = <<<HTML

        <!-- UA Parser -->

        <script src="../resources/ua-parser/ua-parser.pack.js"></script>
        
    HTML; // Add UA-Parser

?>

<div class="viewBox max">

    <div class="vbox_item header">

        <div class="logo">

            <a<?= !is_null(HOME_PAGE) ? ' href="' . HOME_PAGE . '"' : null ?>> 

                <img class="light" src="<?= SITE_LOGO ?>" alt="">

                <img class="dark" src="<?= SITE_LOGO_DARK ?>" alt="">

            </a>

        </div>

    </div>

    <div class="vbox_item main<?= ($cookieLogin) ? ' iQ_panels' : null ?>" id="formPortal">

        <?php
        
            if ($cookieLogin) { // Display Cookie Login Form ?>

                <div class="flx jSpaceBtw">

                    <div class="iQ_panelSwitch tab-switch">Hello, <span translate="no"><?= $userData['firstname'] ?></span>!</div>

                    <div class="iQ_panelSwitch tab-switch">Switch Account</div>
                
                </div>

                <div class="form_con iQ_panel">

                    <div class="form_title flx jSpaceBtw">

                        <p>Welcome back, <span translate="no"><?= $userData['firstname'] ?></span></p>

                        <?php

                            if (FACE_ID == 'ENABLED' && !iS_null($userData['face-id'])) { ?>

                                <div style="width: 1.5em; margin-inline-start: auto;">

                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:svg="http://www.w3.org/2000/svg" width="57.401726mm" height="57.384167mm" viewBox="0 0 57.401726 57.384167" version="1.1" id="svg1" xml:space="preserve"><g id="layer1" transform="translate(-76.133723,-119.68319)"><path style="fill:#0074f2;fill-opacity:1" d="m 82.405961,176.78713 c -2.30908,-0.54401 -4.321586,-2.1747 -5.522322,-4.47462 -0.569545,-1.09092 -0.62915,-1.57499 -0.711758,-5.78033 -0.04959,-2.52434 -0.0188,-4.87401 0.06841,-5.22149 0.188187,-0.7498 1.183277,-1.07833 1.97795,-0.65304 0.522706,0.27975 0.55381,0.51061 0.55381,4.11052 0,4.57932 0.27637,6.05875 1.382505,7.40069 1.424082,1.72765 2.35956,1.98327 7.282599,1.98992 3.942345,0.005 4.343434,0.0498 4.828646,0.53498 0.636832,0.63683 0.661635,1.01605 0.117288,1.79321 -0.398211,0.56853 -0.554039,0.58716 -4.696354,0.56146 -2.356462,-0.0146 -4.73281,-0.1322 -5.280773,-0.2613 z m 34.925849,-0.1718 c -0.60308,-0.6664 -0.58125,-1.27092 0.0694,-1.92157 0.48599,-0.486 0.88194,-0.52917 4.85317,-0.52917 4.01594,0 4.40709,-0.0439 5.49011,-0.61562 0.64135,-0.3386 1.52328,-1.12227 1.95984,-1.74149 l 0.79375,-1.12586 0.13229,-4.70135 c 0.14057,-4.99539 0.29073,-5.57401 1.4466,-5.57401 0.32343,0 0.7968,0.23066 1.05193,0.51258 0.41345,0.45685 0.45386,1.02494 0.37174,5.22552 -0.0885,4.52597 -0.12132,4.77236 -0.82763,6.21063 -0.84884,1.72852 -2.37673,3.21548 -4.12692,4.01638 -1.06847,0.48894 -1.82521,0.57181 -5.98877,0.65582 -4.43213,0.0894 -4.79795,0.0606 -5.22552,-0.41186 z M 101.016,165.54157 c -1.838662,-0.4943 -4.429846,-1.76987 -5.66722,-2.78982 -1.195613,-0.98552 -1.320659,-2.10112 -0.309757,-2.76348 0.721591,-0.47281 0.538287,-0.543 3.212681,1.23029 4.167936,2.7636 8.999706,2.56763 13.881006,-0.563 1.36226,-0.87369 2.12408,-0.97468 2.73607,-0.36269 1.12189,1.12189 -0.0285,2.50252 -3.42069,4.10538 -3.27925,1.54948 -7.2873,1.98875 -10.43209,1.14332 z m -0.0196,-10.2955 c -0.48402,-0.58322 -0.4023,-1.75717 0.15047,-2.16136 0.26428,-0.19325 0.85172,-0.35137 1.30542,-0.35137 0.45369,0 1.05602,-0.1688 1.33849,-0.3751 0.4766,-0.34809 0.52312,-0.82858 0.64588,-6.67101 l 0.13229,-6.2959 0.69712,-0.39086 c 0.62516,-0.35051 0.76854,-0.34406 1.38906,0.0625 l 0.69195,0.45339 v 6.19438 c 0,3.73335 -0.11181,6.4903 -0.28142,6.93921 -0.34474,0.91245 -1.45812,2.11937 -2.41742,2.62054 -0.96517,0.50422 -3.22564,0.4891 -3.65184,-0.0244 z m -9.561155,-8.57477 c -0.594553,-0.48144 -0.624624,-0.66089 -0.624624,-3.72754 0,-3.06665 0.03007,-3.2461 0.624624,-3.72754 0.838831,-0.67925 1.517349,-0.63683 2.297819,0.14364 0.611447,0.61144 0.649432,0.82107 0.649432,3.5839 0,2.76283 -0.03798,2.97245 -0.649432,3.5839 -0.78047,0.78047 -1.458988,0.82289 -2.297819,0.14364 z m 24.428395,-0.0337 c -0.53297,-0.49653 -0.57906,-0.78986 -0.57906,-3.68496 0,-3.08299 0.0139,-3.15639 0.69714,-3.69386 0.38343,-0.30161 0.84362,-0.54837 1.02265,-0.54837 0.17903,0 0.63923,0.24676 1.02265,0.54837 0.68309,0.53731 0.69714,0.61159 0.69714,3.68496 0,3.07337 -0.014,3.14765 -0.69714,3.68496 -0.87769,0.6904 -1.42945,0.69267 -2.16338,0.009 z M 76.694025,135.90313 c -0.603502,-0.42271 -0.607565,-0.46469 -0.518449,-5.35781 0.08376,-4.59928 0.133429,-5.0202 0.736671,-6.24352 0.821984,-1.66691 2.18439,-3.03047 3.855341,-3.85861 1.253856,-0.62143 1.53315,-0.65013 6.327795,-0.6503 l 5.016042,-1.7e-4 0.399141,0.70952 c 0.365033,0.64889 0.356821,0.75629 -0.09611,1.25677 -0.455116,0.5029 -0.791071,0.54725 -4.145389,0.54725 -4.972284,0 -6.133404,0.27515 -7.677634,1.81938 -1.545488,1.54549 -1.819382,2.70463 -1.819382,7.69974 0,2.98563 -0.07774,3.74999 -0.415774,4.08802 -0.526363,0.52637 -0.899386,0.52406 -1.662251,-0.0103 z m 54.465525,-0.10312 c -0.48654,-0.48653 -0.52917,-0.88194 -0.52917,-4.90793 0,-3.50752 -0.0851,-4.54724 -0.42782,-5.22552 -0.60896,-1.20525 -1.39735,-2.0044 -2.61489,-2.65052 -0.93383,-0.49558 -1.59581,-0.57345 -5.62714,-0.66198 -4.238,-0.0931 -4.58926,-0.13854 -4.85115,-0.62788 -0.41331,-0.77229 -0.0729,-1.76596 0.66885,-1.95212 0.34844,-0.0875 2.63858,-0.11697 5.08919,-0.0656 5.13862,0.10773 6.32016,0.454 8.23947,2.41474 2.00392,2.04716 2.28905,3.06843 2.3883,8.55414 0.086,4.75418 0.0811,4.80321 -0.52182,5.22553 -0.79813,0.55903 -1.1732,0.53776 -1.81382,-0.10286 z" id="path1"/></g></svg>

                                </div>

                            <?php }

                        ?>

                    </div>

                    <form method="post" id="accessForm">

                        <div class="form_item">

                            <label for="key">Password</label>

                            <div class="form_field pseudoField">

                                <input class="iQ_veilField" type="password" name="key" placeholder="(at least 8 characters)" required autocomplete="off" autofocus>

                                <div class="iQ_veiler">

                                    <svg class="default" slot="trailing-accessory" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0)">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.00006 12C5.2353 12 2.91494 10.3114 2.05613 8C2.91494 5.68865 5.2353 4 8.00006 4C10.7648 4 13.0852 5.68865 13.944 8C13.0852 10.3114 10.7648 12 8.00006 12ZM8.00006 2C4.26573 2 1.0761 4.38252 0.0450312 7.70349C-0.014929 7.89662 -0.014929 8.10338 0.0450312 8.29651C1.0761 11.6175 4.26573 14 8.00006 14C11.7344 14 14.924 11.6175 15.9551 8.29651C16.0151 8.10338 16.0151 7.89662 15.9551 7.70349C14.924 4.38252 11.7344 2 8.00006 2ZM8.00006 10C9.10463 10 10.0001 9.10457 10.0001 8C10.0001 6.89543 9.10463 6 8.00006 6C6.89549 6 6.00006 6.89543 6.00006 8C6.00006 9.10457 6.89549 10 8.00006 10Z" fill="currentColor" fill-opacity="0.3"></path>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0">
                                                <rect width="16" height="16" fill="currentColor"></rect>
                                            </clipPath>
                                        </defs>
                                    </svg>

                                    <svg class="toggle" slot="trailing-accessory" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0)">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M1.70711 0.292878C1.31658 -0.0976463 0.683418 -0.0976463 0.292893 0.292878C-0.0976311 0.683402 -0.0976311 1.31657 0.292893 1.70709L2.55013 3.96433C1.38429 4.94208 0.502299 6.23046 0.0449702 7.70347C-0.0149901 7.8966 -0.0149901 8.10337 0.0449702 8.29649C1.07604 11.6175 4.26567 14 8 14C9.33924 14 10.6084 13.6936 11.7331 13.1473L14.2929 15.7071C14.6834 16.0976 15.3166 16.0976 15.7071 15.7071C16.0976 15.3166 16.0976 14.6834 15.7071 14.2929L13.4499 12.0356C14.6157 11.0579 15.4977 9.76951 15.955 8.29649C16.015 8.10337 16.015 7.8966 15.955 7.70347C14.924 4.38251 11.7343 1.99998 8 1.99998C6.66076 1.99998 5.39158 2.30641 4.26689 2.85266L1.70711 0.292878ZM2.05607 7.99998C2.43683 6.97522 3.10489 6.07286 3.9716 5.3858L6.0677 7.4819C6.0235 7.64714 5.99994 7.82082 5.99994 8C5.99994 9.10457 6.89537 10 7.99994 10C8.17912 10 8.3528 9.97644 8.51804 9.93224L10.2077 11.6219C9.52221 11.866 8.77873 12 8 12C5.23524 12 2.91488 10.3113 2.05607 7.99998ZM9.93221 8.51798L12.0284 10.6142C12.8951 9.92711 13.5632 9.02475 13.9439 7.99998C13.0851 5.68863 10.7648 3.99998 8 3.99998C7.22127 3.99998 6.47779 4.13395 5.7923 4.37807L7.48196 6.06773C7.64716 6.02355 7.8208 6 7.99994 6C9.10451 6 9.99994 6.89543 9.99994 8C9.99994 8.17914 9.97639 8.35277 9.93221 8.51798Z" fill="currentColor" fill-opacity="0.3"></path>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0">
                                                <rect width="16" height="16" fill="currentColor"></rect>
                                            </clipPath>
                                        </defs>
                                    </svg>

                                </div>

                            </div>
                            
                        </div>

                        <div class="form_item">

                            <a href="password-reset" class="form_link">Forgot your password &rarr;</a>

                            <button type="submit" name="access" class="form_btn" id="access">Login</button>

                        </div>

                    </form>

                </div>

            <?php }
            
        ?>

        <div class="form_con<?= ($cookieLogin) ? ' iQ_panel n_displ' : null ?>">

            <div class="form_title flx jSpaceBtw">

                <p>Login to your account</p>

                <?php

                    if (FACE_ID == 'ENABLED') { ?>

                        <div style="width: 1.5em; margin-inline-start: auto;">

                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:svg="http://www.w3.org/2000/svg" width="57.401726mm" height="57.384167mm" viewBox="0 0 57.401726 57.384167" version="1.1" id="svg1" xml:space="preserve"><g id="layer1" transform="translate(-76.133723,-119.68319)"><path style="fill:#0074f2;fill-opacity:1" d="m 82.405961,176.78713 c -2.30908,-0.54401 -4.321586,-2.1747 -5.522322,-4.47462 -0.569545,-1.09092 -0.62915,-1.57499 -0.711758,-5.78033 -0.04959,-2.52434 -0.0188,-4.87401 0.06841,-5.22149 0.188187,-0.7498 1.183277,-1.07833 1.97795,-0.65304 0.522706,0.27975 0.55381,0.51061 0.55381,4.11052 0,4.57932 0.27637,6.05875 1.382505,7.40069 1.424082,1.72765 2.35956,1.98327 7.282599,1.98992 3.942345,0.005 4.343434,0.0498 4.828646,0.53498 0.636832,0.63683 0.661635,1.01605 0.117288,1.79321 -0.398211,0.56853 -0.554039,0.58716 -4.696354,0.56146 -2.356462,-0.0146 -4.73281,-0.1322 -5.280773,-0.2613 z m 34.925849,-0.1718 c -0.60308,-0.6664 -0.58125,-1.27092 0.0694,-1.92157 0.48599,-0.486 0.88194,-0.52917 4.85317,-0.52917 4.01594,0 4.40709,-0.0439 5.49011,-0.61562 0.64135,-0.3386 1.52328,-1.12227 1.95984,-1.74149 l 0.79375,-1.12586 0.13229,-4.70135 c 0.14057,-4.99539 0.29073,-5.57401 1.4466,-5.57401 0.32343,0 0.7968,0.23066 1.05193,0.51258 0.41345,0.45685 0.45386,1.02494 0.37174,5.22552 -0.0885,4.52597 -0.12132,4.77236 -0.82763,6.21063 -0.84884,1.72852 -2.37673,3.21548 -4.12692,4.01638 -1.06847,0.48894 -1.82521,0.57181 -5.98877,0.65582 -4.43213,0.0894 -4.79795,0.0606 -5.22552,-0.41186 z M 101.016,165.54157 c -1.838662,-0.4943 -4.429846,-1.76987 -5.66722,-2.78982 -1.195613,-0.98552 -1.320659,-2.10112 -0.309757,-2.76348 0.721591,-0.47281 0.538287,-0.543 3.212681,1.23029 4.167936,2.7636 8.999706,2.56763 13.881006,-0.563 1.36226,-0.87369 2.12408,-0.97468 2.73607,-0.36269 1.12189,1.12189 -0.0285,2.50252 -3.42069,4.10538 -3.27925,1.54948 -7.2873,1.98875 -10.43209,1.14332 z m -0.0196,-10.2955 c -0.48402,-0.58322 -0.4023,-1.75717 0.15047,-2.16136 0.26428,-0.19325 0.85172,-0.35137 1.30542,-0.35137 0.45369,0 1.05602,-0.1688 1.33849,-0.3751 0.4766,-0.34809 0.52312,-0.82858 0.64588,-6.67101 l 0.13229,-6.2959 0.69712,-0.39086 c 0.62516,-0.35051 0.76854,-0.34406 1.38906,0.0625 l 0.69195,0.45339 v 6.19438 c 0,3.73335 -0.11181,6.4903 -0.28142,6.93921 -0.34474,0.91245 -1.45812,2.11937 -2.41742,2.62054 -0.96517,0.50422 -3.22564,0.4891 -3.65184,-0.0244 z m -9.561155,-8.57477 c -0.594553,-0.48144 -0.624624,-0.66089 -0.624624,-3.72754 0,-3.06665 0.03007,-3.2461 0.624624,-3.72754 0.838831,-0.67925 1.517349,-0.63683 2.297819,0.14364 0.611447,0.61144 0.649432,0.82107 0.649432,3.5839 0,2.76283 -0.03798,2.97245 -0.649432,3.5839 -0.78047,0.78047 -1.458988,0.82289 -2.297819,0.14364 z m 24.428395,-0.0337 c -0.53297,-0.49653 -0.57906,-0.78986 -0.57906,-3.68496 0,-3.08299 0.0139,-3.15639 0.69714,-3.69386 0.38343,-0.30161 0.84362,-0.54837 1.02265,-0.54837 0.17903,0 0.63923,0.24676 1.02265,0.54837 0.68309,0.53731 0.69714,0.61159 0.69714,3.68496 0,3.07337 -0.014,3.14765 -0.69714,3.68496 -0.87769,0.6904 -1.42945,0.69267 -2.16338,0.009 z M 76.694025,135.90313 c -0.603502,-0.42271 -0.607565,-0.46469 -0.518449,-5.35781 0.08376,-4.59928 0.133429,-5.0202 0.736671,-6.24352 0.821984,-1.66691 2.18439,-3.03047 3.855341,-3.85861 1.253856,-0.62143 1.53315,-0.65013 6.327795,-0.6503 l 5.016042,-1.7e-4 0.399141,0.70952 c 0.365033,0.64889 0.356821,0.75629 -0.09611,1.25677 -0.455116,0.5029 -0.791071,0.54725 -4.145389,0.54725 -4.972284,0 -6.133404,0.27515 -7.677634,1.81938 -1.545488,1.54549 -1.819382,2.70463 -1.819382,7.69974 0,2.98563 -0.07774,3.74999 -0.415774,4.08802 -0.526363,0.52637 -0.899386,0.52406 -1.662251,-0.0103 z m 54.465525,-0.10312 c -0.48654,-0.48653 -0.52917,-0.88194 -0.52917,-4.90793 0,-3.50752 -0.0851,-4.54724 -0.42782,-5.22552 -0.60896,-1.20525 -1.39735,-2.0044 -2.61489,-2.65052 -0.93383,-0.49558 -1.59581,-0.57345 -5.62714,-0.66198 -4.238,-0.0931 -4.58926,-0.13854 -4.85115,-0.62788 -0.41331,-0.77229 -0.0729,-1.76596 0.66885,-1.95212 0.34844,-0.0875 2.63858,-0.11697 5.08919,-0.0656 5.13862,0.10773 6.32016,0.454 8.23947,2.41474 2.00392,2.04716 2.28905,3.06843 2.3883,8.55414 0.086,4.75418 0.0811,4.80321 -0.52182,5.22553 -0.79813,0.55903 -1.1732,0.53776 -1.81382,-0.10286 z" id="path1"/></g></svg>

                        </div>

                    <?php }

                ?>

            </div>

            <form method="post" id="loginForm">

                <div class="form_item">

                    <label for="identifier">Email / Username / Account Number</label>
                    
                    <input type="text" name="identifier" class="form_field" placeholder="Enter your identifier" value="<?= isset($_POST['email']) ? $_POST['email'] : "" ; ?>" required autofocus>

                </div>

                <div class="form_item">

                    <label for="key">Password</label>

                    <div class="form_field pseudoField">

                        <input class="iQ_veilField" type="password" name="key" placeholder="(at least 8 characters)" required autocomplete="off">

                        <div class="iQ_veiler">

                            <svg class="default" slot="trailing-accessory" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0)">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.00006 12C5.2353 12 2.91494 10.3114 2.05613 8C2.91494 5.68865 5.2353 4 8.00006 4C10.7648 4 13.0852 5.68865 13.944 8C13.0852 10.3114 10.7648 12 8.00006 12ZM8.00006 2C4.26573 2 1.0761 4.38252 0.0450312 7.70349C-0.014929 7.89662 -0.014929 8.10338 0.0450312 8.29651C1.0761 11.6175 4.26573 14 8.00006 14C11.7344 14 14.924 11.6175 15.9551 8.29651C16.0151 8.10338 16.0151 7.89662 15.9551 7.70349C14.924 4.38252 11.7344 2 8.00006 2ZM8.00006 10C9.10463 10 10.0001 9.10457 10.0001 8C10.0001 6.89543 9.10463 6 8.00006 6C6.89549 6 6.00006 6.89543 6.00006 8C6.00006 9.10457 6.89549 10 8.00006 10Z" fill="currentColor" fill-opacity="0.3"></path>
                                </g>
                                <defs>
                                    <clipPath id="clip0">
                                        <rect width="16" height="16" fill="currentColor"></rect>
                                    </clipPath>
                                </defs>
                            </svg>

                            <svg class="toggle" slot="trailing-accessory" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0)">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M1.70711 0.292878C1.31658 -0.0976463 0.683418 -0.0976463 0.292893 0.292878C-0.0976311 0.683402 -0.0976311 1.31657 0.292893 1.70709L2.55013 3.96433C1.38429 4.94208 0.502299 6.23046 0.0449702 7.70347C-0.0149901 7.8966 -0.0149901 8.10337 0.0449702 8.29649C1.07604 11.6175 4.26567 14 8 14C9.33924 14 10.6084 13.6936 11.7331 13.1473L14.2929 15.7071C14.6834 16.0976 15.3166 16.0976 15.7071 15.7071C16.0976 15.3166 16.0976 14.6834 15.7071 14.2929L13.4499 12.0356C14.6157 11.0579 15.4977 9.76951 15.955 8.29649C16.015 8.10337 16.015 7.8966 15.955 7.70347C14.924 4.38251 11.7343 1.99998 8 1.99998C6.66076 1.99998 5.39158 2.30641 4.26689 2.85266L1.70711 0.292878ZM2.05607 7.99998C2.43683 6.97522 3.10489 6.07286 3.9716 5.3858L6.0677 7.4819C6.0235 7.64714 5.99994 7.82082 5.99994 8C5.99994 9.10457 6.89537 10 7.99994 10C8.17912 10 8.3528 9.97644 8.51804 9.93224L10.2077 11.6219C9.52221 11.866 8.77873 12 8 12C5.23524 12 2.91488 10.3113 2.05607 7.99998ZM9.93221 8.51798L12.0284 10.6142C12.8951 9.92711 13.5632 9.02475 13.9439 7.99998C13.0851 5.68863 10.7648 3.99998 8 3.99998C7.22127 3.99998 6.47779 4.13395 5.7923 4.37807L7.48196 6.06773C7.64716 6.02355 7.8208 6 7.99994 6C9.10451 6 9.99994 6.89543 9.99994 8C9.99994 8.17914 9.97639 8.35277 9.93221 8.51798Z" fill="currentColor" fill-opacity="0.3"></path>
                                </g>
                                <defs>
                                    <clipPath id="clip0">
                                        <rect width="16" height="16" fill="currentColor"></rect>
                                    </clipPath>
                                </defs>
                            </svg>

                        </div>

                    </div>
                    
                </div>

                <div class="form_item">

                    <a href="password-reset" class="form_link">Forgot your password &rarr;</a>

                    <button type="submit" name="access" class="form_btn" id="login">Login</button>

                </div>

            </form>

        </div>

        <div class="fd_tx b">Are you a new user? <a href="register" class="dft_link">create an account</a></div>

    </div>

<?php

    require('../partials/auth-footer.php');

?>            