<?php

    function httpErrorCheck($relativity = null) { // Check For HTTP Error Codes (Custom Error Page)

        if (isset($_SESSION['HTTP-ERROR'])) {

            http_response_code($_SESSION['HTTP-ERROR']);

            $errorPage = $relativity . 'error';

            header('Location: ' . $errorPage);

            // file_get_contents($errorPage);

            // unset($_SESSION['HTTP-ERROR']);

            exit();

        }    

    }

    $countryCodesNames = [ // Country Code => Country Name Array

        'AF' => "Afghanistan",
        'AX' => "Åland Islands",
        'AL' => "Albania",
        'DZ' => "Algeria",
        'AS' => "American Samoa",
        'AD' => "Andorra",
        'AO' => "Angola",
        'AI' => "Anguilla",
        'AQ' => "Antarctica",
        'AG' => "Antigua and Barbuda",
        'AR' => "Argentina",
        'AM' => "Armenia",
        'AW' => "Aruba",
        'AU' => "Australia",
        'AT' => "Austria",
        'AZ' => "Azerbaijan",
        'BS' => "Bahamas",
        'BH' => "Bahrain",
        'BD' => "Bangladesh",
        'BB' => "Barbados",
        'BY' => "Belarus",
        'BE' => "Belgium",
        'BZ' => "Belize",
        'BJ' => "Benin",
        'BM' => "Bermuda",
        'BT' => "Bhutan",
        'BO' => "Bolivia",
        'BQ' => "Caribbean Netherlands",
        'BA' => "Bosnia and Herzegovina",
        'BW' => "Botswana",
        'BV' => "Bouvet Island",
        'BR' => "Brazil",
        'IO' => "British Indian Ocean Territory",
        'BN' => "Brunei Darussalam",
        'BG' => "Bulgaria",
        'BF' => "Burkina Faso",
        'BI' => "Burundi",
        'KH' => "Cambodia",
        'CM' => "Cameroon",
        'CA' => "Canada",
        'CV' => "Cape Verde",
        'KY' => "Cayman Islands",
        'CF' => "Central African Republic",
        'TD' => "Chad",
        'CL' => "Chile",
        'CN' => "China",
        'CX' => "Christmas Island",
        'CC' => "Cocos (Keeling) Islands",
        'CO' => "Colombia",
        'KM' => "Comoros",
        'CG' => "Congo",
        'CD' => "Congo (DRC)",
        'CK' => "Cook Islands",
        'CR' => "Costa Rica",
        'CI' => "Côte d'Ivoire",
        'HR' => "Croatia",
        'CU' => "Cuba",
        'CW' => "Curaçao",
        'CY' => "Cyprus",
        'CZ' => "Czech Republic",
        'DK' => "Denmark",
        'DJ' => "Djibouti",
        'DM' => "Dominica",
        'DO' => "Dominican Republic",
        'EC' => "Ecuador",
        'EG' => "Egypt",
        'SV' => "El Salvador",
        'GQ' => 'Equatorial Guinea',
        'ER' => "Eritrea",
        'EE' => "Estonia",
        'ET' => "Ethiopia",
        'FK' => "Falkland Islands (Malvinas)",
        'FO' => "Faroe Islands",
        'FJ' => "Fiji",
        'FI' => "Finland",
        'FR' => "France",
        'GF' => "French Guiana",
        'PF' => "French Polynesia",
        'TF' => "French Southern Territories",
        'GA' => "Gabon",
        'GM' => "Gambia",
        'GE' => "Georgia",
        'DE' => "Germany",
        'GH' => "Ghana",
        'GI' => "Gibraltar",
        'GR' => "Greece",
        'GL' => "Greenland",
        'GD' => "Grenada",
        'GP' => "Guadeloupe",
        'GU' => "Guam",
        'GT' => "Guatemala",
        'GG' => "Guernsey",
        'GN' => "Guinea",
        'GW' => "Guinea-Bissau",
        'GY' => "Guyana",
        'HT' => "Haiti",
        'HM' => "Heard Island and McDonald Islands",
        'VA' => "Vatican City",
        'HN' => "Honduras",
        'HK' => "Hong Kong",
        'HU' => "Hungary",
        'IS' => "Iceland",
        'IN' => "India",
        'ID' => "Indonesia",
        'IR' => "Iran",
        'IQ' => "Iraq",
        'IE' => "Ireland",
        'IM' => "Isle of Man",
        'IL' => "Israel",
        'IT' => "Italy",
        'JM' => "Jamaica",
        'JP' => "Japan",
        'JE' => "Jersey",
        'JO' => "Jordan",
        'KZ' => "Kazakhstan",
        'KE' => "Kenya",
        'KI' => "Kiribati",
        'KP' => "Korea (DPRK)",
        'KR' => "Korea (ROK)",
        'KW' => "Kuwait",
        'KG' => "Kyrgyzstan",
        'LA' => "Laos",
        'LV' => "Latvia",
        'LB' => "Lebanon",
        'LS' => "Lesotho",
        'LR' => "Liberia",
        'LY' => "Libya",
        'LI' => "Liechtenstein",
        'LT' => "Lithuania",
        'LU' => "Luxembourg",
        'MO' => "Macao",
        'MG' => "Madagascar",
        'MW' => "Malawi",
        'MY' => "Malaysia",
        'MV' => "Maldives",
        'ML' => "Mali",
        'MT' => "Malta",
        'MH' => "Marshall Islands",
        'MQ' => "Martinique",
        'MR' => "Mauritania",
        'MU' => "Mauritius",
        'YT' => "Mayotte",
        'MX' => "Mexico",
        'FM' => "Micronesia",
        'MD' => "Moldova",
        'MC' => "Monaco",
        'MN' => "Mongolia",
        'ME' => "Montenegro",
        'MS' => "Montserrat",
        'MA' => "Morocco",
        'MZ' => "Mozambique",
        'MM' => "Myanmar",
        'NA' => "Namibia",
        'NR' => "Nauru",
        'NP' => "Nepal",
        'NL' => "Netherlands",
        'NC' => "New Caledonia",
        'NZ' => "New Zealand",
        'NI' => "Nicaragua",
        'NE' => "Niger",
        'NG' => "Nigeria",
        'NU' => "Niue",
        'NF' => "Norfolk Island",
        'MP' => "Northern Mariana Islands",
        'NO' => "Norway",
        'OM' => "Oman",
        'PK' => "Pakistan",
        'PW' => "Palau",
        'PS' => "Palestine",
        'PA' => "Panama",
        'PG' => "Papua New Guinea",
        'PY' => "Paraguay",
        'PE' => "Peru",
        'PH' => "Philippines",
        'PN' => "Pitcairn",
        'PL' => "Poland",
        'PT' => "Portugal",
        'PR' => "Puerto Rico",
        'QA' => "Qatar",
        'RE' => "Réunion",
        'RO' => "Romania",
        'RU' => "Russian Federation",
        'RW' => "Rwanda",
        'BL' => "Saint Barthélemy",
        'SH' => "Saint Helena",
        'KN' => "Saint Kitts and Nevis",
        'LC' => "Saint Lucia",
        'MF' => "Saint Martin (French)",
        'PM' => "Saint Pierre and Miquelon",
        'VC' => "Saint Vincent and the Grenadines",
        'WS' => "Samoa",
        'SM' => "San Marino",
        'ST' => "Sao Tome and Principe",
        'SA' => "Saudi Arabia",
        'SN' => "Senegal",
        'RS' => "Serbia",
        'SC' => "Seychelles",
        'SL' => "Sierra Leone",
        'SG' => "Singapore",
        'SX' => "Sint Maarten (Dutch)",
        'SK' => "Slovakia",
        'SI' => "Slovenia",
        'SB' => "Solomon Islands",
        'SO' => "Somalia",
        'ZA' => "South Africa",
        'GS' => 'Georgia and the South Sandwich Islands',
        'SS' => "South Sudan",
        'ES' => "Spain",
        'LK' => "Sri Lanka",
        'SD' => "Sudan",
        'SR' => "Suriname",
        'SJ' => "Svalbard and Jan Mayen",
        'SZ' => "Swaziland",
        'SE' => "Sweden",
        'CH' => "Switzerland",
        'SY' => "Syrian Arab Republic",
        'TW' => "Taiwan",
        'TJ' => "Tajikistan",
        'TZ' => "Tanzania",
        'TH' => "Thailand",
        'TL' => "Timor-Leste",
        'TG' => "Togo",
        'TK' => "Tokelau",
        'TO' => "Tonga",
        'TT' => "Trinidad and Tobago",
        'TN' => "Tunisia",
        'TR' => "Turkey",
        'TM' => "Turkmenistan",
        'TC' => "Turks and Caicos Islands",
        'TV' => "Tuvalu",
        'UG' => "Uganda",
        'UA' => "Ukraine",
        'AE' => "United Arab Emirates",
        'GB' => "United Kingdom",
        'US' => "United States",
        'UM' => "United States Minor Outlying Islands",
        'UY' => "Uruguay",
        'UZ' => "Uzbekistan",
        'VU' => "Vanuatu",
        'VE' => "Venezuela",
        'VN' => "Viet Nam",
        'WF' => "Wallis and Futuna",
        'EH' => "Western Sahara",
        'YE' => "Yemen",
        'ZM' => "Zambia",
        'ZW' => "Zimbabwe",

    ];

    $currCountryCodes = [ // Currency Code => Country Code

        'AFN' => 'AF',  // Afghan afghani
        'ALL' => 'AL',  // Albanian lek
        'DZD' => 'DZ',  // Algerian dinar
        'AOA' => 'AO',  // Angolan kwanza
        'ARS' => 'AR',  // Argentine peso
        'AMD' => 'AM',  // Armenian dram
        'AWG' => 'AW',  // Aruban florin
        'AUD' => 'AU',  // Australian dollar
        'AZN' => 'AZ',  // Azerbaijani manat
        'BHD' => 'BH',  // Bahraini dinar
        'BSD' => 'BS',  // Bahamian dollar
        'BDT' => 'BD',  // Bangladeshi taka
        'BBD' => 'BB',  // Barbadian dollar
        'BYN' => 'BY',  // Belarusian ruble
        'BZD' => 'BZ',  // Belize dollar
        'BMD' => 'BM',  // Bermudian dollar
        'BTN' => 'BT',  // Bhutanese ngultrum
        'BOB' => 'BO',  // Bolivian boliviano
        'BAM' => 'BA',  // Bosnia and Herzegovina convertible mark
        'BWP' => 'BW',  // Botswana pula
        'BRL' => 'BR',  // Brazilian real
        'GBP' => 'GB',  // British pound
        'BND' => 'BN',  // Brunei dollar
        'MMK' => 'MM',  // Burmese kyat
        'BIF' => 'BI',  // Burundian franc
        'KHR' => 'KH',  // Cambodian riel
        'CAD' => 'CA',  // Canadian dollar
        'CVE' => 'CV',  // Cape Verdean escudo
        'KYD' => 'KY',  // Cayman Islands dollar
        'XAF' => 'CF',  // Central African CFA franc
        'XPF' => 'PF',  // CFP franc
        'CLP' => 'CL',  // Chilean peso
        'CNY' => 'CN',  // Chinese yuan
        'COP' => 'CO',  // Colombian peso
        'KMF' => 'KM',  // Comorian franc
        'CDF' => 'CD',  // Congolese franc
        'CRC' => 'CR',  // Costa Rican colón
        'HRK' => 'HR',  // Croatian kuna
        'CUC' => 'CU',  // Cuban convertible peso
        'CUP' => 'CU',  // Cuban peso
        'CZK' => 'CZ',  // Czech koruna
        'DKK' => 'DK',  // Danish krone
        'DOP' => 'DO',  // Dominican peso
        'DJF' => 'DJ',  // Djiboutian franc
        'XCD' => 'XC',  // Eastern Caribbean dollar
        'EGP' => 'EG',  // Egyptian pound
        'ERN' => 'ER',  // Eritrean nakfa
        'ETB' => 'ET',  // Ethiopian birr
        'EUR' => 'EU',  // Euro
        'FKP' => 'FK',  // Falkland Islands pound
        'FJD' => 'FJ',  // Fijian dollar
        'GMD' => 'GM',  // Gambian dalasi
        'GEL' => 'GE',  // Georgian lari
        'GHS' => 'GH',  // Ghanaian cedi
        'GIP' => 'GI',  // Gibraltar pound
        'GTQ' => 'GT',  // Guatemalan quetzal
        'GGP' => 'GG',  // Guernsey pound
        'GNF' => 'GN',  // Guinean franc
        'GYD' => 'GY',  // Guyanese dollar
        'HTG' => 'HT',  // Haitian gourde
        'HNL' => 'HN',  // Honduran lempira
        'HKD' => 'HK',  // Hong Kong dollar
        'HUF' => 'HU',  // Hungarian forint
        'ISK' => 'IS',  // Icelandic króna
        'INR' => 'IN',  // Indian rupee
        'IDR' => 'ID',  // Indonesian rupiah
        'IRR' => 'IR',  // Iranian rial
        'IQD' => 'IQ',  // Iraqi dinar
        'ILS' => 'IL',  // Israeli new shekel
        'JMD' => 'JM',  // Jamaican dollar
        'JPY' => 'JP',  // Japanese yen
        'JEP' => 'JE',  // Jersey pound
        'JOD' => 'JO',  // Jordanian dinar
        'KZT' => 'KZ',  // Kazakhstani tenge
        'KES' => 'KE',  // Kenyan shilling
        'KID' => 'KI',  // Kiribati dollar
        'KGS' => 'KG',  // Kyrgyzstani som
        'KWD' => 'KW',  // Kuwaiti dinar
        'LAK' => 'LA',  // Lao kip
        'LBP' => 'LB',  // Lebanese pound
        'LSL' => 'LS',  // Lesotho loti
        'LRD' => 'LR',  // Liberian dollar
        'LYD' => 'LY',  // Libyan dinar
        'MOP' => 'MO',  // Macanese pataca
        'MKD' => 'MK',  // Macedonian denar
        'MGA' => 'MG',  // Malagasy ariary
        'MWK' => 'MW',  // Malawian kwacha
        'MYR' => 'MY',  // Malaysian ringgit
        'MVR' => 'MV',  // Maldivian rufiyaa
        'IMP' => 'IM',  // Manx pound
        'MRU' => 'MR',  // Mauritanian ouguiya
        'MUR' => 'MU',  // Mauritian rupee
        'MXN' => 'MX',  // Mexican peso
        'MDL' => 'MD',  // Moldovan leu
        'MNT' => 'MN',  // Mongolian tögrög
        'MAD' => 'MA',  // Moroccan dirham
        'MZN' => 'MZ',  // Mozambican metical
        'NAD' => 'NA',  // Namibian dollar
        'NPR' => 'NP',  // Nepalese rupee
        'ANG' => 'AN',  // Netherlands Antillean guilder
        'TWD' => 'TW',  // New Taiwan dollar
        'NZD' => 'NZ',  // New Zealand dollar
        'NIO' => 'NI',  // Nicaraguan córdoba
        'NGN' => 'NG',  // Nigerian naira
        'KPW' => 'KP',  // North Korean won
        'NOK' => 'NO',  // Norwegian krone
        'OMR' => 'OM',  // Omani rial
        'PKR' => 'PK',  // Pakistani rupee
        'PAB' => 'PA',  // Panamanian balboa
        'PGK' => 'PG',  // Papua New Guinean kina
        'PYG' => 'PY',  // Paraguayan guaraní
        'PEN' => 'PE',  // Peruvian sol
        'PHP' => 'PH',  // Philippine peso
        'PLN' => 'PL',  // Polish złoty
        'QAR' => 'QA',  // Qatari riyal
        'RON' => 'RO',  // Romanian leu
        'RUB' => 'RU',  // Russian ruble
        'RWF' => 'RW',  // Rwandan franc
        'SHP' => 'SH',  // Saint Helena pound
        'WST' => 'WS',  // Samoan tālā
        'STN' => 'ST',  // São Tomé and Príncipe dobra
        'SAR' => 'SA',  // Saudi riyal
        'RSD' => 'RS',  // Serbian dinar
        'SLL' => 'SL',  // Sierra Leonean leone
        'SGD' => 'SG',  // Singapore dollar
        'SOS' => 'SO',  // Somali shilling
        'SLS' => 'SL',  // Somaliland shilling
        'ZAR' => 'ZA',  // South African rand
        'KRW' => 'KR',  // South Korean won
        'SSP' => 'SS',  // South Sudanese pound
        'SRD' => 'SR',  // Surinamese dollar
        'SEK' => 'SE',  // Swedish krona
        'CHF' => 'CH',  // Swiss franc
        'LKR' => 'LK',  // Sri Lankan rupee
        'SZL' => 'SZ',  // Swazi lilangeni
        'SYP' => 'SY',  // Syrian pound
        'TJS' => 'TJ',  // Tajikistani somoni
        'TZS' => 'TZ',  // Tanzanian shilling
        'THB' => 'TH',  // Thai baht
        'TOP' => 'TO',  // Tongan paʻanga
        'PRB' => 'PR',  // Transnistrian ruble
        'TTD' => 'TT',  // Trinidad and Tobago dollar
        'TND' => 'TN',  // Tunisian dinar
        'TRY' => 'TR',  // Turkish lira
        'TMT' => 'TM',  // Turkmenistan manat
        'TVD' => 'TV',  // Tuvaluan dollar
        'UGX' => 'UG',  // Ugandan shilling
        'UAH' => 'UA',  // Ukrainian hryvnia
        'AED' => 'AE',  // United Arab Emirates dirham
        'USD' => 'US',  // United States dollar
        'UYU' => 'UY',  // Uruguayan peso
        'UZS' => 'UZ',  // Uzbekistani som
        'VUV' => 'VU',  // Vanuatu vatu
        'VEF' => 'VE',  // Venezuelan bolívar
        'VND' => 'VN',  // Vietnamese đồng
        'YER' => 'YE',  // Yemeni rial
        'ZMW' => 'ZM',  // Zambian kwacha
        'ZWL' => 'ZW'   // Zimbabwean dollar
    ];

    $currCodeNames = [ // Currency Names

        'AFN' => 'Afghan afghani',
        'ALL' => 'Albanian lek',
        'DZD' => 'Algerian dinar',
        'AOA' => 'Angolan kwanza',
        'ARS' => 'Argentine peso',
        'AMD' => 'Armenian dram',
        'AWG' => 'Aruban florin',
        'AUD' => 'Australian dollar',
        'AZN' => 'Azerbaijani manat',
        'BHD' => 'Bahraini dinar',
        'BSD' => 'Bahamian dollar',
        'BDT' => 'Bangladeshi taka',
        'BBD' => 'Barbadian dollar',
        'BYN' => 'Belarusian ruble',
        'BZD' => 'Belize dollar',
        'BMD' => 'Bermudian dollar',
        'BTN' => 'Bhutanese ngultrum',
        'BOB' => 'Bolivian boliviano',
        'BAM' => 'Bosnia and Herzegovina convertible mark',
        'BWP' => 'Botswana pula',
        'BRL' => 'Brazilian real',
        'GBP' => 'British pound',
        'BND' => 'Brunei dollar',
        'MMK' => 'Burmese kyat',
        'BIF' => 'Burundian franc',
        'KHR' => 'Cambodian riel',
        'CAD' => 'Canadian dollar',
        'CVE' => 'Cape Verdean escudo',
        'KYD' => 'Cayman Islands dollar',
        'XAF' => 'Central African CFA franc',
        'XPF' => 'CFP franc',
        'CLP' => 'Chilean peso',
        'CNY' => 'Chinese yuan',
        'COP' => 'Colombian peso',
        'KMF' => 'Comorian franc',
        'CDF' => 'Congolese franc',
        'CRC' => 'Costa Rican colón',
        'HRK' => 'Croatian kuna',
        'CUC' => 'Cuban convertible peso',
        'CUP' => 'Cuban peso',
        'CZK' => 'Czech koruna',
        'DKK' => 'Danish krone',
        'DOP' => 'Dominican peso',
        'DJF' => 'Djiboutian franc',
        'XCD' => 'Eastern Caribbean dollar',
        'EGP' => 'Egyptian pound',
        'ERN' => 'Eritrean nakfa',
        'ETB' => 'Ethiopian birr',
        'EUR' => 'Euro',
        'FKP' => 'Falkland Islands pound',
        'FJD' => 'Fijian dollar',
        'GMD' => 'Gambian dalasi',
        'GEL' => 'Georgian lari',
        'GHS' => 'Ghanaian cedi',
        'GIP' => 'Gibraltar pound',
        'GTQ' => 'Guatemalan quetzal',
        'GGP' => 'Guernsey pound',
        'GNF' => 'Guinean franc',
        'GYD' => 'Guyanese dollar',
        'HTG' => 'Haitian gourde',
        'HNL' => 'Honduran lempira',
        'HKD' => 'Hong Kong dollar',
        'HUF' => 'Hungarian forint',
        'ISK' => 'Icelandic króna',
        'INR' => 'Indian rupee',
        'IDR' => 'Indonesian rupiah',
        'IRR' => 'Iranian rial',
        'IQD' => 'Iraqi dinar',
        'ILS' => 'Israeli new shekel',
        'JMD' => 'Jamaican dollar',
        'JPY' => 'Japanese yen',
        'JEP' => 'Jersey pound',
        'JOD' => 'Jordanian dinar',
        'KZT' => 'Kazakhstani tenge',
        'KES' => 'Kenyan shilling',
        'KID' => 'Kiribati dollar',
        'KGS' => 'Kyrgyzstani som',
        'KWD' => 'Kuwaiti dinar',
        'LAK' => 'Lao kip',
        'LBP' => 'Lebanese pound',
        'LSL' => 'Lesotho loti',
        'LRD' => 'Liberian dollar',
        'LYD' => 'Libyan dinar',
        'MOP' => 'Macanese pataca',
        'MKD' => 'Macedonian denar',
        'MGA' => 'Malagasy ariary',
        'MWK' => 'Malawian kwacha',
        'MYR' => 'Malaysian ringgit',
        'MVR' => 'Maldivian rufiyaa',
        'IMP' => 'Manx pound',
        'MRU' => 'Mauritanian ouguiya',
        'MUR' => 'Mauritian rupee',
        'MXN' => 'Mexican peso',
        'MDL' => 'Moldovan leu',
        'MNT' => 'Mongolian tögrög',
        'MAD' => 'Moroccan dirham',
        'MZN' => 'Mozambican metical',
        'NAD' => 'Namibian dollar',
        'NPR' => 'Nepalese rupee',
        'ANG' => 'Netherlands Antillean guilder',
        'TWD' => 'New Taiwan dollar',
        'NZD' => 'New Zealand dollar',
        'NIO' => 'Nicaraguan córdoba',
        'NGN' => 'Nigerian naira',
        'KPW' => 'North Korean won',
        'NOK' => 'Norwegian krone',
        'OMR' => 'Omani rial',
        'PKR' => 'Pakistani rupee',
        'PAB' => 'Panamanian balboa',
        'PGK' => 'Papua New Guinean kina',
        'PYG' => 'Paraguayan guaraní',
        'PEN' => 'Peruvian sol',
        'PHP' => 'Philippine peso',
        'PLN' => 'Polish złoty',
        'QAR' => 'Qatari riyal',
        'RON' => 'Romanian leu',
        'RUB' => 'Russian ruble',
        'RWF' => 'Rwandan franc',
        'SHP' => 'Saint Helena pound',
        'WST' => 'Samoan tālā',
        'STN' => 'São Tomé and Príncipe dobra',
        'SAR' => 'Saudi riyal',
        'RSD' => 'Serbian dinar',
        'SLL' => 'Sierra Leonean leone',
        'SGD' => 'Singapore dollar',
        'SOS' => 'Somali shilling',
        'SLS' => 'Somaliland shilling',
        'ZAR' => 'South African rand',
        'KRW' => 'South Korean won',
        'SSP' => 'South Sudanese pound',
        'SRD' => 'Surinamese dollar',
        'SEK' => 'Swedish krona',
        'CHF' => 'Swiss franc',
        'LKR' => 'Sri Lankan rupee',
        'SZL' => 'Swazi lilangeni',
        'SYP' => 'Syrian pound',
        'TJS' => 'Tajikistani somoni',
        'TZS' => 'Tanzanian shilling',
        'THB' => 'Thai baht',
        'TOP' => 'Tongan paʻanga',
        'PRB' => 'Transnistrian ruble',
        'TTD' => 'Trinidad and Tobago dollar',
        'TND' => 'Tunisian dinar',
        'TRY' => 'Turkish lira',
        'TMT' => 'Turkmenistan manat',
        'TVD' => 'Tuvaluan dollar',
        'UGX' => 'Ugandan shilling',
        'UAH' => 'Ukrainian hryvnia',
        'AED' => 'United Arab Emirates dirham',
        'USD' => 'United States dollar',
        'UYU' => 'Uruguayan peso',
        'UZS' => 'Uzbekistani som',
        'VUV' => 'Vanuatu vatu',
        'VEF' => 'Venezuelan bolívar',
        'VND' => 'Vietnamese đồng',
        'YER' => 'Yemeni rial',
        'ZMW' => 'Zambian kwacha',
        'ZWL' => 'Zimbabwean dollar'
    ];    

    $currSymbol = [ // Currency Symbols

        'USD' => '$',
        'EUR' => '€',
        'GBP' => '£',
        'JPY' => '¥',
        'CAD' => 'C$',
        'AFN' => '؋',
        'ALL' => 'L',
        'DZD' => 'د.ج',
        'AOA' => 'Kz',
        'ARS' => '$',
        'AMD' => '֏',
        'AWG' => 'Afl.',
        'AUD' => 'A$',
        'AZN' => '₼',
        'BHD' => '.د.ب',
        'BSD' => 'B$',
        'BDT' => '৳',
        'BBD' => 'Bds$',
        'BYN' => 'Br',
        'BZD' => 'BZ$',
        'BMD' => 'B$',
        'BTN' => 'Nu.',
        'BOB' => 'Bs.',
        'BAM' => 'KM',
        'BWP' => 'P',
        'BRL' => 'R$',
        'BND' => 'B$',
        'MMK' => 'K',
        'BIF' => 'FBu',
        'KHR' => '៛',
        'CVE' => 'Esc',
        'KYD' => 'CI$',
        'XAF' => 'FCFA',
        'XPF' => '₣',
        'CLP' => '$',
        'CNY' => '¥',
        'COP' => '$',
        'KMF' => 'CF',
        'CDF' => 'FC',
        'CRC' => '₡',
        'HRK' => 'kn',
        'CUC' => '$',
        'CUP' => '$',
        'CZK' => 'Kč',
        'DKK' => 'kr',
        'DOP' => 'RD$',
        'DJF' => 'Fdj',
        'XCD' => '$',
        'EGP' => '£',
        'ERN' => 'Nfk',
        'ETB' => 'Br',
        'FKP' => '£',
        'FJD' => 'FJ$',
        'GMD' => 'D',
        'GEL' => '₾',
        'GHS' => 'GH₵',
        'GIP' => '£',
        'GTQ' => 'Q',
        'GGP' => '£',
        'GNF' => 'FG',
        'GYD' => 'G$',
        'HTG' => 'G',
        'HNL' => 'L',
        'HKD' => 'HK$',
        'HUF' => 'Ft',
        'ISK' => 'kr',
        'INR' => '₹',
        'IDR' => 'Rp',
        'IRR' => '﷼',
        'IQD' => 'ع.د',
        'ILS' => '₪',
        'JMD' => 'J$',
        'JEP' => '£',
        'JOD' => 'د.أ',
        'KZT' => '₸',
        'KES' => 'KSh',
        'KID' => 'A$',
        'KGS' => 'с',
        'KWD' => 'د.ك',
        'LAK' => '₭',
        'LBP' => 'ل.ل',
        'LSL' => 'M',
        'LRD' => 'L$',
        'LYD' => 'ل.د',
        'MOP' => 'P',
        'MKD' => 'ден',
        'MGA' => 'Ar',
        'MWK' => 'MK',
        'MYR' => 'RM',
        'MVR' => 'Rf',
        'IMP' => '£',
        'MRU' => 'UM',
        'MUR' => '₨',
        'MXN' => '$',
        'MDL' => 'L',
        'MNT' => '₮',
        'MAD' => 'د.م.',
        'MZN' => 'MT',
        'NAD' => 'N$',
        'NPR' => 'Rs',
        'ANG' => 'ƒ',
        'TWD' => 'NT$',
        'NZD' => 'NZ$',
        'NIO' => 'C$',
        'NGN' => '₦',
        'KPW' => '₩',
        'NOK' => 'kr',
        'OMR' => 'ر.ع.',
        'PKR' => '₨',
        'PAB' => 'B/.',
        'PGK' => 'K',
        'PYG' => 'Gs',
        'PEN' => 'S/.',
        'PHP' => '₱',
        'PLN' => 'zł',
        'QAR' => 'ر.ق',
        'RON' => 'lei',
        'RUB' => '₽',
        'RWF' => 'FRw',
        'SHP' => '£',
        'WST' => 'T',
        'STN' => 'Db',
        'SAR' => 'ر.س',
        'RSD' => 'Дин.',
        'SLL' => 'Le',
        'SGD' => 'S$',
        'SOS' => 'S',
        'SLS' => 'S',
        'ZAR' => 'R',
        'KRW' => '₩',
        'SSP' => '£',
        'SRD' => '$',
        'SEK' => 'kr',
        'CHF' => 'CHF',
        'LKR' => 'Rs',
        'SZL' => 'E',
        'SYP' => '£',
        'TJS' => 'ЅМ',
        'TZS' => 'TSh',
        'THB' => '฿',
        'TOP' => 'T$',
        'PRB' => '₽',
        'TTD' => 'TT$',
        'TND' => 'د.ت',
        'TRY' => '₺',
        'TMT' => 'm',
        'TVD' => 'A$',
        'UGX' => 'USh',
        'UAH' => '₴',
        'AED' => 'د.إ',
        'UYU' => '$U',
        'UZS' => 'лв',
        'VUV' => 'Vt',
        'VES' => 'Bs.S',
        'VND' => '₫',
        'XOF' => 'CFA',
        'ZMW' => 'K',
        'ZWB' => 'Z$'
    ];

    // Optimized File Upload Function

    function fileUpload($file, $storage, $prefix = null, $sizeLimit = null, $allowSVG = false, $allowICO = false, $allowPDF = false) {
        // Prepare Parameters
        $prefix = ($prefix != null) ? strtolower(trim($prefix, '-?\/%!#^')) . '-' : null;
        $storage = trim($storage);

        // $sizeLimit = $sizeLimit !== null ? $sizeLimit * 10000 : null; // Size Limit Is in KB Convert to Bits

        $sizeLimit = $sizeLimit !== null ? $sizeLimit * 1024 : null; // KB to bytes
    
        // Define Allowed MIME Types and Extensions
        $imageMIME = ['image/webp', 'image/png', 'image/jpeg'];
        $imageExts = ['webp', 'png', 'jpeg', 'jpg'];
    
        $svgMIME = ['image/svg+xml'];
        $svgExts = ['svg'];

        $icoMIME = ['image/x-icon'];
        $icoExts = ['ico'];
    
        $pdfMIME = ['application/pdf'];
        $pdfExts = ['pdf'];
    
        // Initialize allowed MIME and extensions as image types
        $allowedMIME = $imageMIME;
        $allowedExts = $imageExts;
    
        // Add SVG or PDF support if needed
        if ($allowSVG) {
            $allowedMIME = array_merge($allowedMIME, $svgMIME);
            $allowedExts = array_merge($allowedExts, $svgExts);
        }

        if ($allowICO) {
            $allowedMIME = array_merge($allowedMIME, $icoMIME);
            $allowedExts = array_merge($allowedExts, $icoExts);
        }
    
        if ($allowPDF) {
            $allowedMIME = array_merge($allowedMIME, $pdfMIME);
            $allowedExts = array_merge($allowedExts, $pdfExts);
        }
    
        // Quick file extension and MIME type checks
        $fileExt = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        if (!in_array($fileExt, $allowedExts)) {
            return ['status' => false, 'error' => 'Extension Error', 'message' => 'Invalid file extension. Allowed extensions are: ' . implode(', ', $allowedExts)];
        }
    
        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $fileMIME = finfo_file($finfo, $file['tmp_name']);
        finfo_close($finfo);
        
        if (!in_array($fileMIME, $allowedMIME)) {
            return ['status' => false, 'error' => 'MIME Error', 'message' => 'Invalid MIME type. Allowed MIME types are: ' . implode(', ', $allowedMIME)];
        }
    
        // Check file size limit if sizeLimit is provided
        if ($sizeLimit !== null && $file['size'] > $sizeLimit) {
            return ['status' => false, 'error' => 'Size Error', 'message' => 'File size exceeds the allowed limit of ' . ($sizeLimit / 1024 / 1024) . 'MB.'];
        }
    
        // Generate the new file name
        $fileName = $storage . $prefix . bin2hex(random_bytes(16)) . uniqid() . '.' . $fileExt;
    
        // Attempt to upload the file
        if (move_uploaded_file($file['tmp_name'], $fileName)) {
            return ['status' => true, 'vault' => $fileName];
        } else {
            return ['status' => false, 'error' =>  'Upload Error', 'message' => 'Failed to move the uploaded file to storage.'];
        }
    }    

    function generateUniqueID($dbConn, $table, $prefix = null) { // Generate Unique ID

        // Step 1: Query for an existing row's UUID
        $query = mysqli_prepare($dbConn, "SELECT UUID() AS `uuid` FROM `{$table}` LIMIT 1");
    
        mysqli_stmt_execute($query);
    
        $result = mysqli_stmt_get_result($query);
    
        // If the table is not empty, fetch the UUID
        if (mysqli_num_rows($result) > 0) {
            $data = mysqli_fetch_assoc($result);
            $uuid = $data['uuid'];
        } else {
            // If the table is empty, generate a new UUID directly in MySQL
            $query = mysqli_prepare($dbConn, "SELECT UUID() AS `uuid`");
            mysqli_stmt_execute($query);
            $result = mysqli_stmt_get_result($query);
            $data = mysqli_fetch_assoc($result);
            $uuid = $data['uuid'];
        }
    
        mysqli_free_result($result);
        mysqli_stmt_close($query);
    
        // Optionally add a prefix
        $prefix = $prefix !== null ? rtrim($prefix, '- ') . '-' : null;
    
        // Remove hyphens from UUID
        $hex = str_replace('-', '', $uuid);
    
        // Convert the hex string to decimal
        $decimal = base_convert($hex, 16, 10);  // Converts hex to base-10 (decimal)
    
        // Base62 characters (A-Z, a-z, 0-9)
        $chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $base = strlen($chars);
    
        // Convert the decimal number to Base62
        $base62 = '';
        while ($decimal > 0) {
            $remainder = bcmod($decimal, $base);
            $base62 = $chars[$remainder] . $base62;
            $decimal = bcdiv($decimal, $base);
        }
    
        return $prefix . $base62;
    }

    function uetrConvert($input) { // Convert Trans ID To UETR
        // Remove prefix like "TRN-" if it exists
        $cleaned = preg_replace('/^TRN-/', '', $input);

        // Hash the cleaned input to get a consistent fixed-length string
        $hash = md5($cleaned); // 32 hex characters

        // Split into segments similar to UUID (8-4-4-4-12)
        $uuid = substr($hash, 0, 8) . '-' .
                substr($hash, 8, 4) . '-' .
                substr($hash, 12, 4) . '-' .
                substr($hash, 16, 4) . '-' .
                substr($hash, 20, 12);

        return $uuid;
    }

    function maintenanceCheck() { // Maintenance Mode Check

        if (M_MODE == 'ON') {

            $mpage = SITE_BASE_URL . '/maintenance';

            header('location:' . $mpage); // Redirect

            exit; // End Run

        }

    }

    function encrypt($data, $key = null) { // Encryption Fxn

        $key = ($key == null) ? 'Zweite Entiwicklung. Z-machine~7' : $key; // Default Encryption Key 0720772jvx-jzzvt:Blue

        $initVector = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc')); // Generate Random Initialization Vector

        $encrytedData = openssl_encrypt($data, 'aes-256-cbc', $key, 0, $initVector); // Encrypt Data

        return base64_encode($initVector . $encrytedData); // Encode Base 64 Decryptable String

    }

    function decrypt($encryptedData, $key = null) { // Decryption Fxn

        $key = ($key == null) ? 'Zweite Entiwicklung. Z-machine~7' : $key; // Default Encryption Key 0720772jvx-jzzvt:Blue

        $data = base64_decode($encryptedData); // Decode Base 64 Decryptable String

        $ivLength = openssl_cipher_iv_length('aes-256-cbc'); // Determine Initialization Vector Length

        $initVector = substr($data, 0, $ivLength); // Extract Intialization Vector

        $encryptedText = substr($data, $ivLength); // Extract Encrypted Text

        return openssl_decrypt($encryptedText, 'aes-256-cbc', $key, 0, $initVector); // Decrypt Data

    }

    function generateOTP($user, $dbConn, $userType = 'USER') { // Generate OTP

        $table = 'users';

        $column = 'user_id';

        if ($userType == 'THIRD PARTY') {

            $table = 'third_party';

            $column = 'tp_id';

        }

        $query = "UPDATE `$table` SET `otp` = ?, `otp_validity` = ? WHERE `$column` = ?";

        $code = mt_rand(100000, 999999); // Generate OTP

        $expires = 5 * 60; // 5 Minutes

        $expiresIn = time() + $expires; // Calculate Time

        $expiresIn = date('Y-m-d H:i:s', $expiresIn); // Format

        // Update DB

        $stmt = mysqli_prepare($dbConn, $query); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "iss", $code, $expiresIn, $user); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        mysqli_stmt_close($stmt); // Close Statement

        return $code;

    } 
    
    function emailExists($email, $dbConn) { // Check If Email Exists (Is Unique)

        // Commence

        $match = false; // Flag

        $stmt = mysqli_prepare($dbConn, "SELECT `email` FROM `users` WHERE `email` = CAST(? AS BINARY) UNION SELECT `email` FROM `third_party` WHERE `email` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $email, $email); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) > 0) {

            $match = true; // Update Flag

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $match;

    }

    function tagExists($tag, $dbConn) { // Check If Tag Exists (Is Unique)

        // Commence

        $exists = false; // Flag

        $stmt = mysqli_prepare($dbConn, "SELECT * FROM `users` WHERE `username` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $tag); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result 

        if (mysqli_num_rows($result) > 0) {

            $exists = true; // Update Flag

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $exists;

    }

    function accountExists($number, $dbConn) { // Check If Account Number Exists

        // Commence

        $exists = false; // Flag

        $stmt = mysqli_prepare($dbConn, "SELECT * FROM `accounts` WHERE `acc_num` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $number); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result 

        if (mysqli_num_rows($result) > 0) {

            $exists = true; // Update Flag

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $exists;

    }

    function thirdPartyData($id, $dbConn) { // Get Third Party

        $found = false; // Flag

        $stmt = mysqli_prepare($dbConn, "SELECT * FROM `third_party` WHERE `tp_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $fname = $row['fname'];

                $mname = $row['mname'];

                $lname = $row['lname'];

                $password = $row['pre_hash'];

                $key = $row['password']; 

                $email = $row['email'];

                $code = $row['otp'];

                $validity = $row['otp_validity'];

                $transLimit = $row['trans_limit'];

                $transCount = $row['trans_count'];

                $wthLimit = $row['wth_limit'];

                $barred = $row['no_access'];

                $mainUser = $row['user_id'];

                $status = $row['status'];

                $bcode = $row['billing_code'];

                $gender = $row['gender'];

                $title = $row['title'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Consider Flag

        if ($found) {

            return [

                'firstname' => $fname,

                'middlename' => $mname,

                'lastname' => $lname,

                'raw-key' => $password,

                'password' => $key,

                'email' => $email,

                'code' => $code,

                'code-expires' => $validity,

                'trans-limit' => $transLimit,

                'trans-count' => $transCount,

                'wth-limit' => $wthLimit,

                'no-access' => $barred,

                'main-user' => $mainUser,

                'account-status' => $status,

                'bcode-status' => $bcode,

                'gender' => $gender,

                'title' => $title

            ];

        } else {

            return $found;

        }

    }

    function thirdPartyCount($id, $dbConn) { // Get Third Party Count

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_users` FROM `third_party` WHERE `user_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) === 1) {

            while ($row = mysqli_fetch_assoc($result)) {

                $num = $row['total_users'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function activeReferrals($id, $dbConn) { // Get Users Refferred Count

        $num = 0;

        // Get Users Refferred Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_referred` FROM `referrals` WHERE `referrer` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_referred'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function userData($id, $dbConn) { // Get User Data

        $found = false; // Flag

        $userInfo = mysqli_prepare($dbConn, "SELECT `A`.*, `B`.`status` AS `kyc_status`, `B`.`face`, `B`.`id_proof`, `B`.`id_proofBack`, `B`.`id_type`, `B`.`id_num`, `B`.`id_issued`, `B`.`id_expires`, `B`.`issuing_country` FROM `users` AS `A` LEFT JOIN `kyc_data` AS `B` ON CAST(`A`.`user_id` AS BINARY) = CAST(`B`.`user_id` AS BINARY) WHERE `A`.`user_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($userInfo, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($userInfo); // Execute Statement

        $result = mysqli_stmt_get_result($userInfo); // Get Statement Result

        if (mysqli_num_rows($result) === 1) { // Get Statement Mass

            $found = true;

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

            foreach ($data as $row):

                $avatar = $row['user_avatar'];

                $firstname = $row['fname'];

                $lastname = $row['lname'];

                $middlename = $row['mname'];

                $email = $row['email'];

                $password = $row['pre_hash'];

                $key = $row['password'];

                $code = $row['otp'];

                $validity = $row['otp_validity'];

                $tel = $row['telephone'];

                $tag = $row['username'];

                $sex = $row['gender'];

                $dob = $row['dob'];

                $auth = $row['factor_2FA'];

                $loginAlert = $row['login_alerts'];

                $regBy = $row['reg_by'];

                $regStatus = $row['reg_clearance'];

                $regDate = $row['reg_date'];

                $statusAcc = $row['acc_status'];

                $bcode = $row['billing_code'];

                $transfer = $row['transfers'];

                $tPin = $row['trans_pin'];

                $sQ1 = $row['question_1'];

                $sQ2 = $row['question_2'];

                $ans1 = $row['answer_1'];

                $ans2 = $row['answer_2'];

                $citizen = $row['nationality'];

                $zip = $row['zip_code'];

                $street= $row['street_address'];

                $city = $row['city'];

                $state = $row['state'];

                $country = $row['resident_country'];

                $job = $row['occupation'];

                $earnings = $row['earnings_range'];

                $religion = $row['religion'];

                $nFname = $row['nok_fname'];

                $nMname = $row['nok_mname'];

                $nLname = $row['nok_lname'];

                $nDob = $row['nok_dob'];

                $nRel = $row['nok_rel'];

                $nAddr = $row['nok_address'];

                $marital = $row['marital_status'];

                $kycBypass = $row['kyc_bypass'];

                $kycReal = $row['kyc_status'];

                $kyc = ($kycBypass == 'ON') ? 'VERIFIED' : $kycReal;

                $face = $row['face'];

                $proof = $row['id_proof'];

                $proofB = $row['id_proofBack'];

                $idType = $row['id_type'];

                $idNum = $row['id_num'];
                
                $idDate = $row['id_issued'];

                $idExpires = $row['id_expires'];

                $idCountry = $row['issuing_country'];

                $dob = $row['dob'];

                $credit = $row['credit_score'];

                $invest = $row['invest_by'];

            endforeach;   

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($userInfo); // Close Statement

        if ($found) {

            return [

                'profile-image' => $avatar,

                'firstname' => $firstname,

                'middlename' => $middlename,

                'lastname' => $lastname,

                'email' => $email,

                'raw-key' => $password,

                'code' => $code,

                'code-expires' => $validity,

                'key' => $key,

                'phone' => $tel,

                'tag' => $tag,

                'sex' => $sex,

                'dob' => $dob,

                'auth' => $auth,

                'login-alerts' => $loginAlert,

                'reg-by' => $regBy,

                'reg-status' => $regStatus,

                'reg-date' => $regDate,

                'account-status' => $statusAcc,

                'bcode-status' => $bcode,

                'transfer-status' => $transfer,

                'trans-pin' => $tPin,

                'secret-question' => $sQ1,

                'secret-questionB' => $sQ2,

                'answer-1' => $ans1,

                'answer-2' => $ans2,

                'citizen' => $citizen,

                'zip' => $zip,

                'street' => $street,

                'city' => $city,

                'state' => $state,

                'country' => $country,

                'job' => $job,

                'earnings' => $earnings,

                'religion' => $religion,

                'nok-firstname' => $nFname,

                'nok-middlename' => $nMname,

                'nok-lastname' => $nLname,

                'nok-dob' => $nDob,

                'nok-rel' => $nRel,

                'nok-address' => $nAddr,

                'marital' => $marital,

                'kyc-bypass' => $kycBypass,

                'kyc-real' => $kycReal,

                'kyc-status' => $kyc,

                'face-id' => $face,

                'proof-front' => $proof,

                'proof-back' => $proofB,

                'proof-type' => $idType,

                'id-num' => $idNum,

                'id-date' => $idDate,

                'id-expires' => $idExpires,

                'id-nation' => $idCountry,

                'dob' => $dob,

                'credit-score' => $credit,

                'investment-channel' => $invest, 

            ];

        } else {

            return false;

        }

    }

    function referralsCount($id, $dbConn) { // Get Number Of Referrals Sent

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_invites` FROM `invites` WHERE `referrer` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_invites'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function userAccounts($id, $dbConn) { // Get User Account(s) Data

        $found = false; // Flag

        $accounts = mysqli_prepare($dbConn, "SELECT `A`.*, COALESCE(`B`.`repay` - `B`.`paid`, 0) AS `pending_balance` FROM `accounts` AS `A` LEFT JOIN `loans` AS `B` ON `A`.`acc_id` = `B`.`acc_id` WHERE `A`.`user_id` = CAST(? AS BINARY) ORDER BY `A`.`class`  = ? DESC"); // Prepare Statement

        $class = 'PRIMARY';

        mysqli_stmt_bind_param($accounts, "ss", $id, $class); // Bind Parameters

        mysqli_stmt_execute($accounts); // Execute Statement

        $result = mysqli_stmt_get_result($accounts); // Get Statement Result

        if (mysqli_num_rows($result) > 0) { // Compare Result's Mass

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get $result Data

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($accounts); // Close Statement

        // Check Flag

        if ($found) {

            return $data;

        } else {

            return false;

        }

    }

    function jointAccounts($user, $dbConn) { // Check For Joint Accounts

        $found = false; // Flag

        $stmt = mysqli_prepare($dbConn, "SELECT * FROM `accounts` WHERE `type` = ? AND `user_id` = ?"); // Prepare Statement

        $param = 'JOINT';

        mysqli_stmt_bind_param($stmt, "ss", $param, $user); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) > 0) {

            $found = true; // Update Flag

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $found;

    }

    function accountData($id, $user, $dbConn) { // Get Specific Account Data

        $found = false; // Flag

        $account = mysqli_prepare($dbConn, "SELECT * FROM `accounts` AS `A` LEFT JOIN `banks` AS `B` ON `A`.`bank_id` = `B`.`bank_id` WHERE `A`.`acc_id` = CAST(? AS BINARY) AND `A`.`user_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($account, "ss", $id, $user); // Bind Parameters

        mysqli_stmt_execute($account); // Execute Statement

        $result = mysqli_stmt_get_result($account); // Get Statement Result

        if (mysqli_num_rows($result) > 0) { // Compare Result's Mass

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get $result Data

            foreach ($data as $row):

                $bal = $row['balance'];

                $currency = $row['currency'];

                $number = $row['acc_num'];

                $type = $row['type'];

                $class = $row['class'];

                $bankId = $row['bank_id'];

                $bank = $row['name'];

                $logo = $row['logo'];

                $branch = $row['branch'];

                $country = $row['country'];

                $codetype = $row['bank_codetype'];

                $code = $row['bank_code'];

                $wlimit = $row['wth_limit'];

                $wCount = $row['wth_count'];

                $wMax = $row['wth_max'];

            endforeach;    

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($account); // Close Statement

        // Check Flag

        if ($found) {

            return [

                'balance' => $bal,

                'currency' => $currency,

                'type' => $type,

                'class' => $class,

                'acc-number' => $number,

                'bank-id' => $bankId,

                'bank' => $bank,

                'bank-logo' => $logo,

                'bank-branch' => $branch,

                'bank-loc' => $country,

                'code-type' => $codetype,

                'code' => $code,

                'wth-count' => $wCount,
                
                'wth-max-count' => $wMax,

                'wth-limit' => $wlimit,

            ];

        } else {

            return false;

        }

    }    

    function currencyAccountData($currency, $user, $dbConn) { // Get Specific Currency Account Data

        $found = false; // Flag

        $account = mysqli_prepare($dbConn, "SELECT * FROM `accounts` AS `A` LEFT JOIN `banks` AS `B` ON `A`.`bank_id` = `B`.`bank_id` WHERE `A`.`currency` = CAST(? AS BINARY) AND `A`.`user_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($account, "ss", $currency, $user); // Bind Parameters

        mysqli_stmt_execute($account); // Execute Statement

        $result = mysqli_stmt_get_result($account); // Get Statement Result

        if (mysqli_num_rows($result) > 0) { // Compare Result's Mass

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get $result Data

            foreach ($data as $row):

                $id = $row['acc_id'];

                $bal = $row['balance'];

                $currency = $row['currency'];

                $number = $row['acc_num'];

                $type = $row['type'];

                $class = $row['class'];

                $bank = $row['name'];

                $logo = $row['logo'];

                $branch = $row['branch'];

                $country = $row['country'];

                $codetype = $row['bank_codetype'];

                $code = $row['bank_code'];

            endforeach;    

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($account); // Close Statement

        // Check Flag

        if ($found) {

            return [

                'acc-id' => $id,

                'balance' => $bal,

                'currency' => $currency,

                'type' => $type,

                'class' => $class,

                'acc-number' => $number,

                'bank' => $bank,

                'bank-logo' => $logo,

                'bank-branch' => $branch,

                'bank-loc' => $country,

                'code-type' => $codetype,

                'code' => $code

            ];

        } else {

            return false;

        }

    }    

    function bcodeCount($id, $dbConn) { // Get Billing Code Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_codes` FROM `billing_codes` WHERE `user_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_codes'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function currentBcode($id, $dbConn, $offset) { // Get Current Billing Code

        // Locate Code

        $query = "SELECT * FROM `billing_codes` WHERE `user_id` = CAST(? AS BINARY) LIMIT 1 OFFSET ?";

        $stmt = mysqli_prepare($dbConn, $query); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "si", $id, $offset); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {
            
            $id = $row['code_id'];
            
            $code = $row['code'];

            $error = $row['error_code'];

            $name = $row['name'];

            $abbr = $row['abbr'];

            $directive = $row['directive'];

            $desc = $row['descr'];

            $msg = $row['message'];

            $type = $row['type'];

            $percentage = $row['percentage'];

            $amount = $row['amount'];

            $payment = $row['payment_method'];

            $status = $row['status'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return [

            'PIN-ID' => $id,

            'PIN' => $code,

            'PIN-status' => $status,

            'PIN-abbr' => $abbr,

            'PIN-name' => $name,

            'PIN-directive' => $directive,

            'PIN-msg' => $msg,

            'PIN-descr' => $desc,

            'PIN-type' => $type,

            'PIN-error' => $error,

            'PIN-percent' => $percentage,

            'PIN-amount' => $amount,

            'PIN-payment' => $payment

        ];

    }
    
    function bcodeData($id, $dbConn) { // Get Billing Code Data

        $found = false; // Flag

        // Locate Code

        $query = "SELECT * FROM `billing_codes` WHERE `code_id` = CAST(? AS BINARY)";

        $stmt = mysqli_prepare($dbConn, $query); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {
                
                $id = $row['code_id'];
                
                $code = $row['code'];

                $error = $row['error_code'];

                $name = $row['name'];

                $abbr = $row['abbr'];

                $directive = $row['directive'];

                $desc = $row['descr'];

                $msg = $row['message'];

                $type = $row['type'];

                $percentage = $row['percentage'];

                $amount = $row['amount'];

                $payment = $row['payment_method'];

                $status = $row['status'];

                $user = $row['user_id'];

            }

        }    

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if ($found) {

            return [

                'PIN-ID' => $id,

                'PIN' => $code,

                'PIN-status' => $status,

                'PIN-abbr' => $abbr,

                'PIN-name' => $name,

                'PIN-directive' => $directive,

                'PIN-msg' => $msg,

                'PIN-descr' => $desc,

                'PIN-type' => $type,

                'PIN-error' => $error,

                'PIN-percent' => $percentage,

                'PIN-amount' => $amount,

                'PIN-payment' => $payment,

                'user' => $user

            ];

        } else {

            return false;

        }    

    }

    function cardData($id, $dbConn) { // Get Virtual Card Data

        $found = false; // Flag

        $stmt = mysqli_prepare($dbConn, "SELECT * FROM `virtual_cards` WHERE `card_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameters

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) > 0) { // Compare Result's Mass

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get $result Data

            foreach ($data as $row):

                $bal = $row['balance'];

                $currency = $row['currency'];
                
                $provider = $row['provider'];

                $number = $row['card_number'];

                $cvv = $row['cvv'];

                $fund = $row['fund_by'];

                $status = $row['status'];

                $color = $row['color'];

                $expires = $row['expires'];

            endforeach;    

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Check Flag

        if ($found) {

            return [

                'balance' => $bal,

                'currency' => $currency,

                'provider' => $provider,

                'card-number' => $number,

                'cvv' => $cvv,

                'fund' => $fund,

                'status' => $status,

                'color' => $color,

                'expires' => $expires

            ];

        } else {

            return false;

        }

    }

    function planData($id, $dbConn) { // Get Investment Plan Data

        $found = false; // Flag

        $stmt = mysqli_prepare($dbConn, "SELECT * FROM `investments` WHERE `inv_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameters

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) > 0) { // Compare Result's Mass

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get $result Data

            foreach ($data as $row):

                $name = $row['name'];

                $category = $row['category'];
                
                $min = $row['min_amount'];

                $max = $row['max_amount'];

                $interest = $row['interest_rate'];

                $return = $row['return_type'];

                $payout = $row['frequency'];

                $descr = $row['descr'];

                $image = $row['image'];

                $risk = $row['risk_factor'];

                $duration = $row['duration'];

                $timing = $row['timing'];

                $factor = $row['timing_unit'];

            endforeach;    

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Check Flag

        if ($found) {

            return [

                'name' => $name,

                'type' => $category,

                'min' => $min,

                'max' => $max,

                'interest' => $interest,

                'return' => $return,

                'payout' => $payout,

                'descr' => $descr,

                'image' => $image,

                'risk' => $risk,

                'lifetime' => $duration,

                'timing' => $timing,

                'factor' => $factor

            ];

        } else {

            return false;

        }

    }

    function bankData($id, $dbConn) { // Get Investment Plan Data

        $found = false; // Flag

        $stmt = mysqli_prepare($dbConn, "SELECT * FROM `banks` WHERE `bank_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameters

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) > 0) { // Compare Result's Mass

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get $result Data

            foreach ($data as $row):

                $name = $row['name'];

                $logo = $row['logo'];
                
                $country = $row['country'];

                $branch = $row['branch'];

                $code = $row['bank_code'];

                $codeType = $row['bank_codetype'];

            endforeach;    

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Check Flag

        if ($found) {

            return [

                'bank-name' => $name,

                'bank-logo' => $logo,

                'country-code' => $country,

                'branch' => $branch,

                'banking-code' => $code,

                'banking-code-type' => $codeType

            ];

        } else {

            return false;

        }

    }

    function timingFactor($factor, $dbconn) { // Timing Factor 

        $found = false;

        $stmt = mysqli_prepare($dbconn, "SELECT * FROM `timing_factors` WHERE `factor` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $factor); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) > 0) {

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $days = $row['days'];

                $hours = $row['hours'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if ($found) {

            return [

                'days' => $days,

                'hours' => $hours

            ];

        } else {

            return false;
            
        }

    }

    function accountCount($id, $dbConn) { // User Accounts Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_accounts` FROM `accounts` WHERE `user_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_accounts'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }    

    function transCount($id, $dbConn) { // User Transactions Count

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_trans` FROM `transactions` WHERE `user_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement
        
        $result = mysqli_stmt_get_result($stmt);

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_trans'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function vCardCount($id, $dbConn) { // User Virtual Card Count

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_cards` FROM `virtual_cards` WHERE `user_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement
        
        $result = mysqli_stmt_get_result($stmt);

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_cards'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function invoiceCount($id, $dbConn) { // User Invoices Count

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_invoices` FROM `invoices` WHERE `user_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement
        
        $result = mysqli_stmt_get_result($stmt);

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_invoices'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function subsCount($id, $dbConn) { // User Subscriptions Count

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_subs` FROM `subscriptions` WHERE `user_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement
        
        $result = mysqli_stmt_get_result($stmt);

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_subs'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function loanCount($id, $dbConn) { // User Loan Count

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_loans` FROM `loans` WHERE `user_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement
        
        $result = mysqli_stmt_get_result($stmt);

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_loans'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function paymentCount($dbConn) { // Payment Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_payments` FROM `payments`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_payments'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function investmentCount($dbConn) { // Investment Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_investments` FROM `investments`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_investments'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function paidInvoicesCount($dbConn) { // Invoice Payment Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_payments` FROM `invoice_payments`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_payments'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function requestsCount($dbConn) { // Invoice Payment Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_requests` FROM `requests`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_requests'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function loanRequestsCount($dbConn) { // Loan Requests Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_requests` FROM `loan_requests`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_requests'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function loansCount($dbConn) { // Loan Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_loans` FROM `loans`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_loans'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function transactionsCount($dbConn) { // Transactions Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_transactions` FROM `transactions`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_transactions'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function depositsCount($dbConn) { // Deposits Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_deposits` FROM `deposits`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_deposits'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function transfersCount($dbConn) { // Transfers Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_transfers` FROM `transactions` WHERE `action` = ? OR `action` = ?"); // Prepare Statement

        $param = 'CROSS-BORDER TRANSFER';

        $paramB = 'LOCAL TRANSFER';

        mysqli_stmt_bind_param($stmt, "ss", $param, $paramB); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_transfers'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function ticketsCount($dbConn) { // Ticket Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_tickets` FROM `support_tickets`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_tickets'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function cardsCount($dbConn) { // Cards Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_cards` FROM `virtual_cards`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_cards'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function kycCount($dbConn) { // KYC Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_applications` FROM `kyc_data`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total_applications'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

    function ticketData($id, $dbConn) { // Get Support Ticket Data

        $found = false; // Flag

        $stmt = mysqli_prepare($dbConn, "SELECT `A`.*, `B`.`fname`, `B`.`lname`, `B`.`user_avatar` FROM `support_tickets` AS `A` LEFT JOIN `users` AS `B` ON `A`.`user_id` = `B`.`user_id` WHERE `A`.`ticket_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) === 1) { // Get Statement Mass

            $found = true;

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

            foreach ($data as $row):

                $created = $row['created_at'];

                $user = join(' ', [$row['fname'], $row['lname']]);

                $title = $row['title'];

                $status = $row['status'];
                
            endforeach;

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if ($found) {

            return [

                'title' => $title,

                'user' => $user,

                'created' => $created,

                'status' => $status

            ];

        } else {

            return false;

        }

    }

    function checkCustomerEmail($email, $dbConn) { // Check If Customer Email Exists (Is Unique)

        // Commence

        $match = false; // Flag

        $stmt = mysqli_prepare($dbConn, "SELECT `email` FROM `customers` WHERE `email` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $email); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) === 1) {

            $match = true; // Update Flag

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $match;

    }

    function customersData($id, $dbConn) { // Get User Customers(s) Data

        $found = false; // Flag

        $stmt = mysqli_prepare($dbConn, "SELECT * FROM `customers` WHERE `user_id` = ? ORDER BY `name` DESC"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameters

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) > 0) { // Compare Result's Mass

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get $result Data

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Check Flag

        if ($found) {

            return $data;

        } else {

            return false;

        }

    }

    function customerData($id, $dbConn) { // Get Specific Customer Data

        $found = false; // Flag

        $stmt = mysqli_prepare($dbConn, "SELECT * FROM `customers` WHERE `customer_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameters

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) > 0) { // Compare Result's Mass

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get $result Data

            foreach ($data as $row):

                $name = $row['name'];

                $email = $row['email'];
                
                $street = $row['address'];

                $city = $row['city'];

                $state = $row['state'];

                $country = $row['country'];

                $zip = $row['zip'];

            endforeach;    

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Check Flag

        if ($found) {

            return [

                'name' => $name,

                'email' => $email,

                'street' => $street,

                'city' => $city,

                'state' => $state,

                'zip-code' => $zip,

                'country' => $country

            ];

        } else {

            return false;

        }

    }

    function updateWthCount ($id, $dbConn) { // Update Withdrawal Count

        $stmt = mysqli_prepare($dbConn, "UPDATE `accounts` SET `wth_count` = `wth_count` + 1 WHERE `acc_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement 

    }

    function updateJointUserTransCount ($id, $dbConn) { // Update Third Party Transaction Count

        $stmt = mysqli_prepare($dbConn, "UPDATE `third_party` SET `trans_count` = `trans_count` + 1 WHERE `tp_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement 

    }

    function invoiceData($id, $dbConn) { // Get Invoice Data

        $found = false; // Flag

        $stmt = mysqli_prepare($dbConn, "SELECT `A`.*, `B`.*, `C`.`user_id`, `C`.`email` AS `user_email`, `C`.`fname` AS `user_fname`, `C`.`mname` AS `user_mname`, `C`.`lname` AS `user_lname` FROM `invoices` AS `A` JOIN `customers` AS `B` ON `A`.`customer_id` = `B`.`customer_id` JOIN `users` AS `C` ON `A`.`user_id` = `C`.`user_id` WHERE `A`.`invoice_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement 

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

            foreach ($data as $row):

                $user = join(' ', [$row['user_fname'], $row['user_mname'], $row['user_lname']]);

                $userEmail = $row['user_email'];

                $customer = $row['name'];

                $customerEmail = $row['email'];

                $payer = $row['customer_id'];

                $recipient = $row['user_id'];

                $street = $row['address'];

                $city = $row['city'];

                $state = $row['state'];

                $country = $row['country'];

                $zip = $row['zip'];

                $num = $row['inv_num'];

                $title = $row['title'];

                $currency = $row['currency'];

                $descr = $row['descr'];

                $items = $row['items'];

                $qty = $row['qty'];

                $prices = $row['prices'];

                $discount = $row['discount'];

                $discountType = $row['discount_type'];

                $credit = $row['credit'];

                $tax = $row['tax'];

                $taxType = $row['tax_type'];

                $created = $row['created'];

                $due = $row['due'];

                $status = $row['status'];

                $amount = $row['payable_amount'];

                $taxProtocol = $row['tax_first'];

            endforeach;

        }

        if ($found) {

            return [

                'user' => $user,

                'user-email' => $userEmail,

                'customer' => $customer,

                'customer-email' => $customerEmail,

                'customer-id' => $payer,

                'user-id' => $recipient,

                'street' => $street,

                'city' => $city,

                'state' => $state,

                'country' => $country,

                'zip-code' => $zip,

                'invoice-number' => $num,

                'invoice-title' => $title,

                'currency' => $currency,

                'notes' => $descr,

                'items-list' => $items,

                'quantities-list' => $qty,

                'prices-list' => $prices,

                'discount' => $discount,

                'discount-type' => $discountType,

                'credit' => $credit,

                'tax-first' => $taxProtocol,

                'tax' => $tax,

                'tax-type' => $taxType,

                'created' => $created,

                'due' => $due,

                'status' => $status,

                'total' => $amount,

            ];

        } else {

            return false;

        }

    }

    function invoiceTotal($quantities, $prices, $owed, $discount, $discountType, $tax, $taxType, $taxAfterDiscount = true) { // Calculate Invoice Total
        $amounts = [];

        // Convert string lists to arrays
        $quantities = explode(',', $quantities);
        $prices = explode(',', $prices);

        // Calculate line item amounts
        for ($i = 0; $i < count($prices); $i++) {
            $qty = isset($quantities[$i]) ? trim($quantities[$i]) : '1';
            $price = trim($prices[$i]);

            // Normalize qty and price
            $qty = (strtolower($qty) === 'null' || $qty === '') ? 1 : (int)$qty;
            $price = (strtolower($price) === 'null' || $price === '') ? 0 : (float)$price;

            $amounts[] = $qty * $price;
        }

        $amount = array_sum($amounts);

        // Apply discount
        if ($discount) {
            if (strtoupper($discountType) === 'PERCENTAGE') {
                $discountAmount = ($discount / 100) * $amount;
            } else {
                $discountAmount = (float)$discount;
            }
        } else {
            $discountAmount = 0;
        }

        if ($tax) {
            if (strtoupper($taxType) === 'PERCENTAGE') {
                if ($taxAfterDiscount) {
                    $taxAmount = ($tax / 100) * ($amount - $discountAmount);
                } else {
                    $taxAmount = ($tax / 100) * $amount;
                }
            } else {
                $taxAmount = (float)$tax;
            }
        } else {
            $taxAmount = 0;
        }

        $amount = $amount - $discountAmount + $taxAmount;

        // Add owed
        if ($owed) {
            $amount += (float)$owed;
        }

        return round($amount, 2);
    }

    function dashboardAccess() { // Check Dashboard Access

        if (!isset($_SESSION['USER-ID']) || !isset($_SESSION['ACCESS']) || !isset($_SESSION['USER-TYPE']) || !isset($_SESSION['CURRENT-USER'])) {

            $_SESSION = [];

            session_destroy(); // Destroy Sessions

            // Redirect to Landing Page

            header('location: ../auth/');

            exit; // End Run

        } 

        return [

            'current-user' => $_SESSION['CURRENT-USER'],

            'main-user' => $_SESSION['USER-ID'],

            'user-type' => $_SESSION['USER-TYPE'],

        ];

    }

    function blockThirdParty() { // Bar Joint User

        if ($_SESSION['USER-TYPE'] == 'THIRD PARTY') {

            // header('location: home');

            echo "<script>
            
                popup({
                
                    header: 'ACCESS BARRED!',

                    title: 'Access Denied!',

                    text: 'You do not possess access privilege to be on this page!',

                    type: 'warning'
                
                }).then(() => {
                
                    window.history.back(-1);
                
                });

            </script>";

            exit;

        }

    }

    function validateUser($dbConn, $id) { // Validate User

        $valid = false; // Flag

        // Locate User

        $user = mysqli_prepare($dbConn, "SELECT * FROM `users` WHERE `user_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($user, "s", $id); // Bind Parameters

        mysqli_stmt_execute($user); // Execute Statement

        $result = mysqli_stmt_get_result($user); // Get Result

        if (mysqli_num_rows($result) === 1) {

            $valid = true; // Update Flag

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($user); // Close Statement

        if (!$valid) {

            $_SESSION = [];

            session_destroy(); // Destroy Sessions

            // Redirect to Landing Page

            header('location: ../auth/');

            exit; // End Run

        }

    }

    function getIP() { // Get IP Address

        if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {

            return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];

        } else if (isset($_SERVER['HTTP_CLIENT_IP'])) {

            return $_SERVER['HTTP_CLIENT_IP'];
        
        }

        return $_SERVER['REMOTE_ADDR'];

    }

    function setupIP_APIs($ip, $url) { // API Setup For IP Data Retrival

        $response = @file_get_contents($url); // Commence Data Retrieval

        if ($response === FALSE) { // Retrieval 

            error_log("Error retrieving data from API for IP: $ip"); // Log Error

            return null;

        }

        $data = json_decode($response, true); // Gain Retrieved Data

        if (json_last_error() !== JSON_ERROR_NONE) {

            error_log("JSON decoding failed: " . json_last_error_msg());
            
            return null;            

        }

        return $data;

    }

    function retrieveIPData($ip) { // Retrieve Info From IP Address

        $served = true; // Flag (API Data Return)

        $data = setupIP_APIs($ip, "https://freeipapi.com/api/json/$ip"); // Main API

        if (is_null($data) || (isset($data['status']) && $data['status'] === 'fail')) { // Main API Failure

            $response = @file_get_contents("http://www.geoplugin.net/php.gp?ip=$ip"); // Fallback API

            if ($response === FALSE) { // Fallback API Failure

                $served = false; // Update Flag

                return ['error' => 'Data Retrieval Failed!'];

            }

            $data = unserialize($response); // Unserialize Fallback API Response

            if (!is_array($data) || (isset($data['geoplugin_status']) && !$data['geoplugin_status'])) { // Fallback API 

                $served = false; // Update Flag

                return ['error' => 'Data Retrieval Failed!'];

            }

        }

        // Check Flag

        if ($served) {

            // Normalize Data

            $ipAddress = $data['ipAddress'] ?? ($data['geoplugin_request'] ?? $ip);

            $country = $data['countryName'] ?? ($data['geoplugin_countryName'] ?? null);

            $city = $data['cityName'] ?? ($data['geoplugin_city'] ?? null);

            $region = $data['regionName'] ?? ($data['geoplugin_regionName'] ?? null);

            $latitude = $data['latitude'] ?? ($data['geoplugin_latitude'] ?? null);

            $longitude = $data['longitude'] ?? ($data['geoplugin_longitude'] ?? null);

            $country_code = strtolower($data['countryCode'] ?? ($data['geoplugin_countryCode'])) ?? null;

            // Handle Timezone

            $timezoneArray = $data['timeZones'] ?? []; // From primary API

            $timezone = (is_array($timezoneArray) && !empty($timezoneArray)) ? $timezoneArray[0] : ($data['geoplugin_timezone'] ?? 'N/A'); // From fallback API

            return [

                'ip' => $ipAddress,
                
                'timezone' => $timezone,

                'country-code' => $country_code,

                'country' => $country,

                'city' => $city,

                'region' => $region,

                'latitude' => $latitude,

                'longitude' => $longitude
                
            ];

        } else {

            return false;

        }

    }

    function setTimezone($dbConn, $token, $user, $userType) { // Set User Time Zone 

        $timezone = 'GMT';

        if ($userType === 'THIRD PARTY') {

            $timezone = $_SESSION['TIMEZONE'] ?? 'GMT';
             
        } else {

            $found = false; // Flag

            $stmt = mysqli_prepare($dbConn, "SELECT `timezone` FROM `activity_logs` WHERE `token` = ? AND `user_id` = ?");

            mysqli_stmt_bind_param($stmt, "ss", $token, $user); // Bind Parameter(s)

            mysqli_stmt_execute($stmt); // Execute Statement

            $result = mysqli_stmt_get_result($stmt); // Get Result

            if (mysqli_num_rows($result) === 1) {

                $found = true; // Update Flag

                while ($row = mysqli_fetch_assoc($result)) {

                    $timezone = $row['timezone'];

                }

            }

            mysqli_free_result($result); // Free Result

            mysqli_stmt_close($stmt); // Close Statement

            // Check Flag

            $timezone = ($found) ? $timezone : 'GMT';

        }

        // Commence TimeZone Validation

        $validTimeZones = DateTimeZone::listIdentifiers(); // Valid Timezones

        if (!in_array($timezone, $validTimeZones)) { // Validate Timezone

            $timezone = 'GMT'; // Revert To Default Timezone

        }
        
        @date_default_timezone_set($timezone); // Set Time Zone

    }

    function login($dbConn, $identifier, $password) { // Handle Login

        // Commence Login Validation

        $valid = false; // Flag

        $query = "(SELECT DISTINCT NULL AS `tp_id`, `A`.`user_id`, `A`.`email`, `A`.`email` AS `main_email`, `A`.`fname`, `A`.`lname`, `A`.`acc_status`, `A`.`acc_status` AS `main_status`, `A`.`factor_2FA`, `A`.`login_alerts`, `A`.`reg_by`, `A`.`question_1`, `A`.`reg_clearance`, 'USER' AS `user_type`, `A`.`fname` AS `main_fname`, `A`.`lname` AS `main_lname` FROM `users` AS `A` LEFT JOIN `accounts` AS `B` ON `A`.`user_id` = `B`.`user_id` WHERE ((`A`.`email` = CAST(? AS BINARY) OR `A`.`username` = CAST(? AS BINARY) OR `B`.`acc_num` = CAST(? AS BINARY)) AND `A`.`password` = ?)) UNION ALL (SELECT TP.`tp_id`, TP.`user_id`, TP.`email`, U.`email` AS `main_email`, TP.`fname`, TP.`lname`, TP.`status` AS `acc_status`, `U`.`acc_status` AS `main_status`, NULL AS `factor_2FA`, 'ENABLED' AS `login_alerts`, NULL AS `reg_by`, NULL AS `question_1`, 'CLEARED' AS `reg_clearance`, 'THIRD PARTY' AS `user_type`, U.`fname` AS `main_fname`, U.`lname` AS `main_lname` FROM `third_party` AS TP INNER JOIN `users` AS U ON TP.`user_id` = U.`user_id` WHERE TP.`email` = CAST(? AS BINARY) AND TP.`password` = ?)";
        
        $stmt = mysqli_prepare($dbConn, $query); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ssssss", $identifier, $identifier, $identifier, $password, $identifier, $password); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) === 1) {

            $valid = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $user = $row['user_type'];

                $thirdParty = $row['tp_id'] ?? null;

                $userID = $row['user_id'];

                $email = $row['email'];

                $emailMain = $row['main_email'];

                $fnameMain = $row['main_fname'];

                $nameMain = join(' ', [$row['main_fname'], $row['main_lname']]);

                $fname = $row['fname'];

                $lname = $row['lname'];

                $statusMain = $row['main_status'];

                $status = $row['acc_status'] ?? null;

                $auth = $row['factor_2FA'] ?? null;

                $alert = $row['login_alerts'] ?? null;
                
                $registered = $row['reg_by'] ?? null;

                $constraint  = $row['question_1'] ?? null;

                $cleared = $row['reg_clearance'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Check Flag

        if ($valid) {

            return [

                'user-type' => $user,

                'joint-user' => $thirdParty,

                'id' => $userID,

                'main-email' => $emailMain,

                'main-fname' => $fnameMain,

                'main-name' => $nameMain,

                'email' => $email,

                'firstname' => $fname,

                'lastname' => $lname,

                'status' => $status,

                'main-status' => $statusMain,

                'auth' => $auth,

                'login-alerts' => $alert,

                'registered-by' => $registered,

                'reg-constraint' => $constraint,

                'reg-clearance' => $cleared

            ];

        } else {

            return false;

        }

    }

    function createNotification($dbConn, $user, $title, $message) { // Create Notification

        // Commence Creation

        $id = generateUniqueID($dbConn, 'notifications', 'NOTF'); // Generate Unique ID

        $date = timeGMT('Y-m-d'); // Get UTC Date

        $stmt  = mysqli_prepare($dbConn, "INSERT INTO `notifications` (`notf_id`, `user_id`, `title`, `message_text`, `date_created`) VALUES(?, ?, ?, ?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssss", $id, $user, $title, $message, $date); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        mysqli_stmt_close($stmt); // Close Statement

    }

    function activityLog($dbConn, $user, $device, $browser, $browserVersion, $os, $osVersion, $token, $ip, $timezone, $city, $region, $country, $countryCode, $lat, $long) { // Create Activity Log

        $browserData = (is_null($browser) ? 'UNKNOWN' : $browser) . (is_null($browserVersion) ? null : ' ' . $browserVersion);

        $deviceData = $device . (is_null($os) ? 'UNIDENTIFIED' : ', ' . $os) . (is_null($osVersion) ? null : ' ' . $osVersion);

        $datetime  = date('Y-m-d H:i:s', time());

        $location = implode(', ', array_filter([$city, $region, $country], fn($part) => !is_null($part) && $part !== ''));

        // Record / Update Access Priviledge

        $stmt = mysqli_prepare($dbConn, "INSERT INTO `users_activity` (`user_id`, `ip_address`, `cookie`, `country_code`) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE `cookie` = VALUES(`cookie`), `country_code` = VALUES(`country_code`), `activity_count` = (`activity_count` + 1)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ssss", $user, $ip, $token, $countryCode,); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        // Record User Log

        $stmt = mysqli_prepare($dbConn, "INSERT INTO `activity_logs` (`user_id`, `browser`, `device`, `token`, `timezone`, `country_code`, `ip_address`, `location`, `longitude`, `latitude`, `logged_in`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssssssssss", $user, $browserData, $deviceData, $token, $timezone, $countryCode, $ip, $location, $lat, $long, $datetime); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        mysqli_stmt_close($stmt); // Close Statement

    }

    function activeLog($token, $user, $userType, $dbConn) { // Get Current Activity Log

        $data = null;

        if ($userType == 'THIRD PARTY') {

            $ip = $_SESSION['IP'];

            $timezone = $_SESSION['TIMEZONE'];

            $location = $_SESSION['LOCATION'];

            $flag = $_SESSION['FLAG'];

            $ip = 'IP Address: ' . (!is_null($ip) ? $ip : 'UNKNOWN');

            $location = 'Locale: ' . (!is_null($location) ? $location : 'UNKNOWN');

            // $device = 'Device: ' . (!is_null($device) ? $device : 'UNKNOWN');

            $timezone = 'Timezone: ' . (!is_null($timezone) ? $timezone : null);

            $data = join(' ', [$ip, $flag, $location, $timezone]);

        } else {

            $found = false; // Flag

            // Get Latest Activity Log

            $stmt  = mysqli_prepare($dbConn, "SELECT * FROM `activity_logs` WHERE `user_id` = ? AND `token` = ? ORDER BY `id` DESC LIMIT 1"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "ss", $user, $token); // Bind Parameter(s)

            mysqli_stmt_execute($stmt); // Execute Statement

            $result = mysqli_stmt_get_result($stmt); // Get Result

            if (mysqli_num_rows($result) === 1) {

                $found = true;

                $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

                foreach ($data as $row):

                    $ip = $row['ip_address'];

                    // $device = $row['device'];

                    $timezone = $row['timezone'];

                    $location = $row['location'];

                    $code = $row['country_code'];

                endforeach;

            }

            mysqli_stmt_close($stmt); // Close Statement

            if ($found) {

                $ip = 'IP Address: ' . (!is_null($ip) ? $ip : 'UNKNOWN');

                $location = 'Locale: ' . (!is_null($location) ? $location : 'UNKNOWN');

                $flag = !is_null($code) ? '<img src="https://flagcdn.com/' . strtolower($code) . '.svg" alt="" width="20px">' : null;

                // $device = 'Device: ' . (!is_null($device) ? $device : 'UNKNOWN');

                $timezone = 'Timezone: ' . (!is_null($timezone) ? $timezone : null);

                // return $ip . ', ' . $flag . $location . ', ' . $device . ', ' . $timezone;\

                $data = join(' ', [$ip, $flag, $location, $timezone]);

            } else {

                $data = 'Error! Data not found!';

            }

        }

        return $data . ' VPN: N/A, Time: <span translate="no" id="timer-display"></span>';

    }

    function prevLog($token, $user, $dbConn, $timezone = null, $prefix = null) { // Get Previous Activity Log Date

        $found = false; // Flag

        // Get Previous Activity Log Date

        $stmt  = mysqli_prepare($dbConn, "SELECT * FROM `activity_logs` WHERE `user_id` = ? AND `token` != ? ORDER BY `id` DESC LIMIT 1"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $user, $token); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) === 1) {

            $found = true;

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

            foreach ($data as $row):

                $logged = $row['logged_in'];

            endforeach;

        }

        mysqli_stmt_close($stmt); // Close Statement

        if ($found) { 

            return  $prefix . readableDateDiff($logged, null, true, true) . ' ';

        } else {

            return null;

        }

    }

    function finalLog($dbConn, $user, $token, $status = 'CLOSED') { // Update Activity Log (On Sign-out)
        
        $datetime  = date('Y-m-d H:i:s', time());

        $status2 = 'INACTIVE';

        // Close Current Log And Update Open Logs

        $stmt = mysqli_prepare($dbConn, "UPDATE `activity_logs` SET `status` = CASE WHEN `token` = CAST(? AS BINARY) THEN ? WHEN `token` != CAST(? AS BINARY) AND `logged_out` IS NULL THEN ? ELSE `status` END, `logged_out` = CASE WHEN `token` = CAST(? AS BINARY) THEN ? ELSE `logged_out` END WHERE `user_id` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sssssss", $token, $status, $token, $status2, $token, $datetime, $user); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        mysqli_stmt_close($stmt); // Close Statement

    }

    function activateLog($dbConn, $user, $token) { // Update Current Activity Log Status
    
        $status = 'ACTIVE';
        
        $stmt = mysqli_prepare($dbConn, "UPDATE `activity_logs` SET `status` = ? WHERE `user_id` = CAST(? AS BINARY) AND `token` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sss", $status, $user, $token); // Bind Parameter(s)
        
        mysqli_stmt_execute($stmt); // Execute Statement

        mysqli_stmt_close($stmt); // Close Statement

    }

    function logMaintenance($dbConn, $dateTime, $days = 30, $batchSize = 1000) { // Activity Logs Deletion

        $stmt = mysqli_prepare($dbConn, "DELETE FROM `activity_logs`
WHERE `id` IN (
    SELECT `id` FROM (
        SELECT `al`.`id`
        FROM `activity_logs` AS `al`
        LEFT JOIN (
            SELECT `user_id`, MAX(`logged_in`) AS `max_logged_in`
            FROM `activity_logs`
            WHERE status IN ('CLOSED', 'INACTIVE')
            GROUP BY `user_id`
        ) AS `keep_logs` 
        ON `al`.`user_id` = `keep_logs`.`user_id` AND `al`.`logged_in` = `keep_logs`.`max_logged_in`
        WHERE `al`.`status` IN ('CLOSED', 'INACTIVE')
          AND `al`.`logged_in` < ? - INTERVAL ? DAY
          AND (
              `keep_logs`.`max_logged_in` IS NULL 
              OR `al`.`logged_in` <> `keep_logs`.`max_logged_in`
          )
        LIMIT ?
    ) AS `safe_ids`)");

        mysqli_stmt_bind_param($stmt, "sii", $dateTime, $days, $batchSize);

        do {
            mysqli_stmt_execute($stmt);
            $affectedRows = mysqli_stmt_affected_rows($stmt);
        } while ($affectedRows > 0);

        // Explicitly close the prepared statement to free resources
        mysqli_stmt_close($stmt);

    }

    function notificationMaintenance($dbConn, $date) { // Notification(s) Maintenance

        $stmt = mysqli_prepare($dbConn, "DELETE FROM `notifications` WHERE `date_created` < ? - INTERVAL 31 DAY;"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $date);

        mysqli_stmt_execute($stmt);

        mysqli_stmt_close($stmt);

    }

    function shortenNumber($number, $significance = 1) { // Shorten Number

        $sign = null;

        if ($number > 0 && $number < 1000) {

            return (string)$number;

        } else if ($number < 0) {

            $sign = '-';

        } else if ($number == 0) {

            $significance = 0;

        }

        $units = ['', 'K', 'M', 'B', 'T'];  // Thousand, Million, Billion, Trillion
    
        $unitIndex = 0;

        while (abs($number) >= 1000 && $unitIndex < count($units) - 1) {
            $number /= 1000;
            $unitIndex++;
        }

        return $sign . number_format($number, $significance) . $units[$unitIndex];

    }

    function readableDateDiff($date, $timezone = null, $datetimeMode = true, $detailed = false) { // Readable Date Difference
        // Set current and target dates
        if (is_null($timezone)) {
            $now = new DateTime();
            $givenDate = new DateTime($date);
        } else {
            $tz = new DateTimeZone($timezone);
            $now = new DateTime('now', $tz);
            $givenDate = new DateTime($date, $tz);
        }

        if (!$datetimeMode) {
            $now->setTime(0, 0);
            $givenDate->setTime(0, 0);
        }

        $diff = $now->diff($givenDate);
        $isFuture = $givenDate > $now;

        // Detailed same-day display (if enabled)
        if ($diff->days === 0) {
            if ($detailed && $datetimeMode) {
                $hours = $diff->h;
                $minutes = $diff->i;

                if ($hours === 0 && $minutes === 0) {
                    return 'Just now';
                } elseif ($hours === 0) {
                    return $isFuture ? "in $minutes minute" . ($minutes > 1 ? 's' : '') : "$minutes minute" . ($minutes > 1 ? 's' : '') . " ago";
                } else {
                    return $isFuture 
                        ? "in $hours hour" . ($hours > 1 ? 's' : '') . ($minutes > 0 ? " and $minutes minute" . ($minutes > 1 ? 's' : '') : '')
                        : "$hours hour" . ($hours > 1 ? 's' : '') . ($minutes > 0 ? " and $minutes minute" . ($minutes > 1 ? 's' : '') : '') . " ago";
                }
            }

            return 'Today';
        }

        if ($diff->days === 1 && !$datetimeMode) {
            return $isFuture ? 'Tomorrow' : 'Yesterday';
        }

        // Display largest time unit difference
        if ($diff->y > 0) {
            return $isFuture 
                ? "in {$diff->y} year" . ($diff->y > 1 ? 's' : '') 
                : "{$diff->y} year" . ($diff->y > 1 ? 's' : '') . " ago";
        }

        if ($diff->m > 0) {
            return $isFuture 
                ? "in {$diff->m} month" . ($diff->m > 1 ? 's' : '') 
                : "{$diff->m} month" . ($diff->m > 1 ? 's' : '') . " ago";
        }

        $weeks = floor($diff->d / 7);
        $remainingDays = $diff->d % 7;

        if ($weeks > 0) {
            return $isFuture 
                ? "in $weeks week" . ($weeks > 1 ? 's' : '') 
                : "$weeks week" . ($weeks > 1 ? 's' : '') . " ago";
        }

        if ($remainingDays > 0) {
            return $isFuture 
                ? "in $remainingDays day" . ($remainingDays > 1 ? 's' : '') 
                : "$remainingDays day" . ($remainingDays > 1 ? 's' : '') . " ago";
        }

        return 'Today'; // fallback
    }

    function unreadNotficationsCount($id, $dbConn) { // User Accounts Count

        $num = 0;

        // Get User Account Count

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `unread` FROM `notifications` WHERE `user_id` = CAST(? AS BINARY) AND `status` = ?"); // Prepare Statement

        $param = 'UNREAD';

        mysqli_stmt_bind_param($stmt, "ss", $id, $param); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Results

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['unread'];

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    } 

    function filename() { // Filename

        // Get File Path

        $filePath = parse_url($_SERVER['PHP_SELF'], PHP_URL_PATH); // Get Path Only

        $filename = pathinfo($filePath, PATHINFO_FILENAME);// Get Filename

        return $filename;

    }

    function pageTitles($filename) { // Page Title<title></title>

        // Options For Page <title></title>

        $pageTitles = [

            '' => 'Dashboard',

            'home' => 'Dashboard',

            'accounts' => 'Accounts',

            'transactions' => 'Transactions',

            'payments' => 'Payments',

            'cards' => 'Virtual Cards',

            'reports-statements' => 'Reports & Statements',

            'investments' => 'Investments',

            'support-tickets' => 'Support Tickets',

            'pay' => 'Pay',

            'loans' => 'Loans',

            'invoices' => 'Invoices',

            'create-invoice' => 'Create Invoice',

            'joint-users' => 'Joint Users',

            'joint-user-transactions' => 'Joint User',

            '404' => 'Page Not Found',

        ];

        if (array_key_exists($filename, $pageTitles)) {

            $pageTitle = $pageTitles[$filename];

        } else {

            $pageTitle = "Page";

            if (str_contains($filename, 'profile')) {

                $pageTitle = "Profile";
    
            } else if (str_contains($filename, 'settings')) {
    
                $pageTitle = "Settings";
    
            }

        }

        return $pageTitle;

    }

    function headerMsg($filename, $username) { // Page Header Message

        $salutes = [greetings(), 'Hello', 'Welcome'];

        $salute = $salutes[array_rand($salutes)];

        // Options For Salutations

        $values = [

            '' => "<h2>$salute, $username 👋🏼</h2><p>Send, save and receive funds in various currencies</p>",

            'home' => "<h2>$salute, $username 👋🏼</h2><p>Send, save and receive funds in various currencies</p>",

            'accounts' => '<h2>Accounts</h2>',

            'transactions' => '<h2>Transactions</h2>',

            'payments' => '<h2>Payments</h2>',

            'cards' => '<h2>Virtual Cards</h2>',

            'reports-statements' => '<h2>Reports & Statements</h2>',

            'support-tickets' => '<h2>Support Tickets</h2>',

            'send-money' => '<h2>Initiate Transfer</h2>',

            'pay' => '<h2>Make Payment</h2>',

            'investments' => '<h2>Invest <sup class="label blue">Plans</sup></h2>',

            'loans' => '<h2>Loans</h2>',

            'invoices' => '<h2>Invoices</h2>',

            'create-invoice' => '<h2>Add New Invoice</h2>',

            'joint-users' => '<h2>Joint Users <sup class="label lime">Third Party</sup></h2>',

            'joint-user-transactions' => '<h2>Joint User <sup class="label">Transactions</sup></h2>',

            '404' => '<h2>Page Not Found</h2>',

        ];

        if (array_key_exists($filename, $values)) {

            $value = $values[$filename];

        } else {

            $value = "";

            if (str_contains($filename, 'profile')) {

                $value = "<h2>Profile</h2>";
    
            } else if (str_contains($filename, 'settings')) {
    
                $value = "<h2>Settings</h2>";
    
            }

        }

        return $value;

    }    

    function sanitizeDate($date) { // Sanitize & Format Date
        // Trim any extra spaces
        $date = trim($date);

        return date('Y-m-d', strtotime($date));
    
    }

    function sanitizeDateTime($datetime, $formatted = false) { // Sanitize & Format Datetime

        // Trim any extra spaces
        $datetime = trim($datetime);
        
        return date('Y-m-d H:i:s', strtotime($datetime));
    
    }

    function payRestriction($target) { // Pay Page Limit

        if (isset($_SESSION['PAY']) && ($target != 'pay' && $target != 'feedback')){

            header('location: pay');
    
            exit();
    
        }

    }

    function convPayAmt($cryptoToken, $tokenSymbol, $amount, $fiat = 'USD') { // Crypto Conversion (Payment Page)

        $symbol = strtolower($tokenSymbol);

        if ($fiat != 'USD') {

            $converted = convertToUSD($amount, $fiat);

            if ($converted) {

                $amount = $converted;

                $fiat = 'USD';

            }

        }

        $fiat = strtolower($fiat);

        try {

            $apiUrl = "https://api.coinconvert.net/convert/{$fiat}/{$symbol}?amount={$amount}";

            $response = @file_get_contents($apiUrl);

            if ($response === FALSE) {
                throw new Exception('Conversion API unavailable.');
            }

            $data = json_decode($response, true);

            if (!isset($data[strtoupper($symbol)])) {
                throw new Exception('Price data not found.');
            }

            $amountInCrypto = $data[strtoupper($symbol)];

            return number_format($amountInCrypto, 8) . ' ' . strtoupper($symbol) . " (charges may apply)";

        } catch (Exception $error) {

            error_log($error->getMessage());

            return '<i style="color: red; font-size: 0.8rem">Data not Available!</i>';

        }
    }

    function convertFromUSD($amount, $currency) { // Convert From USD Amount

        try {

            $apiUrl = "https://api.exchangerate-api.com/v4/latest/USD";

            // Fetch data from the API

            $response = @file_get_contents($apiUrl);
            $data = json_decode($response, true);

            if ($response === FALSE || !isset($data['rates'][$currency])) {
                
                throw new Exception ('Error: Conversion rate or symbol not available.');
                
            }

            // Get the conversion rate
            $rate = $data['rates'][$currency];

            // If everything is fine, perform the conversion
            $converted = $amount * $rate;

            return $converted;


        } catch (Exception $error) {

            error_log($error->getMessage());

            return false;

        }

    }

    function convertToUSD($amount, $currency) { // Convert To USD Amount

        try {

            $apiUrl = "https://api.exchangerate-api.com/v4/latest/USD";

            // Fetch data from the API

            $response = @file_get_contents($apiUrl);
            $data = json_decode($response, true);

            if ($response === FALSE || !isset($data['rates'][$currency])) {
                
                throw new Exception ('Error: Conversion rate or symbol not available.');
                
            }

            // Get the conversion rate
            $rate = $data['rates'][$currency];

            // If everything is fine, perform the conversion
            $converted = $amount / $rate;

            return $converted;


        } catch (Exception $error) {

            error_log($error->getMessage());

            return false;

        }

    }

    function fiatSwap($from, $to, $volume) { // Convert Currency

        $from = strtoupper($from);

        $to = strtoupper($to);

        try {

            $api = 'https://api.exchangerate-api.com/v4/latest/' . $from;

            $response = @file_get_contents($api);

            $data = json_decode($response, true);

            if ($response === FALSE || !isset($data['rates'][$to])) {
                
                throw new Exception ('Error: Conversion rate or symbol not available.');
                
            }

            $rate = $data['rates'][$to];

            $equivalent = $volume * $rate;

            return $equivalent;

        } catch (Exception $error) {

            error_log($error->getMessage()); // Log Error(s)

            return false;

        }

    }

    function cryptoSubs($user, $dbConn) { // Get Number Of Active Crypto Investments

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total` FROM `subscriptions` AS `A` JOIN `investments` AS `B` ON `A`.`item_id` = `B`.`inv_id` WHERE `A`.`user_id` = ? AND `B`.`category` = ?"); // Prepare Statement

        $param = 'CRYPTO';

        mysqli_stmt_bind_param($stmt, "ss", $user, $param); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total'];

        }

        return $num;

    }

    function stocksSubs($user, $dbConn) { // Get Number Of Active Stocks Investments

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total` FROM `subscriptions` AS `A` JOIN `investments` AS `B` ON `A`.`item_id` = `B`.`inv_id` WHERE `A`.`user_id` = ? AND `B`.`category` = ?"); // Prepare Statement

        $param = 'STOCKS';

        mysqli_stmt_bind_param($stmt, "ss", $user, $param); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total'];

        }

        return $num;

    }

    function realtySubs($user, $dbConn) { // Get Number Of Active Realty Investments

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total` FROM `subscriptions` AS `A` JOIN `investments` AS `B` ON `A`.`item_id` = `B`.`inv_id` WHERE `A`.`user_id` = ? AND `B`.`category` = ?"); // Prepare Statement

        $param = 'REALTY';

        mysqli_stmt_bind_param($stmt, "ss", $user, $param); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total'];

        }

        return $num;

    }

    function fxSubs($user, $dbConn) { // Get Number Of Active Forex Investments

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total` FROM `subscriptions` AS `A` JOIN `investments` AS `B` ON `A`.`item_id` = `B`.`inv_id` WHERE `A`.`user_id` = ? AND `B`.`category` = ?"); // Prepare Statement

        $param = 'FOREX';

        mysqli_stmt_bind_param($stmt, "ss", $user, $param); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total'];

        }

        return $num;

    }

    function optionsSubs($user, $dbConn) { // Get Number Of Active Options Investments

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total` FROM `subscriptions` AS `A` JOIN `investments` AS `B` ON `A`.`item_id` = `B`.`inv_id` WHERE `A`.`user_id` = ? AND `B`.`category` = ?"); // Prepare Statement

        $param = 'OPTIONS';

        mysqli_stmt_bind_param($stmt, "ss", $user, $param); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total'];

        }

        return $num;

    }

    function bondsSubs($user, $dbConn) { // Get Number Of Active Bonds Investments

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total` FROM `subscriptions` AS `A` JOIN `investments` AS `B` ON `A`.`item_id` = `B`.`inv_id` WHERE `A`.`user_id` = ? AND `B`.`category` = ?"); // Prepare Statement

        $param = 'BONDS';

        mysqli_stmt_bind_param($stmt, "ss", $user, $param); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total'];

        }

        return $num;

    }

    function commoditySubs($user, $dbConn) { // Get Number Of Active Commodity Investments

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total` FROM `subscriptions` AS `A` JOIN `investments` AS `B` ON `A`.`item_id` = `B`.`inv_id` WHERE `A`.`user_id` = ? AND `B`.`category` = ?"); // Prepare Statement

        $param = 'COMMODITY';

        mysqli_stmt_bind_param($stmt, "ss", $user, $param); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total'];

        }

        return $num;

    }

    function miscSubs($user, $dbConn) { // Get Number Of Active Miscellanous Investments

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total` FROM `subscriptions` AS `A` JOIN `investments` AS `B` ON `A`.`item_id` = `B`.`inv_id` WHERE `A`.`user_id` = ? AND (`B`.`category` = ? OR `B`.`category` IS NULL)"); // Prepare Statement

        $param = 'OTHERS';

        mysqli_stmt_bind_param($stmt, "ss", $user, $param); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        while ($row = mysqli_fetch_assoc($result)) {

            $num = $row['total'];

        }

        return $num;

    }
    
    function loanEligibility($creditScore, $income) { // Loan: Eligible Amount

        // Calculate Multiplier Factor And Loan Limit

        $multiplier = 0;

        $limit = 700;
        
        if ($creditScore >= 300) {

            $multiplier = 1.0;

            $limit = 2500;

        } else if ($creditScore > 579) {

            $multiplier = 1.5;

            $limit = 5000;

        } else if ($creditScore > 669) {

            $multiplier = 2.0;

            $limit = 10000;

        } else if ($creditScore > 739) {

            $multiplier = 2.5;

            $limit = 20000;

        } else if ($creditScore > 700) {

            $multiplier = 3.0;

            $limit = 30000;

        }

        if ($multiplier == 0 || $income > 300) {

            $eligibleLoan = $limit;

        } else {

            $eligibleLoan = $limit;

        }

        return $eligibleLoan;

    }

    function loanRate($creditScore) { // Loan Rate

        // Determine Loan Rate
        
        if ($creditScore < 300) {

            $rate = 40;

        } else if ($creditScore >= 300) {

            $rate = 30;

        } else if ($creditScore > 579) {

            $rate = 20;

        } else if ($creditScore > 669) {

            $rate = 15;

        } else if ($creditScore > 739) {

            $rate = 12;

        } else if ($creditScore > 700) {

            $rate = 4;

        }

        return $rate;

    }

    function timeGMT($format = 'Y-m-d H:i:s') { // Generate GMT Time

        // 'l, M d Y, (H:i) [T]'

        $datetime = date_create();

        $datetime->setTimezone(new DateTimeZone('GMT'));  // Convert to GMT

        $datetime = date_format($datetime, $format); // Format Datetime

        return $datetime;

    }
    
    function deleteFile($file, $relativity = null) { // Delete File

        if (!is_null($file)) { // Delete Proof

            if ($relativity) {

                $file = $relativity . str_replace('../', '', $file); // Re-construct File Path

            }

            if (is_file($file) && file_exists($file)) {

                unlink($file);

            } 

        }

    }

    function generateRGB() { // Generate Random Color

        $colorCodes = [];

        for ($i = 0; $i < 3; $i++) {

            $colorCodes[] = mt_rand(0, 200);

        }

        $colorCode = join(', ' ,$colorCodes);

        return "rgb($colorCode)";

    }

    function generateCVV() { // Generate CVV

        $cvv = mt_rand(100, 999);

        return $cvv;

    }

    function generateCardNumber($provider = null, $length = 16) { // Generate Virtual Card Number
        // Set length for AMEX
        if ($provider == 'AMEX') {
            $length = 15;
        }
    
        // Seed the random number generator just once per execution
        mt_srand((float) microtime() * 1000000); // Ensure the random number generator is seeded
    
        // Use random_int for better randomness
        $number = '';
    
        for ($i = 0; $i < $length; $i++) {
            $number .= random_int(0, 9); // Use random_int for better security and randomness
        }
    
        return $number;
    }

    function generateRepaymentSchedule($loanAmount, $interestRate, $loanTermDays, $paymentFrequency) { // Generate Loan Payment Schedule
        // Step 1: Calculate total interest (simple interest)
        $interest = $loanAmount * ($interestRate / 100) * ($loanTermDays / 365);  // Simple interest
        $totalRepayable = $loanAmount + $interest;  // Total repayable amount
    
        // Step 2: Determine number of payments based on frequency
        if ($paymentFrequency == 'BI-WEEKLY') {
            // Bi-weekly payments: calculate number of payments based on loan term
            $numPayments = ceil($loanTermDays / 14);
        } elseif ($paymentFrequency == 'MONTHLY') {
            // Monthly payments: calculate number of payments based on loan term
            $numPayments = ceil($loanTermDays / 30);
        } else {
            // Invalid frequency, return an error or handle it
            return ['error' => 'Invalid payment frequency. Please choose "bi-weekly" or "monthly".'];
        }
    
        // Step 3: Calculate payment amount for each period
        $paymentAmount = $totalRepayable / $numPayments;
    
        // Step 4: Generate payment due dates
        $paymentDates = [];
        $currentDate = strtotime("today");  // Start date (e.g., today)
    
        for ($i = 0; $i < $numPayments; $i++) {
            // Calculate next due date based on frequency
            if ($paymentFrequency == 'bi-weekly') {
                $currentDate = strtotime("+2 weeks", $currentDate);  // Add 2 weeks for bi-weekly
            } else {
                $currentDate = strtotime("+1 month", $currentDate);  // Add 1 month for monthly
            }
    
            // Add the formatted due date to the payment dates array
            $paymentDates[] = date('Y-m-d', $currentDate);
        }
    
        // Return the results as an array
        return [
            'totalRepayable' => round($totalRepayable, 2),
            'paymentAmount' => round($paymentAmount, 2),
            'paymentDates' => $paymentDates,
        ];
    }

    function payoutSchedule($invested, $interest, $returns, $cycle, $frequency, $unit, $includePrincipal = true) {

        // Frequency Multiplier for Days vs Hours
        $frequencyMultiplier = ($unit === 'HOURS') ? 24 : 1;

        // Total number of payouts
        $totalPayouts = ($cycle * $frequencyMultiplier) / $frequency;

        $payouts = [];

        // Total interest amount
        $totalInterest = ($invested * $interest) / 100;

        // Option 1: Spread principal + interest evenly
        if ($returns === 'FIXED') {
            if ($includePrincipal) {
                $totalAmount = $invested + $totalInterest;
                $fixedPayout = $totalAmount / $totalPayouts;
            } else {
                $fixedPayout = $totalInterest / $totalPayouts;
            }

            for ($i = 1; $i <= $totalPayouts; $i++) {
                $date = calculatePayoutDate($i, $cycle, $frequency, $unit);
                $payouts[] = [
                    'payout_number' => $i,
                    'amount' => round($fixedPayout, 2),
                    'date' => $date
                ];
            }
        }

        // Variable Returns
        else if ($returns === 'VARIABLE') {
            $currentPrincipal = $invested;

            for ($i = 1; $i <= $totalPayouts; $i++) {
                $variableInterest = ($currentPrincipal * $interest) / 100 / $totalPayouts;
                $principalPart = $includePrincipal ? ($invested / $totalPayouts) : 0;
                $totalPayout = $variableInterest + $principalPart;

                $date = calculatePayoutDate($i, $cycle, $frequency, $unit);
                $payouts[] = [
                    'payout_number' => $i,
                    'amount' => round($totalPayout, 2),
                    'date' => $date
                ];

                $currentPrincipal += $variableInterest;
            }
        }

        // Compound Returns
        else if ($returns === 'COMPOUND') {
            $currentPrincipal = $invested;

            for ($i = 1; $i <= $totalPayouts; $i++) {
                $compoundInterest = ($currentPrincipal * ($interest / 100)) / $totalPayouts;
                $currentPrincipal += $compoundInterest;

                $payoutAmount = $compoundInterest;
                if ($includePrincipal) {
                    $payoutAmount += ($invested / $totalPayouts);
                }

                $date = calculatePayoutDate($i, $cycle, $frequency, $unit);
                $payouts[] = [
                    'payout_number' => $i,
                    'amount' => round($payoutAmount, 2),
                    'date' => $date
                ];
            }
        }

        return $payouts;
    }

    function calculatePayoutDate($payoutNumber, $cycle, $frequency, $unit) {
        // Starting date for payout (assuming today as the start date)
        $startDate = new DateTime();
        
        // Calculate the interval to the payout date
        $interval = $frequency * $payoutNumber;
        
        if ($unit === 'DAYS') {
            $startDate->add(new DateInterval('P' . $interval . 'D'));  // Add days
        } else if ($unit === 'HOURS') {
            // $startDate->add(new DateInterval('PT' . ($interval * 24) . 'H')); // Add hours

            $startDate->add(new DateInterval('PT' . $interval . 'H')); // Add hours directly
        }
    
        return $startDate->format('Y-m-d H:i:s');
    }

    function daysToHours($duration, $reverse = false) { // Convert Day & Hours


        if ($reverse) {

            $time = ($duration / 24); // Convert Hour to Day

        } else {

            $time = ($duration * 24); // Convert Day To Hour

        }

        return $time;

    }

    // Convert to GMT Time

    // **********************************************************************************************************************************************************************************************************************************************************

    // Total Users

    function totalUsers($dbconn) {
        
        $exists = false; // Flag

        $stmt = mysqli_prepare($dbconn, "SELECT COUNT(*) AS `users` FROM `users`");

        mysqli_stmt_execute($stmt);

        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) === 1) {

            $exists = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

            foreach ($data as $row) {

                $users = $row['users'];

            }

        }

        mysqli_free_result($result);

        mysqli_stmt_close($stmt);

        if ($exists) {

            return $users;

        } else {

            return 0;

        }
 
    }

    // Total Accounts

    function totalAccounts($dbconn) {
        
        $exists = false; // Flag

        $stmt = mysqli_prepare($dbconn, "SELECT COUNT(*) AS `accounts` FROM `accounts`");

        mysqli_stmt_execute($stmt);

        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) === 1) {

            $exists = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

            foreach ($data as $row) {

                $accounts = $row['accounts'];

            }

        }

        mysqli_free_result($result);

        mysqli_stmt_close($stmt);

        if ($exists) {

            return $accounts;

        } else {

            return 0;

        }
 
    }

    // Fetch Admin Data

    function adminData($dbconn) {
        
        $exists = false; // Flag

        $stmt = mysqli_prepare($dbconn, "SELECT * FROM `admin` LIMIT 1");

        mysqli_stmt_execute($stmt);

        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) === 1) {

            $exists = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

            foreach ($data as $row) {

                $email = $row['email'];

                $username = $row['username'];

                $password = $row['pre_hash'];

                $key = $row['password'];

                $fname = $row['firstname'];

                $mname = $row['middlename'];

                $lname = $row['lastname'];

            }

        }

        mysqli_free_result($result);

        mysqli_stmt_close($stmt);

        if ($exists) {

            return [

                'username' => $username,

                'email' => $email,

                'firstname' => $fname,

                'middlename' => $mname,

                'lastname' => $lname,

                'key' => $key,

                'password' => $password

            ];

        } else {

            return false;

        }
 
    }

    // Check Administrator Access
    
    function adminAccess() {

        if ((!isset($_SESSION['ADMIN-ID']) && !isset($_SESSION['LOG-ADMIN'])) || (empty($_SESSION['ADMIN-ID']) && empty($_SESSION['LOG-ADMIN']))) {

            $_SESSION = [];

            session_destroy(); // Destroy Sessions

            // Redirect To Login

            header('location: login');
            
            exit; // Terminate Script

        }

    }

    // Time-dependent Salutations

    function greetings() {

        $hour = date('H');

        if ($hour < 12) {

            return 'Good morning';

        } else if ($hour >= 12  && $hour < 18) {

            return 'Good afternoon';

        } else if ($hour >= 18) {

            return 'Good evening';

        }

    }

    // Random String Generation

    function randomString($length = 25) {

        $characters = '0123456789ABCDEFGHIJKLNMOPQRSTUVWXYZabcdefghijklnmopqrstuvwxyz';

        $charactersLength = strlen($characters);
    
        $randomString = '';

        for ($i = 0; $i < $length; $i++) {

            $randomString .= $characters[rand(0, ($charactersLength - 1))];

        }

        return $randomString;

    }

    // Feedback

    function feedback($means, $type, $message, $title = null) {

        $means = strtolower((string)$means);

        $type = strtolower((string)$type);

        $message = (string)$message;

        $title = ($title !== null) ? (string)$title : null;

        if ($means === 'toast') {

            echo '<script>
            
                toastr.',$type,'("',$message,'", "',$title,'");

            </script>';

        } else {

            echo '<script>
            
                swal({
				
					title: "',$title,'",

					text: "',$message,'",

					icon: "',$type,'",
			
				});

            </script>';

        }

    }

    // Border Indication

    function borderIndicate($id, $type = 'error', $color = null) {

        $color = ($color == null && strtolower($type) == 'error') ? 'rgb(249, 58, 55)' : $color;

        if (strtolower($type) === 'success') {

            $color = 'rgb(54, 179, 126)';

        }

        // Apply Color

        echo '<script>
        
            document.getElementById("',$id,'").style.borderColor = "',$color,'";

        </script>';

    }

    // Page Title

    function adminPageTitle() {

        $filePath = parse_url($_SERVER['PHP_SELF'], PHP_URL_PATH); // Get Path Only

        $filename = pathinfo($filePath, PATHINFO_FILENAME);// Get Filename

        $filename = str_replace(['-', '_'], ' ', $filename);

        return ucwords($filename); // Capitalize

    }

    // Payment Count

    // function paymentCount() {}

    // Number Shortener

    // function shortenNum($integer) {}

    // Explicitly Shorten Number

    // function explicitNumShorten($integer) {}

    // Empty Cell

    function emptyTable ($msg = 'Nothing to show here!', $icon = '<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M26.984 3.33331H13.0173C6.95065 3.33331 3.33398 6.94998 3.33398 13.0166V26.9666C3.33398 33.05 6.95065 36.6666 13.0173 36.6666H26.9673C33.034 36.6666 36.6507 33.05 36.6507 26.9833V13.0166C36.6673 6.94998 33.0507 3.33331 26.984 3.33331ZM28.7673 16.6L24.9173 21.5666C24.434 22.1833 23.7507 22.5833 22.9673 22.6666C22.184 22.7666 21.4173 22.55 20.8007 22.0666L17.7507 19.6666C17.634 19.5666 17.5007 19.5666 17.434 19.5833C17.3673 19.5833 17.2507 19.6166 17.1507 19.75L13.184 24.9C12.934 25.2166 12.5673 25.3833 12.2007 25.3833C11.934 25.3833 11.6673 25.3 11.434 25.1166C10.884 24.7 10.784 23.9166 11.2007 23.3666L15.1673 18.2166C15.6507 17.6 16.334 17.2 17.1173 17.1C17.884 17 18.6673 17.2166 19.284 17.7L22.334 20.1C22.4507 20.2 22.5673 20.2 22.6507 20.1833C22.7173 20.1833 22.834 20.15 22.934 20.0166L26.784 15.05C27.2007 14.5 28.0007 14.4 28.534 14.8333C29.084 15.2833 29.184 16.0666 28.7673 16.6Z" fill="#C2C9D6"></path></svg>', $colspan = 6) {

        echo '<tr class="cell_empty">

            <td colspan="' . $colspan . '">

                <div>

                    ' . $icon . '

                    <p>' . $msg . '</p>

                </div>
                
            </td>

        </tr>';

    }

    function deleteUser($dbConn, $user, $relativity = null) { // Delete User

        // Remove Files Pertaining to User

        $files_to_delete = []; // Files Storage

        // Retrieve File Paths

        $query = "SELECT `pay_proof`, NULL AS `face`, NULL AS `id_proof`, NULL AS `id_proofBack`, NULL AS `user_avatar`, NULL AS `dep_proof`
        FROM `payments`
        WHERE `user_id` = ?

        UNION

        SELECT NULL AS `pay_proof`, NULL AS `face`, NULL AS `id_proof`, NULL AS `id_proofBack`, NULL AS `user_avatar`, `dep_proof`
        FROM `deposits`
        WHERE `user_id` = ?

        UNION

        SELECT `pay_proof`, NULL AS `face`, NULL AS `id_proof`, NULL AS `id_proofBack`, NULL AS `user_avatar`, NULL AS `dep_proof`
        FROM `invoice_payments`
        WHERE `user_id` = ?

        UNION

        SELECT NULL AS `pay_proof`, `face`, `id_proof`, `id_proofBack`, NULL AS `user_avatar`, NULL AS `dep_proof`
        FROM `kyc_data`
        WHERE `user_id` = ?

        UNION

        SELECT NULL AS `pay_proof`, NULL AS `face`, NULL AS `id_proof`, NULL AS `id_proofBack`, `user_avatar`, NULL AS `dep_proof` 
        FROM `users`
        WHERE `user_id` = ?";

        $stmt = mysqli_prepare($dbConn, $query);

        // Check for errors in query preparation
        if (!$stmt) {
            die('Query preparation failed: ' . mysqli_error($dbConn));
        }

        mysqli_stmt_bind_param($stmt, 'sssss', $user, $user, $user, $user, $user);
        mysqli_stmt_execute($stmt);

        mysqli_stmt_bind_result($stmt, $pay_proof, $face, $id_proof, $id_proofBack, $user_avatar, $dep_proof);

        while (mysqli_stmt_fetch($stmt)) {
            // Check for non-NULL values and add the appropriate file paths to the array
            if ($pay_proof) {
                $files_to_delete[] = $pay_proof;
            }
            if ($face) {
                $files_to_delete[] = $face;
            }
            if ($id_proof) {
                $files_to_delete[] = $id_proof;
            }
            if ($id_proofBack) {
                $files_to_delete[] = $id_proofBack;
            }
            if ($user_avatar) {
                $files_to_delete[] = $user_avatar;
            }
            if ($dep_proof) {
                $files_to_delete[] = $dep_proof;
            }
        }
        
        mysqli_stmt_close($stmt); 

        // Delete File(s)
       
        foreach ($files_to_delete as $file) {

            $file = ($relativity) ? $relativity . str_replace('../', '', $file) : $file; // Re-construct File Path

            if (is_file($file) && file_exists($file)) {
                
                unlink($file);

            }
        }

        // Get Support Ticket ID (For Message Deletion)

        $ticketIDs = [];

        $stmt = mysqli_prepare($dbConn, "SELECT `ticket_id` FROM `support_tickets` WHERE `user_id` = ?"); // Prepare Statment

        mysqli_stmt_bind_param($stmt, "s", $user); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        while ($row = mysqli_fetch_assoc($result)) {

            $ticketIDs[] = $row['ticket_id']; // Update Array

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Delete Messages
        
        if (!empty($ticketIDs)) {
            // Prepare placeholders for IN clause, e.g. (?, ?, ?)
            $placeholders = implode(',', array_fill(0, count($ticketIDs), '?'));

            // Prepare statement for DELETE
            $deleteSql = "DELETE FROM `messages` WHERE `ticket_id` IN ($placeholders)";
            $deleteStmt = mysqli_prepare($dbConn, $deleteSql);

            // Create types string (all integers or strings depending on your ticket_id type)
            $types = str_repeat('s', count($ticketIDs)); // assuming ticket_id is string, change to 'i' if integer

            // Bind parameters dynamically
            mysqli_stmt_bind_param($deleteStmt, $types, ...$ticketIDs);

            mysqli_stmt_execute($deleteStmt);
            mysqli_stmt_close($deleteStmt);
        }

        // Get Third Party Users

        $thirdParty = []; // Holds Thirdparty IDs
        
        $stmt = mysqli_prepare($dbConn, "SELECT `tp_id` FROM `third_party` WHERE `user_id` = ?"); // Prepare Statment

        mysqli_stmt_bind_param($stmt, "s", $user); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        while ($row = mysqli_fetch_assoc($result)) {

            $thirdParty[] = $row['tp_id']; // Update Array

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Delete Joint Users

        if (!empty($thirdParty)) {

            foreach ($thirdParty as $id) {

                deleteJointUser($dbConn, $id, $relativity);

            }

        }

        // Delete Records

        $tables = [ // Tables Records
            'accounts',
            'activity_logs',
            'beneficiaries',
            'billing_codes',
            'card_requests',
            'customers',
            'deposits',
            'invoices',
            'invoice_payments',
            'kyc_data',
            'loans',
            'loan_requests',
            'activity_logs',
            // 'messages', Fetch Ticket Id
            'notifications',
            'payments',
            'payout_schedule',
            'repayments_schedule',
            'requests',
            'subscriptions',
            'support_tickets',
            'third_party',
            'transactions',
            'users',
            'users_activity',
            'virtual_cards'
        ];

        // Delete Inivites & Referrals

        mysqli_query($dbConn, "DELETE FROM `referrals` WHERE `referrer` = '$user'");

        mysqli_query($dbConn, "DELETE FROM `invites` WHERE `referrer` = '$user'");

        $deleted = false; // Flag

        foreach ($tables as $table) {

            $delete_query = "DELETE FROM `{$table}` WHERE `user_id` = ?";

            // Prepare and execute the deletion query
            $stmt = mysqli_prepare($dbConn, $delete_query);

            // Check for errors in query preparation
            if (!$stmt) {
                die('Query preparation failed: ' . mysqli_error($dbConn));
            }

            mysqli_stmt_bind_param($stmt, 's', $user);
            mysqli_stmt_execute($stmt);

            if (mysqli_stmt_affected_rows($stmt) > 0) {
               
                $deleted = true; // Update Flag

            }

            mysqli_stmt_close($stmt);

        }

        return $deleted;

    }

    function deleteJointUser($dbConn, $user, $relativity) { // Delete Joint User

        // Remove Files Pertaining to User

        $files_to_delete = []; // Files Storage

        // Retrieve File Paths

        $query = "SELECT `pay_proof`, NULL AS `dep_proof`
        FROM `payments`
        WHERE `user_id` = ?

        UNION

        SELECT NULL AS `pay_proof`, `dep_proof`
        FROM `deposits`
        WHERE `user_id` = ?";

        $stmt = mysqli_prepare($dbConn, $query);

        // Check for errors in query preparation
        if (!$stmt) {
            die('Query preparation failed: ' . mysqli_error($dbConn));
        }

        mysqli_stmt_bind_param($stmt, 'ss', $user, $user);
        mysqli_stmt_execute($stmt);

        mysqli_stmt_bind_result($stmt, $pay_proof, $dep_proof);

        while (mysqli_stmt_fetch($stmt)) {
            // Check for non-NULL values and add the appropriate file paths to the array
            if ($pay_proof) {
                $files_to_delete[] = $pay_proof;
            }
            if ($dep_proof) {
                $files_to_delete[] = $dep_proof;
            }
        }
        
        mysqli_stmt_close($stmt); 

        // Delete File(s)
       
        foreach ($files_to_delete as $file) {

            $file = ($relativity) ? $relativity . str_replace('../', '', $file) : $file; // Re-construct File Path

            if (is_file($file) && file_exists($file)) {
                
                unlink($file);

            }
        }

        // Get Ticket ID(s) For Messages

        $ticketIDs = [];

        $stmt = mysqli_prepare($dbConn, "SELECT `ticket_id` FROM `support_tickets` WHERE `user_id` = ?"); // Prepare Statment

        mysqli_stmt_bind_param($stmt, "s", $user); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        while ($row = mysqli_fetch_assoc($result)) {

            $ticketIDs[] = $row['ticket_id']; // Update Array

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Delete Messages
        
        if (!empty($ticketIDs)) {
            // Prepare placeholders for IN clause, e.g. (?, ?, ?)
            $placeholders = implode(',', array_fill(0, count($ticketIDs), '?'));

            // Prepare statement for DELETE
            $deleteSql = "DELETE FROM `messages` WHERE `ticket_id` IN ($placeholders)";
            $deleteStmt = mysqli_prepare($dbConn, $deleteSql);

            // Create types string (all integers or strings depending on your ticket_id type)
            $types = str_repeat('s', count($ticketIDs)); // assuming ticket_id is string, change to 'i' if integer

            // Bind parameters dynamically
            mysqli_stmt_bind_param($deleteStmt, $types, ...$ticketIDs);

            mysqli_stmt_execute($deleteStmt);
            mysqli_stmt_close($deleteStmt);
        }

        // Delete Records

        $tables = [

            'transactions',
            'billing_codes',
            'notifications',
            'support_tickets',
            'payments',
            'deposits'

        ];

        $deleted = false; // Flag

        foreach ($tables as $table) {

            $delete_query = "DELETE FROM `{$table}` WHERE `user_id` = ?";

            // Prepare and execute the deletion query
            $stmt = mysqli_prepare($dbConn, $delete_query);

            // Check for errors in query preparation
            if (!$stmt) {
                die('Query preparation failed: ' . mysqli_error($dbConn));
            }

            mysqli_stmt_bind_param($stmt, 's', $user);
            mysqli_stmt_execute($stmt);

            if (mysqli_stmt_affected_rows($stmt) > 0) {
               
                $deleted = true; // Update Flag

            }

            mysqli_stmt_close($stmt);

        }

        if ($deleted) {

            mysqli_query($dbConn, "DELETE FROM `third_party` WHERE `tp_id` = '$user'");

        }

        return $deleted;

    }

    function break_commas($input) {

        // Track if first comma after number is found
        $firstNumberCommaFound = false;

        return preg_replace_callback('/,/', function($matches) use (&$input, &$firstNumberCommaFound) {
            static $offset = 0;

            // Get the position of the comma in the string
            $pos = strpos($input, $matches[0], $offset);
            $offset = $pos + 1;

            // Check char before the comma
            $before = ($pos > 0) ? $input[$pos - 1] : '';

            if (!$firstNumberCommaFound && is_numeric($before)) {
                // This is the first comma after a number - don't replace
                $firstNumberCommaFound = true;
                return ',';
            }

            // Else replace with line break (you can change to "<br>" if needed)
            return ",\n";
        }, $input);

    }

    function payResourceCount($dbConn) { // Pay Resource(s) Count 

        $num = 0;

        $stmt = mysqli_prepare($dbConn, "SELECT COUNT(*) AS `total_resources` FROM `pay_resources`"); // Prepare Statement

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) === 1) {

            while ($row = mysqli_fetch_assoc($result)) {

                $num = $row['total_resources'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        return $num;

    }

?>