<?php

    use PHPMailer\PHPMailer\PHPMailer; // PHP Mailer Class
        
    use PHPMailer\PHPMailer\Exception;  // PHP Mailer Class
    
    // MAIL DELIVERY Functions

    /* Here Lies the Functions For Mail Delivery.
    ENSURE TO USE @ SUPPRESSOR WHEN CALLING THE FUNCTIONS FOR SEAMLESS OPERATION */

    function deliverByPHPMailer($subject, $messageHTML, $messagePlain, $recipient, $recipientName, $from = SMTP_USER, $senderName = SITE_NAME, $mainURL = SITE_BASE_URL, $port = SMTP_PORT, $host = SMTP_HOST, $username = SMTP_USER, $key = SMTP_KEY, $encryption = SMTP_AUTH) { // PHP Mailer Delivery Function

        // Get Domain

        $domain = explode('@', $username);

        $domain = end($domain);

        // Generate a unique Message-ID
    
        $uniqueMsgID = '<' . uniqid('msg_', true) . '@' . $domain . '>';

        // Determine Encryption Protocol

        if (strtoupper($encryption) == 'TLS') {

            $encrypt = PHPMailer::ENCRYPTION_STARTTLS;

        } else if (strtoupper($encryption) == 'SSL') {

            $encrypt = PHPMailer::ENCRYPTION_SMTPS;

        }

        try {

            // Create a new PHPMailer instance
            $mail = new PHPMailer(true);

            // Server settings
            $mail->isSMTP(); // Set mailer to use SMTP
            $mail->Host = $host; // Specify the SMTP server
            $mail->SMTPAuth = true; // Enable SMTP authentication
            $mail->CharSet = 'UTF-8'; // Mail Encoding
            $mail->Username = $username; // SMTP username (use your credentials)
            $mail->Password = $key; // SMTP password 
            $mail->SMTPSecure = $encrypt; // Enable encryption or (strtolower($encryption))
            $mail->Port = (int)$port; // TCP port to connect to
            
            $mail->SMTPKeepAlive=true;
            $mail->Timeout=30;

            // Recipients
            $mail->setFrom($from, $senderName);
            $mail->addAddress($recipient, $recipientName); // Add recipient

            // Create unsubscribe link dynamically
            $unsubscribeLink = $mainURL . '/unsubscribe?email=' . urlencode($recipient);
            // Correctly format List-Unsubscribe header with both mailto and HTTP URL
            $mail->addCustomHeader('List-Unsubscribe', '<' . $unsubscribeLink . '>, <mailto:' . $from . '?subject=Unsubscribe%20from%20email%20list>');

            // Set unique Message-ID to avoid grouping
            // $mail->addCustomHeader('Message-ID', $uniqueMsgID);

            $mail->MessageID = $uniqueMsgID; // Override PHP Mailer's MessageID

            // Do not set In-Reply-To or References headers
            $mail->addCustomHeader('In-Reply-To', '');
            $mail->addCustomHeader('References', '');

            // Content
            $mail->isHTML(true); // Set email format to HTML
            $mail->Subject = $subject;
            $mail->Body    = $messageHTML . '<p style="margin-inline-start: auto; font-weight:500;font-size:0.8rem;line-height:30px;margin-bottom:16px;padding-top:1.3125rem; margin:0 auto;"><a href="' . $unsubscribeLink .'" target="_blank">Unsubscribe</a></p>';
            // . '<br><br><a href="' . $unsubscribeLink . '">Click here to unsubscribe</a>';
            $mail->AltBody = $messagePlain;  // Plain text version for non-HTML clients

            // Set priority and custom header
            $mail->Priority = 1; // High priority
            $mail->addCustomHeader('X-Priority', '1'); // High priority
            

            if ($mail->send()) { // Send the email

                return true;

            } else {

                return false;

            }

        } catch (Exception $e) {

            $logMessage = "Message could not be sent. Mailer Error: {$mail->ErrorInfo} - Exception: {$e->getMessage()}";

            error_log($logMessage);

            return false;
        }

    }

    function deliverByPHPMail($recipient, $subject, $message, $sender = SMTP_USER, $sendReply = SMTP_USER, $mainURL = SITE_BASE_URL) { // PHP's Default Mail Function

        $unsubscribeLink = $mainURL . '/unsubscribe?email=' . urlencode($recipient);

        // Get Domain

        $domain = explode('@', $sendReply);

        $domain = end($domain);

        // Generate a unique Message-ID
    
        $uniqueMsgID = '<' . uniqid('msg_', true) . '@' . $domain . '>';

        $msg = $message . '<p style="margin-inline-start: auto; font-weight:500;font-size:0.8rem;line-height:30px;margin-bottom:16px;padding-top:1.3125rem; margin:0 auto;"><a href="' . $unsubscribeLink .'" target="_blank">Unsubscribe</a></p>';

        $headers = [
            'MIME-Version' => '1.0',
            'Content-type' => 'text/html; charset=UTF-8',
            'From' => $sender,
            'Reply-To' => $sendReply,
            // 'X-Priority' => '1',  // 1 = High, 3 = Normal, 5 = Low
            // 'X-MSMail-Priority' => 'High', // Another header for priority
            // 'Importance' => 'High',  // Additional header to reinforce the priority
            // 'Message-ID' => $uniqueMsgID,  // Set unique Message-ID
            'List-Unsubscribe' => '<' . $unsubscribeLink . '>, <mailto:' . $sender . '?subject=Unsubscribe%20from%20email%20list>'
    
        ];

        // Convert headers array into a string format
        $headersString = '';
        foreach ($headers as $key => $value) {
            $headersString .= "$key: $value\r\n";
        }

        if (mail($recipient, $subject, $msg, $headersString)) {
            
            return true;
            
        } else {

            return false;
        
        }


    }

    function makePlain($html) { // Convert HTML To Plain Text

        // Strip HTML tags
        $plainText = strip_tags($html);

        // Decode HTML entities
        $plainText = html_entity_decode($plainText);

        return $plainText;

    }

?>