<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initialize Session(s)

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Custom Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) { // Check For Session

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = filter_var($_SESSION['USER-ID'], FILTER_SANITIZE_SPECIAL_CHARS); // Sanitize User ID

        $userData = userData($user, $conn); // Retrieve User Info 

        if (!$userData) { // No User Data

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $value = ($userData['auth'] === 'ENABLED') ? 'DISABLED' : 'ENABLED'; // Determine Value To Update To; Based On Present 2FA Field Value 

        $updated = false; // Flag

        // Prepare For Update

        $stmt = mysqli_prepare($conn, "UPDATE `users` SET `factor_2FA` = ? WHERE `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $value, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Initiate Update

            $updated = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $updated, 'action' => $value]); // Encode JSON Response

    }

?>