<?php

    session_name('USERSESSID');

session_start(); // Intiate Session(s)

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Custom Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $user = $_SESSION['USER-ID'];

        $account = filter_var(trim($_REQUEST['account']), FILTER_SANITIZE_SPECIAL_CHARS);

        $range = isset($_REQUEST['range']) ? filter_var($_REQUEST['range'], FILTER_SANITIZE_SPECIAL_CHARS) : 'ALL';

        $date = sanitizeDate(time());

        $accountData = accountData($account, $user, $conn); // Fetch Account Data

        if (!$accountData) {

            echo json_encode(['accError' => true]);

            exit;

        }

        $currency = $accountData['currency'];

        $balance = $accountData['balance'];

        $symbol = $currSymbol[$currency];

        // Determine Range Time Frame (SQL)

        $rangeData = "";

        switch ($range) {

            case '1M' : $rangeData = "AND DATE(`date`) >= '$date' - INTERVAL 1 MONTH"; break; // 1 Month
            
            case '3M': $rangeData = "AND DATE(`date`) >= '$date' - INTERVAL 3 MONTH"; break; // 3 Months

            case '6M': $rangeData = "AND DATE(`date`) >= '$date' - INTERVAL 6 MONTH"; break; // 6 Months

            case '1Y': $rangeData = "AND DATE(`date`) >= '$date' - INTERVAL 1 YEAR"; break; // 1 Year

            default: $rangeData = ""; break; // All Time

        }

        // Get Transactions

        $found = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT DATE(`date`) AS `day`, SUM(CASE WHEN `type` = 'CREDIT' THEN `amount` ELSE 0 END) AS `inflow`, SUM(CASE WHEN `type` = 'DEBIT' THEN `amount` ELSE 0 END) AS `outflow` FROM `transactions` WHERE `user_id` = CAST(? AS BINARY) AND `currency` = ? AND `status` = ? $rangeData GROUP BY DATE(`date`) ORDER BY `day` ASC"); // Prepare Statement

        $param = 'COMPLETED';

        mysqli_stmt_bind_param($stmt, "sss", $user, $currency, $param); // Bind Parameters

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        $transactions = [];

        if (mysqli_num_rows($result) > 0) {

            $found = true; // Update Flag

            $transactions = mysqli_fetch_all($result, MYSQLI_ASSOC);

            // while ($row = mysqli_fetch_assoc($result)) {

                // $transactions[] =  ['day' => $row['day'], 'inflow' => $symbol . number_format($row['inflow'], 2), 'outflow' => $symbol . number_format($row['outflow'], 2)];

            // }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        $data = ($found) ? $transactions : null;

        echo json_encode(['transc' => $data, 'symbol' => $symbol]);

        // $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

        // echo json_encode($data);


    }    

?>