<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Establish Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Custom Functions

    require('../../vendor/autoload.php'); // Composer Package File

    require('../engines/mail-delivery-engine.php'); // Mail Fxns

    require('../engines/mail-drafts.php'); // Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Sanitize Fields

        $user = filter_var($_SESSION['USER-ID'], FILTER_SANITIZE_SPECIAL_CHARS);

        $type = filter_var($_REQUEST['acc-type'], FILTER_SANITIZE_SPECIAL_CHARS);

        $currency = filter_var($_REQUEST['currency'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $kycState = $userData['kyc-status'] ?? 'UNVERIFIED';

        if ($kycState == 'UNVERIFIED' || $kycState == 'REJECTED') {

            echo json_encode(['kycError' => true]); // Encode JSON Response

            exit; // End Run

        } else if ($kycState == 'PROCESSING') {

            echo json_encode(['kycPending' => true]); // Encode JSON Response

            exit; // End Run

        }

        $success = false; // Flag

        $request = false; // Manual Request Flag

        if (ACC_PREF == 'AUTOMATIC') { // Check Approval Method

            // Fetch Bank

            $bank = null;
            
            $bankInfo = mysqli_prepare($conn, "SELECT * FROM `banks` WHERE `country` = CASE WHEN EXISTS (SELECT 1 FROM `banks` WHERE `country` = ?) THEN ? ELSE ? END ORDER BY RAND() LIMIT 1;"); // Prepare Statement

            $country = $currCountryCodes[$currency] ?? '';

            $default = 'DEFAULT';

            mysqli_stmt_bind_param($bankInfo, "sss", $country, $country, $default); // Bind Parameter(s)

            mysqli_stmt_execute($bankInfo); // Execute Statement

            $result = mysqli_stmt_get_result($bankInfo); // Get Statement Result

            if (mysqli_num_rows($result) === 1) {

                while ($row = mysqli_fetch_assoc($result)) {

                    $bank = $row['bank_id'];

                }

            }

            mysqli_free_result($result); // Free Result

            mysqli_stmt_close($bankInfo); // Close Statement

            // Create Account

            $createAccount = mysqli_prepare($conn, "INSERT INTO `accounts` (`user_id`, `acc_id`, `acc_num`, `currency`, `type`, `bank_id`) VALUES(?, ?, ?, ?, ?, ?)"); // Prepare Statement

            // Parameter(s)

            $accNum = mt_rand(10000000, 999999999);

            $idAcc = generateUniqueID($conn, 'accounts', $currency);

            mysqli_stmt_bind_param($createAccount, "ssisss", $user, $idAcc, $accNum, $currency, $type, $bank); // Bind Parameter(s)

            if (mysqli_stmt_execute($createAccount)) { // Execute Statements

                $success = true; // Update Flag

            }
            
            mysqli_stmt_close($createAccount);

        } else { // Create Request

            $date = timeGMT('Y-m-d');

            $request = true; // Update Flag

            $stmt = mysqli_prepare($conn, "INSERT INTO `requests` (`user_id`, `type`, `identifier`, `details`, `date`) VALUES(?, ?, ?, ?, ?)"); // Prepare Statement

            $type2 = 'ACCOUNT';

            mysqli_stmt_bind_param($stmt, "sssss", $user, $type2, $currency, $type, $date);

            if (mysqli_stmt_execute($stmt)) {

                $success = true; // Update Flag

            }

            mysqli_stmt_close($stmt);

            if ($success) {

                // Mail & Notifications

                $notf = 'You request for a/an ' . $currency . ' ' . $type . ' account has been submitted and is under consideration. Expect your secured ' . $currency . ' ' . $type . ' account soon!';

                createNotification($conn, $user, 'Account Request Alert!', $notf);

                $subject = 'New Account Request #' . mt_rand(10000000, 99999999);
                
                $mail = accountRequestAlert($userData['firstname'], $currency . ' ' . $type);

                $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

                if (!$deliver) {

                    @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

                }

                // Handle Admin Mail Delivery

                $mailAdmin = adminAccNotification(join(' ', [$userData['firstname'], $userData['lastname']]), $type, $currency);

                $deliver = @deliverByPHPMailer($subject, $mailAdmin, makePlain($mailAdmin), ADMIN_MAIL, ADMIN_NAME);

                if (!$deliver) {

                    @deliverByPHPMail(ADMIN_MAIL, $subject, $mailAdmin); // Fallback

                }

            }

        }    

        echo json_encode(['created' => $success, 'request' => $request]);

    }

?>