<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Function Definition(s)

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit;

        }

        // Sanitize Field(s)

        $user = filter_var($_SESSION['USER-ID'], FILTER_SANITIZE_SPECIAL_CHARS);

        $fname = filter_var($_REQUEST['fname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $mname = !empty($_REQUEST['mname']) ? filter_var($_REQUEST['mname'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $lname = filter_var($_REQUEST['lname'], FILTER_SANITIZE_SPECIAL_CHARS);

        $email = filter_var(strtolower(trim($_REQUEST['email'])), FILTER_SANITIZE_EMAIL);

        $gender = filter_var($_REQUEST['gender'], FILTER_SANITIZE_SPECIAL_CHARS);

        $title = !empty($_REQUEST['title']) ? filter_var($_REQUEST['title'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $emailInUse = emailExists($email, $conn); // Check If Email Is In Use

        if ($emailInUse) {

            echo json_encode(['emailTaken' => true]); // Encode JSON Response

            exit; // End Run

        }

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit;

        }

        $password = randomString(8); // Generate Password

        $key = md5($password); // Hash Password

        $id = generateUniqueID($conn, 'third_party', 'TPY'); // Generate Unique ID

        // Commence Data Drop

        $created = false; // Flag

        $stmt = mysqli_prepare($conn, "INSERT INTO `third_party` (`tp_id`, `email`, `password`, `pre_hash`, `fname`, `mname`, `lname`, `gender`, `title`, `user_id`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ssssssssss", $id, $email, $key, $password, $fname, $mname, $lname, $gender, $title, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $created = true;

        }
         
        mysqli_stmt_close($stmt); // Close Statement

        if ($created) {

            // Send Email

            $mail = thirdPartyMail($fname, join(' ', [$userData['firstname'], $userData['lastname']]), $email, $password); // Mail

            $subject = 'Joint User Alert';

            $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $email, join(' ', [$fname, $mname]));

            if (!$deliver) {

                $deliver = @deliverByPHPMail(join(' ', [$fname, $mname]), $subject, $mail);

            }

        }
        
        echo json_encode(['added' => $created, 'sent' => $deliver]); // Echo JSON Response

    }

?>