<?php

    // Credentials

    session_name('USERSESSID');

session_start(); // Initialize Session(s)

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) { // Check For User ID

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = filter_var($_SESSION['USER-ID'], FILTER_SANITIZE_SPECIAL_CHARS);

        $current = !empty($_REQUEST['current-avatar']) ? filter_var($_REQUEST['current-avatar'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $directory = '../../vault/avatars/';

        $photo = $_FILES['avatar'];

        $uploaded = false; // Upload Flag

        $photoPath = fileUpload($photo, $directory, 'avtr-', null, true); // Upload File

        if ($photoPath['status']) {

            $photoPath = $photoPath['vault']; // Get File Path

            $uploaded = true; // Update Flag

        } else {

            $photoPath = $photoPath['error']; // Get Error

        }

        // Check Flag

        if (!$uploaded) {

            echo json_encode(['uploadError' => true, 'error' => $photoPath]); // Encode JSON Response

            exit; // End Run

        }

        // Save Details

        $saved = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `users` SET `user_avatar` = ? WHERE `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $photoPath, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $saved =  true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        if (!$saved) { // Check Flag

            deleteFile($photoPath); // Delete File (Incase Update Fails)

        } else {

            if ($current) {

                deleteFile($current, '../../'); // Delete Previous Avatar

            }

        }

        echo  json_encode(['saved' => $saved]); // Encode JSON Response

    }

?>