<?php

    // Credentials

    session_name('USERSESSID');

session_start(); // Establish Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Custom Functions

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $user_id = $_SESSION['USER-ID'];

        $codeTrack = isset($_SESSION['CODE-TRACK']) ? $_SESSION['CODE-TRACK'] : 0;

        $codeCount = bcodeCount($user_id, $conn);

        $codeData = currentBcode($user_id, $conn, $codeTrack);

        if ($codeData['PIN-type'] == 'PERCENTAGE') {

            $percentage = ($codeData['PIN-percent']) / 100;

            $amount = $percentage * $_SESSION['SUBJECT-AMOUNT'];

            // if ($_SESSION['SUBJECT-CURR'] !== 'USD') {

            //     $amount = convertToUSD($amount, $_SESSION['SUBJECT-CURR']);

            // }

        } else {

            $amount = $codeData['PIN-amount'];

            if ($_SESSION['SUBJECT-CURR'] !== 'USD') {

                $convert = convertFromUSD($amount, $_SESSION['SUBJECT-CURR']);

                if ($convert) {

                    $amount = $convert;

                } else {

                    $_SESSION['SUBJECT-CURR'] = 'USD';
    
                }


            }

        }

        // Set Payment Essentials

        $_SESSION['PAY'] = $codeData['PIN-name'] . ' (BC)';

        $_SESSION['PAY-AMOUNT'] = $amount;

        $_SESSION['PAY-DESC'] = $codeData['PIN-ID'];

        echo json_encode(['bcodePay' => true]);

    }

?>