<?php

    // Credentials

    session_name('USERSESSID');

session_start(); // Initialize Session(s)
    
    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Custom Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = $_SESSION['USER-ID'];

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Check KYC

        if ($userData['kyc-status'] != 'PROCESSING' || $userData['kyc-status'] != 'VERIFIED') {

            echo json_encode(['kycError' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Get Face Descriptor

        // Store Face Descriptor

        $saved = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `kyc_data` SET `face` = ? WHERE `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $descriptor, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $saved = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['saved' => $saved]); // Encode JSON Response

    }    

?>