<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Establish Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Custom Functions

    require('../../vendor/autoload.php'); // Composer Package File

    require('../engines/mail-delivery-engine.php'); // Mail Delivery Fxns

    require('../engines/mail-drafts.php'); // Mail Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        
        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $user_id = $_SESSION['USER-ID'];

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user_id = $_SESSION['USER-ID'];

        $userData = userData($user_id, $conn); // Get User Data

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Sanitize Field(s)

        $method = filter_var($_REQUEST['via'], FILTER_SANITIZE_SPECIAL_CHARS);

        $card = filter_var($_REQUEST['card-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $amount = filter_var($_REQUEST['fund-amount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        // Check Amount

        if ($amount < 0) {

            echo json_encode(['invalidAmt' => true]);

            exit;

        }

        // Look For Card

        $cardFound = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `virtual_cards` WHERE `card_id` = ?"); // Prepare Statement (Virtual Card)

        mysqli_stmt_bind_param($stmt, "s", $card); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result
        
        if (mysqli_num_rows($result) === 1) {

            $cardFound = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $currency = $row['currency'];

                $provider = $row['provider'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        // Check For Card

        if (!$cardFound) {

            echo json_encode(['cardError' => true]);

            exit;

        }

        $symbol = $currSymbol[$currency] ?? null;

        // Check For Account

        $accFound = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `accounts` WHERE `currency` = ? AND `user_id` = ?"); // Prepare Statement (Look For Account)

        mysqli_stmt_bind_param($stmt, "ss", $currency, $user_id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) === 1) {

            $accFound = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $balance = $row['balance'];

                $accID = $row['acc_id'];

                $accNum = $row['acc_num'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        $time = timeGMT('l M d, Y (H:i) [T]'); // Time GMT

        $funded = false; // Card Fund Flag 

        if ($method == 'PAY') {

            $pay = true;

            $_SESSION['PAY'] = $currency . ' '  . $provider . ' CARD (FUND)';

            $_SESSION['PAY-AMOUNT'] = $amount;

            $_SESSION['PAY-DESC'] = $card;

            $_SESSION['SUBJECT-CURR'] = $currency;

            $subject = ' Virtual Card Deposit Alert #' . mt_rand(10000000, 99999999);

            $mail = cardFundNotification($userData['firstname'], $currency, $provider, $time, $symbol . number_format($amount, 2)); // Mail

            $notfTitle = 'Virtual Card Deposit Alert';

            $notf = 'An attempt to fund your ' . $currency . ' ' . $provider . ' virtual card with ' . $symbol . number_format($amount, 2) . ' '  . $currency . ' was just initiated on ' . $time . '.';

        } else if ($method == 'DEPOSIT') {
            
            if ($amount > $balance) { // Check Balance

                echo json_encode(['balError' => true]);

                exit;

            }

            $pay = false; // For External Payment

            $newBal = $balance - $amount;

            // Update Balances & Create Transaction

            $stmt1 = mysqli_prepare($conn, "UPDATE `virtual_cards` SET `balance` = `balance` + ? WHERE `card_id` = ? AND `user_id` = ?"); // Prepare Statement (Update Virtual Card Balance)

            mysqli_stmt_bind_param($stmt1, "dss", $amount, $card, $user_id); // Bind Parameter(s)

            $stmt2 = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = `balance` - ? WHERE `acc_id` = ? AND `user_id` = ?"); // Prepare Statement (Update Account Balance)

            mysqli_stmt_bind_param($stmt2, "dss", $amount, $accID, $user_id); // Bind Parameter(s)

            // $stmt3 Parameter(s)

            $transID = generateUniqueID($conn, 'transactions', 'TRN'); // Generate ID

            $transcType = 'DEBIT';

            $transcAction = 'MISCELLANOUS';

            $transcStatus = 'COMPLETED';

            $transcDescr = $currency . ' (' . $provider . ') DEPOSIT';

            $stmt3 = mysqli_prepare($conn, "INSERT INTO `transactions` (`user_id`, `trans_id`, `descr`, `type`, `action`, `currency`, `acc_id`, `acc_num`, `amount`, `acc_bal`, `status`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement (For Transactions)

            mysqli_stmt_bind_param($stmt3, "sssssssidds", $user_id, $transID, $transcDescr, $transcType, $transcAction, $currency, $accID, $accNum, $amount, $newBal, $transcStatus); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt1) && mysqli_stmt_execute($stmt2) && mysqli_stmt_execute($stmt3)) { // Execute Statement(s)

                $funded = true; // Update Flag

            }

            // Close Statements

            mysqli_stmt_close($stmt1);

            mysqli_stmt_close($stmt2);

            mysqli_stmt_close($stmt3);

            $subject = ' Virtual Card Fund Notification #' . mt_rand(10000000, 99999999);

            $mail = cardFundConfirmation($userData['firstname'], $currency, $provider, $time, $currency, $symbol . number_format($balance, 2), $symbol . number_format($newBal, 2)); // Mail

            $notfTitle = 'Virtual Card Deposit Alert';

            $notf = 'Your  ' . $currency . ' ' . $provider . ' virtual card was just funded with ' . $symbol . number_format($amount, 2) . ' '  . $currency . ' on ' . $time . ' from your '  . $currency . ' account.';

        } else {

            echo json_encode(['refresh' => true]);

            exit;

        }

        if ($funded || $pay) {

            // Deliver Messages & Create Notification

            createNotification($conn, $user_id, $notfTitle, $notf);

            $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $userData['email'], join('', [$userData['firstname'], $userData['lastname']]));

            if (!$deliver) {

                @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

            }

        }

        echo json_encode(['cardFunded' => $funded, 'pay' => $pay]); // Encode JSON Response

        exit;

    }

?>