<?php

    // Credentials

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Function(s) File

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Mail Delivery Function(s)

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $name = filter_var($_REQUEST['name'], FILTER_SANITIZE_SPECIAL_CHARS);

        $eAddress = filter_var($_REQUEST['email-address'], FILTER_SANITIZE_SPECIAL_CHARS);

        $subject = filter_var($_REQUEST['subject'], FILTER_SANITIZE_SPECIAL_CHARS);

        $message = filter_var($_REQUEST['message'], FILTER_SANITIZE_SPECIAL_CHARS);

        $time = timeGMT('l, M d Y, (H:i) [T]'); // Get UTC Time

        // Normalize Constants

        $platform = SITE_NAME;

        $platformURL = SITE_BASE_URL;

        // Build HTML Message

        $msg = <<<HTML
        
            <table style="width:100%">
                <tbody>

                    <tr>
                        <td>
                            <p style="padding-top:40px;text-align:left;font-weight:700;padding:0px 44px;font-size:1rem;font-weight:400;margin-bottom:16px">
                                Dear $platform Admin,
                            </p>
                        </td>
                    </tr>

                    <tr style="padding-top:0">
                        <td>
                            <h3 style="font-size: 1.5rem; padding: 0 44px;">New Enquiry Alert</h3>
                        </td>
                    </tr>
                    
                    <tr>
                        <td>
                            <p style="font-weight:400;line-height:30px;font-size:1rem;padding:0 44px">

                                An enquiry was just made on <i>$time</i> by <i>$name ($eAddress)</i> through <i>$platform ($platformURL)</i> enquiry form. Details below:<br>

                            </p>

                            <p style="font-weight:400;line-height:30px;font-size:1rem;margin:0 44px; padding: 0 16px; background-color: #e4ecf9; border-radius: 5px; font-family: monospace;">

                                <br><br>

                                Subject (Class): $subject<br>

                                Datetime: $time<br>

                                Message:<br>

                                $message<br><br>

                                Sender: $name ($eAddress)<br><br>
                                
                            <p>

                            <br><br>

                        </td>    
                            
                    </tr>
                
                </tbody>
            </table>

        HTML;

        $msg = mailStructure($msg);

        $subject = 'New Enquiry Alert #' . mt_rand(10000000, 99999999);

        $deliver = @deliverByPHPMailer($subject, $msg, makePlain($msg), ADMIN_MAIL, ADMIN_NAME, $eAddress, $name); // Deliver Message

        if (!$deliver) {

            $deliver = @deliverByPHPMail(ADMIN_MAIL, $subject, $msg, $eAddress, $eAddress); // Fallback

        }

        echo json_encode(['sent' => $deliver]); // Encode JSON Response

    }

?>