<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Inititate Session(s)

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Function Definition(s)

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Function Definition(s)

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_COOKIE['USER-iD'])) { // Check For Cookie

            echo json_encode(['cookieError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $browser = !empty($_REQUEST['browser']) ? filter_var($_REQUEST['browser'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $browserVersion = !empty($_REQUEST['browser-version']) ? filter_var($_REQUEST['browser-version'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $os = !empty($_REQUEST['os']) ? filter_var($_REQUEST['os'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $osVersion = !empty($_REQUEST['os-version']) ? filter_var($_REQUEST['os-version'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $device = !empty($_REQUEST['device']) ? filter_var(ucwords($_REQUEST['device']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $user = decrypt($_COOKIE['USER-iD']); // Decrypt Cookie

        $password = md5($_REQUEST['key']); // Hash Password Field

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) {

            echo json_encode(['cookieError' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Perform Checks

        if ($userData['key'] !== $password) { // Check Password

            echo json_encode(['pwrdError' => true]); // Encode JSON Response

            exit; // End Run

        }

        if ($userData['auth'] == 'ENABLED') { // Check 2FA Status

            $code = generateOTP($user, $conn); // Generate OTP  

            // Send OTP

            $mail = loginOTP($userData['firstname'], $code); // Mail Draft

            $plain = makePlain($mail);

            $subject = 'Verify Login Attempt #' . mt_rand(10000000, 99999999);
            
            $recipientName = join(' ', [$userData['firstname'], $userData['lastname']]);

            // $deliver = @deliverByPHPMailer($subject, $mail, $plain, $userData['email'], $recipientName);

            // if (!$deliver) {

            //     $deliver = @deliverByPHPMail($userData['email'], $subject, $mail); //  Fallback

            // }

            $_SESSION ['MAIL'] = $mail;

            $_SESSION['SUBJECT'] = $subject;

            $_SESSION['RECIPIENT'] = $recipientName;

            $_SESSION['MAIL-DEST'] = $userData['email'];
            
            // Set Required Session(s) [OTP Email]

            $_SESSION['MFA'] = $user;

            $_SESSION['MFA-TYPE'] = 'LOGIN';

            echo json_encode(['mfa' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Direct Login

        $ip = getIP(); //'172.177.213.10'; //'154.113.118.142'; //getIP(); // Get User's IP

        $ipData = @retrieveIPData($ip); // Get User's IP

        @date_default_timezone_set($ipData['timezone']); // Set Time Zone

        $token = randomString(30) . @join('/', [$device, $ipData['city'], $ipData['region'], $ipData['country'], $ipData['latitude'], $ipData['latitude']]);

        $token = encrypt($token); // Encrypt Token

        @activityLog($conn, $user, $device, $browser, $browserVersion, $os, $osVersion, $token, $ip, $ipData['timezone'], $ipData['city'], $ipData['region'], $ipData['country'], $ipData['country-code'], $ipData['latitude'], $ipData['longitude']); // Create User Log

        // Set Required Session(s) [Dashboard Access]

        $_SESSION['USER-ID'] = $user;

        $_SESSION['ACCESS'] = true;

        $_SESSION['USER-TYPE'] = 'USER';

        $_SESSION['CURRENT-USER'] = $user;

        setcookie('USER-iD', $_COOKIE['USER-iD'], time() + (86400 * 30), '/'); // Reset Cookie (Validity: 30days)

        setcookie('ACCESS-iD', $token, time() + 86400, '/'); // Set Cookie (Validity: 1day, 24Hrs)

        echo json_encode(['jumpMFA' => true]); // Encode JSON Response

        $time = timeGMT('l, M d Y, (H:i) [T]'); // GMT

        $msg = join(' ', [$userData['firstname'], $userData['lastname']]). ' your account and dashboard was just accessed with your login credentials on ' . $time . '.';

        createNotification($conn, $user, 'Login Detected', $msg); // Notify Main User

        if ($userData['login-alerts'] == 'ENABLED') { // Login Alert

            $city = $ipData['city'];

            $region = $ipData['region'];

            $country = $ipData['country'];

            $logs = [

                'ip-address' => $ipData['ip'],

                'device' => ucwords($device . ', ' . $os . ' ' . $osVersion),

                'location' => implode(', ', array_filter([$city, $region, $country], fn($part) => !is_null($part) && $part !== '')),

                'browser' => $browser . ', ' . $browserVersion,

            ];

            $subject = 'Login Detected #' . mt_rand(10000000, 99999999);

            $mail = loginAlert($userData['firstname'], $time, $logs);

            $plain = makePlain($mail);

            $recipient = $userData['email'];

            $recipientName = join(' ', [$userData['firstname'], $userData['lastname']]);

            $_SESSION ['MAIL'] = $mail;

            $_SESSION['SUBJECT'] = $subject;

            $_SESSION['RECIPIENT'] = $recipientName;

            $_SESSION['MAIL-DEST'] = $recipient;

            // $deliver = @deliverByPHPMailer($subject, $mail, $plain, $recipient, $recipientName);

            // if (!$deliver) {

            //     @deliverByPHPMail($recipient, $subject, $mail); // Fallback

            // }

        }

        exit; // End Run
            

    }

?>