<?php

    // Credentials

    require('../config/config.php'); // Configuration Setup

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['cus-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Commence Deletion

        $deleted = false; // Flag

        $stmt = mysqli_prepare($conn, "DELETE FROM `customers` WHERE `customer_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        $stmtB = mysqli_prepare($conn, "DELETE FROM `invoices` WHERE `customer_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmtB, "s", $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmtB) && mysqli_stmt_execute($stmt)) { // Execute Statement

            $deleted = true; // Update Flag

        }

        // Close Statement(s)

        mysqli_stmt_close($stmt);

        mysqli_stmt_close($stmtB);

        echo json_encode(['deleted' => $deleted]); // Encode JSON Response

    

    }

?>