<?php

    // Credentials

    require('../config/config.php'); // Configuration Setup

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)
        
        $id = filter_var($_REQUEST['beneficiary-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $name = filter_var($_REQUEST['beneficiary-name'], FILTER_SANITIZE_SPECIAL_CHARS);

        $account = filter_var($_REQUEST['beneficiary-account'], FILTER_SANITIZE_SPECIAL_CHARS);

        $bank = filter_var($_REQUEST['beneficiary-bank'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Commence Data Drop

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `beneficiaries` SET `name` = ?, `account` = ?, `bank` = ? WHERE `id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ssss", $name, $account, $bank, $id); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Updated Flag

        }

        mysqli_stmt_close($stmt); // CLose Statement

        echo json_encode(['updated' => $updated]); // Encode JSON Response

    }

?>