<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initialize Session(s)

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = $_SESSION['USER-ID'];

        // Sanitize Field(s)

        $tag = filter_var($_REQUEST['new-tag'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (preg_match_all('/[^a-zA-Z0-9_]/', $tag, $matches)) { // Look For Invalid Character(s)

            $invalidChars = array_unique($matches[0]); // remove duplicates if you want

            echo json_encode(['invalidTag' => true, 'invalidChars' => implode($invalidChars)]); // Encode JSON Response

            exit; // End Run

        } else if (strlen($tag) < 3) {

            echo json_encode(['lengthError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $tagExists = tagExists($tag, $conn); // Check If Tag Exists

        if ($tagExists) {

            echo json_encode(['tagExists' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Commence Data Update

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `users` SET `username` = ? WHERE `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $tag, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement

            $updated = true; // Update Flag

        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $updated]); // Encode JSON Response

    }

?>