<?php

    // Credentials

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    // Request Processor

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $id = filter_var(trim($_REQUEST['id']), FILTER_SANITIZE_SPECIAL_CHARS);

        // Fetch Account Details

        $details = mysqli_prepare($conn, "SELECT * FROM `accounts` AS `A` LEFT JOIN `banks` AS `B` ON `A`.`bank_id` = `B`.`bank_id` WHERE `A`.`acc_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($details, "s", $id); // Bind Parameters

        mysqli_stmt_execute($details); // Execute Statement

        $result = mysqli_stmt_get_result($details); // Get Statement Result

        if (mysqli_num_rows($result) > 0) {

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result Data
            
            // Iterate Through Data

            foreach ($data as $account):

                $balance = $account['balance'];

                $currency  = $account['currency'];

                $symbol = $currSymbol[$currency] ?? '';

                $flag = $currCountryCodes[$currency];

                $name = $currCodeNames[$currency] ?? '';

                $number = $account['acc_num'];

                $type = $account['type'];

                $bank = $account['name'];

                $logo =  $account['logo'];

                $branch = $account['branch'];

                $codeType = $account['bank_codetype'];

                $code = $account['bank_code'];

                $class = $account['class'];

            endforeach;    

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($details); // Close Statement

        $body = '';

        if ($bank != null) {

            if (!is_null($logo)) {

                $logo = '<div class="radial_icon">

                    <img src="' . SITE_BASE_URL . '/' . str_replace('../', '', $logo) . '" alt="">

                </div>';

            }

            $body = '<div>

                <div class="dH_item">
                
                    <p>'. $bank . '</p>' 
                    
                    . $logo .
                    
                '</div>

                <div class="dH_item">

                    <div>Branch:</div>

                    <p>'. $branch . '</p>

                </div>

                <div class="dH_item">

                    <p>' . $codeType . ':<p>

                    <p>' . $code . '</p>

                </div>

            </div>';

        }

        $response[] = '<div class="dataHold">

            <div>

                <div class="dH_item">

                    <div class="radial_icon">

                        <img src="https://flagcdn.com/' . strtolower($flag) . '.svg" alt="">

                    </div>    

                    <p>'. ucwords($name) .'</p>

                </div>

            </div>

            <div>

                <div class="dH_item">

                    <p>Account Number:</p>

                    <p class="flx"><span class="copy-field">' . $number . '</span> 
                        <span class="copier-trigger">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none">
                                <path d="M10 8V7C10 6.05719 10 5.58579 10.2929 5.29289C10.5858 5 11.0572 5 12 5H17C17.9428 5 18.4142 5 18.7071 5.29289C19 5.58579 19 6.05719 19 7V12C19 12.9428 19 13.4142 18.7071 13.7071C18.4142 14 17.9428 14 17 14H16M7 19H12C12.9428 19 13.4142 19 13.7071 18.7071C14 18.4142 14 17.9428 14 17V12C14 11.0572 14 10.5858 13.7071 10.2929C13.4142 10 12.9428 10 12 10H7C6.05719 10 5.58579 10 5.29289 10.2929C5 10.5858 5 11.0572 5 12V17C5 17.9428 5 18.4142 5.29289 18.7071C5.58579 19 6.05719 19 7 19Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </span>
                            
                    </p>

                </div>

                <div class="dH_item">

                    <p>Balance:</p>

                    <p>'. $symbol  . number_format($balance, 2) . '</p>

                </div>

                <div class="dH_item">

                    <div class="label">' . $class . '</div>

                </div>

                <div class="dH_item">

                    <div class="label">' . $type . '</div>

                    <p>'. $currency . '</p>

                </div>

            </div>' . $body .

        '</div>';

        echo json_encode(['status' => true, 'html' => implode('', $response)]);

    }

?>