<?php

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $id = filter_var($_REQUEST['notf-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Commence Data Fetch

        $found = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `notifications` WHERE `notf_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) === 1) {

            $found = true; // Update Flag

            while ($row = mysqli_fetch_assoc($result)) {

                $title = $row['title'];

                $msg = $row['message_text'];

                $date = $row['date_created'];

                $readableDate = readableDateDiff($date);

                $date = date('l M d, Y', strtotime($date));

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        $body = null;

        if ($found) {

            $body = <<<HTML
            
                <p class="title">Subject: $title</p>

                <p class="text-min">$date ($readableDate)</p>

                <p>$msg</p>

            HTML;

        }

        echo json_encode(['found' => $found, 'data' => $body]); // Encode JSON Response

    }

?>