<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initialize Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // User-defined Functions

    header('Content-Type: application/json'); // Communication Protocol

    // Request Processor
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $id = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        // Get Transaction Details

        $found = false; // Flag

        $details = []; // Hold Details

        $stmt = mysqli_prepare($conn, "SELECT * FROM `transactions` WHERE `trans_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "s", $id); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) === 1) { // Get & Compare Result's Mass 

            $found = true; // Update Flag

            // Iterate Through Result

            while ($row = mysqli_fetch_assoc($result)) {

                $status = $row['status'];
                
                // $date = date('l jS, F, Y H:i', strtotime($row['date']));

                $date = date('l jS, F, Y', strtotime($row['date']));

                $time = date('H:i', strtotime($row['date']));

                $currency = $row['currency'];

                $symbol = $currSymbol[$currency];

                $amount = number_format($row['amount'], 2);

                $source = $row['acc_num'];

                $dest = $row['recpt_acc'];

                $recipient = $row['recpt_name'];

                $type = $row['type'];

                $scope = $row['action'];

                $bank = $row['recpt_bank'];

                $code = $row['banking_code'];

                $codeType = $row['banking_codetype'];

                $desc = $row['descr'];

                $uetr = $row['uetr'];

                $ref = $row['trans_id'];

                $descriptor = $type == 'CREDIT' ? 'Benefactor' : 'Sender';

            }

        }

        mysqli_free_result($result); // Free Result
        
        mysqli_stmt_close($stmt); // Close Statement

        // Check Flag

        if ($found) {

            $transferData = null;

            if ($scope == 'CROSS-BORDER TRANSFER' || $scope == 'LOCAL TRANSFER') {

                $transferData .= <<<HTML

                    <div>Account: $dest</div>

                    <div>Bank: $bank</div>

                    <div>Recipient: $recipient</div>

                HTML;

                if ($scope == 'CROSS-BORDER TRANSFER') {

                    $transferData .= <<<HTML
                                
                        <div>Banking Code: $codeType</div>

                        <div>Code: $code</div>

                        <div>UETR: <div class="flx"><span class="copy-field">$uetr</span> 
                            <span class="copier-trigger">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none">
                                    <path d="M10 8V7C10 6.05719 10 5.58579 10.2929 5.29289C10.5858 5 11.0572 5 12 5H17C17.9428 5 18.4142 5 18.7071 5.29289C19 5.58579 19 6.05719 19 7V12C19 12.9428 19 13.4142 18.7071 13.7071C18.4142 14 17.9428 14 17 14H16M7 19H12C12.9428 19 13.4142 19 13.7071 18.7071C14 18.4142 14 17.9428 14 17V12C14 11.0572 14 10.5858 13.7071 10.2929C13.4142 10 12.9428 10 12 10H7C6.05719 10 5.58579 10 5.29289 10.2929C5 10.5858 5 11.0572 5 12V17C5 17.9428 5 18.4142 5.29289 18.7071C5.58579 19 6.05719 19 7 19Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </span></div>
                        </div>
                    
                    HTML;

                }

            }

            $details[] = <<<HTML

                <div class="detail_con">

                    <div class="detail_conBox">

                        <p class="title">$id ~ Details</p>

                        <div class="detail_grid">

                            <div>Date: $date</div>

                            <div>Time: $time</div>

                            <div>Scope: $scope</div>

                            <div>Type: $type</div>

                            <div>Currency: <span translate="no">$currency</span></div>

                            <div>Amount: $symbol$amount</div>
                            
                            <div>Description: $desc</div>

                            $transferData

                        </div>

                    </div>

                </div>

            HTML;

        }

        echo json_encode(['status' => $found, 'structure' => implode('', $details)]); // Encode JSON Response

        exit; // End Run

    }

?>