<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Functions File

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Mail Fxns

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $user = $_SESSION['USER-ID'];

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $oldProof = $userData['proof-front'];

        $oldProofBack = $userData['proof-back'];

        // Sanitize Fields

        $docType = filter_var($_REQUEST['doc_type'], FILTER_SANITIZE_SPECIAL_CHARS);

        $docNum = filter_var($_REQUEST['id_num'], FILTER_SANITIZE_SPECIAL_CHARS);

        $country = filter_var($_REQUEST['issuing_country'], FILTER_SANITIZE_SPECIAL_CHARS);

        $issued = sanitizeDate($_REQUEST['date_issued']);

        $expires = sanitizeDate($_REQUEST['date_due']);

        $proof = $_FILES['id_proof'];

        $proofBack = !empty($_FILES['id_proofBack']['name']) ? $_FILES['id_proofBack'] : null;

        $proofPath = null;

        $backPath = null;

        $directory = '../../vault/kyc-data/';

        // Upload Proof

        $proofPath = fileUpload($proof, $directory, 'kyc-', 250);

        if ($proofPath['status']) {

            $proofPath = $proofPath['vault'];

        } else {

            echo json_encode(['proofError' => true, 'error' => $proofPath['error']]);

            exit;

        }

        if ($proofBack) {

            // Upload Document (Back)

            $backPath = fileUpload($proofBack, $directory, 'kyc-', 250);

            if ($backPath['status']) {

                $backPath = $backPath['vault'];

            } else {

                echo json_encode(['backError' => true, 'error' => $backPath['error']]);

                exit;

            }

        }

        // Upload Data

        $kycInserted = false; // Flag

        $insert = mysqli_prepare($conn, "INSERT INTO `kyc_data` (`user_id`, `id_proof`, `id_proofBack`, `id_type`, `id_num`, `id_issued`, `id_expires`, `issuing_country`, `status`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE `id_proof` = VALUES(`id_proof`), `id_proofBack` = VALUES(`id_proofBack`), `id_type` = VALUES(`id_type`), `id_num` = VALUES(`id_num`), `id_issued` = VALUES(`id_issued`), `id_expires` = VALUES(`id_expires`), `issuing_country` = VALUES(`issuing_country`), `status` = VALUES(`status`)"); // Prepare Statement

        $user = $_SESSION['USER-ID'];

        $status = 'PROCESSING';

        mysqli_stmt_bind_param($insert, "sssssssss", $user, $proofPath, $backPath, $docType, $docNum, $issued, $expires, $country, $status); // Bind Parameter(s)

        if (mysqli_stmt_execute($insert)) { // Execute Statement

            $kycInserted = true; // Update Flag

        }

        mysqli_stmt_close($insert); // Close Statement

        // Check Flag

        if ($kycInserted) {

            // Delete Previous Document(s)

            deleteFile($oldProof, '../../');

            deleteFile($oldProofBack, '../../');

            // Notify User

            $msg = 'Dear ' . join(' ', [$userData['firstname'], $userData['lastname']]) . ', your KYC application has been successfully completed and is currently under review. Please bear with us whilst processing is carried out. Best regards!';

            createNotification($conn, $user, 'KYC Application Submitted!', $msg);

            // Notify Admin

            $userInfo = $userData['firstname'] . ' ' . $userData['lastname'] . ' (' . $userData['email'] . ')';

            $subject = 'KYC Application Alert #' . mt_rand(10000000, 99999999);

            $mailAdmin = adminKYCNotification($userInfo);

            $deliverAdmin = @deliverByPHPMailer($subject, $mailAdmin, makePlain($mailAdmin), ADMIN_MAIL, ADMIN_NAME);

            if (!$deliverAdmin) {

                @deliverByPHPMail(ADMIN_MAIL, $subject, $mailAdmin); // Fallback

            }

        } else {

            // Delete Uploaded Document(s)

            deleteFile($oldProof, '../../');

            deleteFile($oldProofBack, '../../');

        }

        echo json_encode(['completed' => $kycInserted]);
    }

?>