<?php

    // Credentials

    session_name('USERSESSID');

session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // User-defined Functions

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $identifier = filter_var($_REQUEST['id'], FILTER_SANITIZE_SPECIAL_CHARS);

        if (!isset($_SESSION['USER-ID'])) { // Check For Session

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = $_SESSION['USER-ID']; // Make Use Of Session

        // Fetch Loan Info

        $found = false; // Flag

        $stmt = mysqli_prepare($conn, "SELECT * FROM `loans` WHERE `loan_id` = ? AND `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $identifier, $user); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Statement Result

        if (mysqli_num_rows($result) === 1) { // Compare Result Mass

            $found = true;

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

        }

        if (!$found) {

            echo json_encode(['nonExistent' => true]);

            exit;

        }

        foreach ($data as $row) {

            $currency = $row['currency'];

        }

        $symbol = $currSymbol[$currency]; // Get Currency Symbol

        // Fetch Loan Repayment Schedule

        $records = false; // Flag

        $stmt2 = mysqli_prepare($conn, "SELECT SUM(CASE WHEN `status` = ? THEN `amount` ELSE 0 END) AS `paid`, SUM(CASE WHEN `status` = ? AND `due` < ? THEN `amount` ELSE 0 END) AS `owed`, SUM(CASE WHEN `status` = ? AND `due` = ? THEN `amount` ELSE 0 END) AS `current` FROM `repayments_schedule` WHERE `loan_id` = ? AND `user_id` = ?"); // Prepare Statement

        $date = date('Y-m-d', time());

        $status = 'PAID';

        $status2 = 'PENDING';

        mysqli_stmt_bind_param($stmt2, "sssssss", $status, $status2, $date, $status2, $date, $identifier, $user); // Bind Parameter(s)

        mysqli_stmt_execute($stmt2); // Execute Statement

        $result = mysqli_stmt_get_result($stmt2);

        if (mysqli_num_rows($result) > 0) {

            $records = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt2); // Close Statement

        // Fetch Future Payments

        $future = false; // Flag

        $stmt3 = mysqli_prepare($conn, "SELECT * FROM `repayments_schedule` WHERE `due` > ? AND `loan_id` = ? AND `user_id` = ?"); // Prepare Statement
        
        mysqli_stmt_bind_param($stmt3, "sss", $date, $identifier, $user); // Bind Parameter(s)

        mysqli_stmt_execute($stmt3); // Execute Statement

        $result = mysqli_stmt_get_result($stmt3); // Fetch Result

        if (mysqli_num_rows($result) > 0) { // Compare Result

            $future = true;

            $dataB = mysqli_fetch_all($result, MYSQLI_ASSOC); // Store Result

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt3); // Close Statement

        $futurePayments = null;

        if ($future) {

            foreach ($dataB as $row):

                $amount = number_format($row['amount'], 2);

                $due = date('M d, Y', strtotime($row['due']));

                $futurePayments .= <<<HTML

                    <div class="dH_item">
                    
                        <div>$symbol $amount</div>

                        <div>$due</div>
                    
                    </div>

                HTML;

            endforeach;

        }

        $payments = null;

        if ($records) {

            foreach ($data as $row):

                $paid = $row['paid'];

                $owed = $row['owed'];

                $current = $row['current'] ?? 0;

                $pay = $current + $owed;

                $pay = round($pay, 2);

            endforeach;

            if ($paid > 0) {

                $paid = number_format($paid, 2);

                $payments .= <<<HTML

                    <div class="dH_item">
                    
                        <div>$symbol $paid</div>

                        <div class="dH_icon">

                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M2.49992 10C2.49992 5.85787 5.85778 2.5 9.99992 2.5C14.1421 2.5 17.4999 5.85787 17.4999 10C17.4999 14.1421 14.1421 17.5 9.99992 17.5C5.85778 17.5 2.49992 14.1421 2.49992 10ZM9.99992 0.833336C4.93731 0.833336 0.833252 4.93739 0.833252 10C0.833252 15.0626 4.93731 19.1667 9.99992 19.1667C15.0625 19.1667 19.1666 15.0626 19.1666 10C19.1666 4.93739 15.0625 0.833336 9.99992 0.833336ZM14.3466 8.49842C14.6679 8.16889 14.6612 7.64129 14.3317 7.32C14.0021 6.99871 13.4745 7.00539 13.1533 7.33492L8.85322 11.7452L6.82463 9.81322C6.49136 9.49582 5.96388 9.50868 5.64647 9.84196C5.32907 10.1752 5.34193 10.7027 5.67521 11.0201L8.29424 13.5144C8.62806 13.8324 9.15551 13.8226 9.47734 13.4925L14.3466 8.49842Z" fill="#20B26C"/></svg>

                        </div>
                    
                    </div>

                HTML;

            }

            if ($owed > 0) {

                $owed = number_format($owed, 2);

                $payments .= <<<HTML

                    <div class="dH_item">
                    
                        <div>$symbol $owed</div>

                        <div class="dH_icon">

                            <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px" viewBox="0 0 24 24" fill="none"><path id="vector (Stroke)" fill-rule="evenodd" clip-rule="evenodd" d="M12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12C21.25 6.89137 17.1086 2.75 12 2.75ZM1.25 12C1.25 6.06294 6.06294 1.25 12 1.25C17.9371 1.25 22.75 6.06294 22.75 12C22.75 17.9371 17.9371 22.75 12 22.75C6.06294 22.75 1.25 17.9371 1.25 12Z" fill="#c72626"/><path id="vector (Stroke)_2" fill-rule="evenodd" clip-rule="evenodd" d="M8.46967 8.46967C8.76257 8.17678 9.23744 8.17678 9.53033 8.46967L15.5303 14.4697C15.8232 14.7626 15.8232 15.2374 15.5303 15.5303C15.2374 15.8232 14.7625 15.8232 14.4696 15.5303L8.46967 9.53033C8.17678 9.23743 8.17678 8.76256 8.46967 8.46967Z" fill="#c72626"/><path id="vector (Stroke)_3" fill-rule="evenodd" clip-rule="evenodd" d="M15.5303 8.46967C15.8232 8.76257 15.8232 9.23744 15.5303 9.53033L9.53033 15.5303C9.23743 15.8232 8.76256 15.8232 8.46967 15.5303C8.17678 15.2374 8.17678 14.7625 8.46967 14.4696L14.4697 8.46967C14.7626 8.17678 15.2374 8.17678 15.5303 8.46967Z" fill="#c72626"/></svg>

                        </div>
                    
                    </div>

                HTML;

            }

            if ($pay > 0 || $current > 0) {

                $current = number_format($current, 2);

                $payments .= <<<HTML

                    <div class="dH_item">
                    
                        <div>$symbol $pay</div>

                        <div id="loan-data">

                            <input name="loan-id" type="hidden" value="$identifier">

                            <button type="button" name="pay-loan">Pay</button>

                        </div>
                    
                    </div>

                HTML;

            }

        }

        if (($records && !empty($records)) || ($future && !empty($future))) {

            $response[] = <<<HTML

                <div class="dataHold">

                    <div>

                        $payments

                        $futurePayments

                    </div>    

                </div>    

            HTML;

            echo json_encode(['records' => true, 'html' => implode('', $response)]);

        } else {

            echo json_encode(['records' => false]);

        }

    }

?>
