<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Function Definition(s)

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Function Definition(s)

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Specify HTTP Content Type

    // Process Form

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Field(s)

        $browser = !empty($_REQUEST['browser']) ? filter_var($_REQUEST['browser'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $browserVersion = !empty($_REQUEST['browser-version']) ? filter_var($_REQUEST['browser-version'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $os = !empty($_REQUEST['os']) ? filter_var($_REQUEST['os'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $osVersion = !empty($_REQUEST['os-version']) ? filter_var($_REQUEST['os-version'], FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $device = !empty($_REQUEST['device']) ? filter_var(ucwords($_REQUEST['device']), FILTER_SANITIZE_SPECIAL_CHARS) : null;

        $identifier = $_REQUEST['identifier'];

        // Identify Identifier Type

        $idType = 'EMAIL'; // Default

        if (filter_var(strtolower(trim($identifier)), FILTER_VALIDATE_EMAIL)) { // Email

            $identifier = filter_var(strtolower(trim($identifier)), FILTER_SANITIZE_EMAIL);

        } else if (is_numeric($identifier)) { // Account Number

            $identifier = filter_var(trim($identifier), FILTER_SANITIZE_SPECIAL_CHARS);

            $idType = 'ACCOUNT';

        } else { // Username

            $identifier = filter_var(trim($identifier), FILTER_SANITIZE_SPECIAL_CHARS);

            $idType = 'TAG';

        }

        $key = md5($_REQUEST['key']); // Hash Key

        $validate = login($conn, $identifier, $key); // Validate User Login

        if (!$validate) {

            // Troubleshoot

            if ($idType == 'EMAIL') {

                if (!emailExists($identifier, $conn)) { // Invalid Email

                    echo json_encode(['invalidEmail' => true]); // Encode JSON Response

                    exit; // End Run

                }

            } else if ($idType == 'TAG') {

                if (!tagExists($identifier, $conn)) { // Invalid Tag

                    echo json_encode(['invalidTag' => true]); // Encode JSON Response

                    exit; // End Run

                }

            } else {

                if (!accountExists($identifier, $conn)) { // Invalid Account Number

                    echo json_encode(['invalidAcc' => true]); // Encode JSON Response

                    exit; // End Run

                }

            }

            // Password Error

            echo json_encode(['invalidKey' => true]); // Encode JSON Response

            exit; // End Run

        }

        if ($validate['reg-clearance'] == 'PENDING') {

            echo json_encode(['regPending' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Determine User Type (Main User Or Third Party)

        $currentUser = $validate['id']; // Main User

        if ($validate['joint-user']) { // Third Party

            $currentUser = $validate['joint-user'];

        }

        // Check Account Status

        if ($validate['main-status'] === 'BANNED') {

            $_SESSION['RESTRICTED'] = true;

            echo json_encode(['restricted' => true]); // Encode JSON Response

            exit; // End Run

        } else if ($validate['main-status'] === 'BLOCKED' || $validate['main-status'] === 'SUSPENDED' || $validate['status'] === 'BLOCKED' || $validate['status'] === 'SUSPENDED') { // Check Account Status

            $msg = $validate['main-status'];

            if ($validate['joint-user']) {

                $msg = ($validate['main-status'] !== 'BLOCKED' || $validate['main-status'] !== 'SUSPENDED') ? $validate['status'] : $validate['status'];

            }

            echo json_encode(['statusError' => $msg]); // Encode JSON Response

            exit; // End Run

        }

        if ($validate['registered-by'] == 'ADMIN' && is_null($validate['reg-constraint'])) { // Check If Registered By Admin (Incomplete Registration)

            $_SESSION['REG-ID'] = $validate['id'];

            echo json_encode(['regIncomplete' => true]); // Encode JSON Response

            exit; // End Script

        }

        if ($validate['auth'] == 'ENABLED') { // Active 2FA
            
            $email = $validate['email']; // User's Email Address

            $recipientName = join(' ', [$validate['firstname'], $validate['lastname']]);

            $code = generateOTP($validate['id'], $conn); // Generate OTP
            
            // Send OTP

            $mail = loginOTP($validate['firstname'], $code); // Message Draft

            $plain = makePlain($mail);

            $subject = 'Verify Login Attempt #' . mt_rand(10000000, 99999999);

            $_SESSION ['MAIL'] = $mail;

            $_SESSION['SUBJECT'] = $subject;

            $_SESSION['RECIPIENT'] = $recipientName;

            $_SESSION['MAIL-DEST'] = $email;

            // $deliver = @deliverByPHPMailer($subject, $mail, $plain, $email, $recipientName);

            // if (!$deliver) {

            //     $deliver = @deliverByPHPMail($email, $subject, $mail); //  Fallback

            // }

            $_SESSION['MFA'] = $validate['id']; // Access For Next Stage

            $_SESSION['MFA-TYPE'] = 'LOGIN';

            echo json_encode(['mfa' => true]); // Encode JSON Response

            exit; // Terminate Script

        }

        // Direct Login

        $userType = $validate['user-type'];

        $_SESSION['USER-ID'] = $validate['id'];

        $_SESSION['ACCESS'] = true;

        $_SESSION['USER-TYPE'] = $userType;

        $_SESSION['CURRENT-USER'] = $currentUser;

        $ip = getIP(); // Get User's IP

        $ipData = @retrieveIPData($ip); // Get User's IP

        $dateTime = timeGMT('l, M d Y, (H:i) [T]'); // GMT Time

        if ($userType !== 'THIRD PARTY') {

            $token = randomString(30) . @join('/', [$device, $ipData['city'], $ipData['region'], $ipData['country'], $ipData['latitude'], $ipData['latitude']]);

            $token = encrypt($token); // Encrypt Token

            @date_default_timezone_set($ipData['timezone']); // Set Time Zone

            @activityLog($conn, $currentUser, $device, $browser, $browserVersion, $os, $osVersion, $token, $ip, $ipData['timezone'], $ipData['city'], $ipData['region'], $ipData['country'], $ipData['country-code'], $ipData['latitude'], $ipData['longitude']); // Create User Log

            $encryptID = encrypt($currentUser); // Encrypt Current User

            setcookie('USER-iD', $encryptID, time() + (86400 * 30), '/'); // Set Cookie (Validity: 30days)

            setcookie('ACCESS-iD', $token, time() + 86400, '/'); // Set Cookie (Validity: 1day, 24Hrs)

            $msg = join(' ', [$validate['firstname'], $validate['lastname']]) . ' your account and dashboard was just accessed with your login credentials on ' . $dateTime .  '.';

            createNotification($conn, $validate['id'], 'Login Detected', $msg); // Notify Main User

        } else if ($userType == 'THIRD PARTY') {

            $_SESSION['IP'] = $ipData['ip'];

            $_SESSION['FLAG'] = '<img src="https://flagcdn.com/' . strtolower($ipData['country-code']) . '.svg" alt="" width="20px">';

            $_SESSION['LOCATION'] = join(', ', [$ipData['city'], $ipData['region'], $ipData['country']]);

            $_SESSION['TIMEZONE'] = $ipData['timezone'];

            $msg = join(' ', [$validate['firstname'], $validate['lastname']]) . ' just accessed your account and dashboard on ' . $dateTime .  '.';

            $msg2 = 'You\'re currently accessing ' . $validate['main-name'] . '\'s account(s) and dashboard as ' . join(' ', [$validate['firstname'], $validate['lastname']]) .  ' a joint user with limited access privileges. Login Time: ' . $dateTime .  '.';

            createNotification($conn, $validate['id'], 'Joint Holder Login Detected', $msg); // Notify Main User

            createNotification($conn, $validate['joint-user'], 'Login Detected', $msg2); // Notify Joint User

        }

        echo json_encode(['jumpMFA' => true]); // Encode JSON Response

        // exit; // End Run

        if ($validate['login-alerts'] === 'ENABLED') {

            $subject = 'Login Detected #' . mt_rand(10000000, 99999999);

            if ($userType == 'THIRD PARTY') {

                $thirdParty = join(' ', [$validate['firstname'], $validate['lastname']]);

                $mail = thirdPartyloginAlert($validate['main-fname'], $dateTime, $thirdParty);

                $subject = 'Login Detected (Third Party) #' . mt_rand(10000000, 99999999);

            } else {

                $city = $ipData['city'];

                $region = $ipData['region'];

                $country = $ipData['country'];

                $logs = [

                    'ip-address' => $ipData['ip'],

                    'device' => ucwords($device . ', ' . $os . ' ' . $osVersion),

                    'location' => implode(', ', array_filter([$city, $region, $country], fn($part) => !is_null($part) && $part !== '')),

                    'browser' => $browser . ', ' . $browserVersion,

                ];

                $mail = loginAlert($validate['firstname'], $dateTime, $logs);

            }

            $plain = makePlain($mail);

            $recipient = $validate['main-email'];

            $recipientName = $validate['main-name'];

            $_SESSION ['MAIL'] = $mail;

            $_SESSION['SUBJECT'] = $subject;

            $_SESSION['RECIPIENT'] = $recipientName;

            $_SESSION['MAIL-DEST'] = $recipient;

            // $deliver = @deliverByPHPMailer($subject, $mail, $plain, $recipient, $recipientName);

            // if (!$deliver) {

            //     @deliverByPHPMail($recipient, $subject, $mail); // Fallback

            // }

        }

    }

?>