<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Function Definition(s)

    require('../../vendor/autoload.php'); // Composer Package(s) File 

    require('../engines/mail-delivery-engine.php'); // Mail Fxns

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Process Request

        if (!isset($_SESSION['MFA']) || !isset($_SESSION['MFA-TYPE'])) { // Check For Session

            $_SESSION = [];

            session_destroy();

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit(); // End Run

        }

        $user = filter_var($_SESSION['MFA'], FILTER_SANITIZE_EMAIL);

        $userType = (isset($_SESSION['USER-TYPE'])) ? $_SESSION['USER-TYPE'] : 'USER';
        
        if ($userType == 'USER') {

            $userData = userData($user, $conn); // Locate User

        } else {

            $userData = thirdPartyData($user, $conn); // Locate Third Party User

        }

        if (!$userData) {

            $_SESSION = [];

            session_destroy();

            echo json_encode(['userError' => true]); // Encode JSON Response

            exit(); // End Run

        }

        // Normalize User Data

        $fname = $userData['firstname'];

        $name = join(' ', [$fname, $userData['lastname']]);

        $email = $userData['email'];

        $code = generateOTP($user, $conn, $userType); // Generate OTP

        $msg = reOTP($fname, $code); // Msg

        $delivered = false; // Mail Delivery Flag

        $subject = 'Verification Code Request #' . mt_rand(10000000, 99999999);

        $deliver = @deliverByPHPMailer($subject, $msg, makePlain($msg), $email, $name);

        if (!$deliver) {

            $deliver = @deliverByPHPMail($email, $subject, $msg); // Fallback

        }

        $delivered = $deliver;

        echo json_encode(['codeDelivered' => $delivered]); // Encode JSON Response

    }

?>