<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Custom Functions File

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Custom Functions File

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    // Process Form

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = filter_var($_SESSION['USER-ID'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Sanitize Fields

        $planId = filter_var($_REQUEST['plan-id'], FILTER_SANITIZE_SPECIAL_CHARS);

        $method = filter_var($_REQUEST['via'], FILTER_SANITIZE_SPECIAL_CHARS);

        $amount = filter_var($_REQUEST['plan-price'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

        // Validate Fields

        $planData = planData($planId, $conn); // Get Plan Data

        if (!$planData) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        if ($amount <= 0) {

            echo json_encode(['amtError' => true]); // Encode JSON Response

            exit; // End Run

        } else if ($amount < $planData['min']) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $accountUSD = currencyAccountData('USD', $user, $conn); // Check For USD Account

        if (!$accountUSD) {

            echo json_encode(['accError' => true]); // Encode JSON Response

            exit; // End Run   

        }

        // For Emails

        $plan = $planData['name'] . ' (' . $planData['type'] . ')';

        $dateTime = timeGMT('l, M d Y, (H:i) [T]');

        $pay = false;  // External Payment

        $invested = false; // Flag

        if ($method == 'PAY') {

            $pay = true;

            $invested = true; // Update Flag

            $_SESSION['PAY'] = $planData['name'] . ' (INVESTMENT)';

            $_SESSION['PAY-AMOUNT'] = $amount;

            $_SESSION['PAY-DESC'] = $planId;

            $_SESSION['SUBJECT-CURR'] = 'USD'; // Primary Account Currency

            $subject = 'Investment Notification #' . mt_rand(10000000, 99999999);

            $mail = investmentNotification($userData['firstname'], $plan, $dateTime);

        } else if ($method == 'DEPOSIT') {

            // Normalize Account Data

            $accID = $accountUSD['acc-id'];

            $accNum = $accountUSD['acc-number'];

            $balance = $accountUSD['balance'];
            
            if ($amount > $balance) { // Check Balance

                echo json_encode(['balError' => true]);

                exit;

            }

            $newBal = $balance - $amount;

            // Update USD Balance, Create Transaction & Create SubScription

            $stmt = mysqli_prepare($conn, "UPDATE `accounts` SET `balance` = `balance` - ? WHERE `acc_id` = ?"); // Prepare Statement (Account Balance Update)

            mysqli_stmt_bind_param($stmt, "ds", $amount, $accID); // Bind Parameter(s)

            $stmt2 = mysqli_prepare($conn, "INSERT INTO `transactions` (`user_id`, `trans_id`, `descr`, `type`, `action`, `currency`, `acc_id`, `acc_num`, `amount`, `acc_bal`, `status`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement (Transaction Creation)

            // Parameter(s)

            $transID = generateUniqueID($conn, 'transactions', 'TRN'); // Generate ID

            $transcType = 'DEBIT';

            $transcAction = 'MISCELLANOUS';

            $transcStatus = 'COMPLETED';

            $transcDescr =  $planData['name'] . ' ' . $planData['type'] .  ' (INVESTMENT)';

            $currency = 'USD';

            mysqli_stmt_bind_param($stmt2, "sssssssidds", $user, $transID, $transcDescr, $transcType, $transcAction, $currency, $accID, $accNum, $amount, $newBal, $transcStatus); // Bind Parameter(s)

            $stmt3 = mysqli_prepare($conn, "INSERT INTO `subscriptions` (`sub_id`, `user_id`, `item`, `type`, `item_id`, `expires`) VALUES(?, ?, ?, ?, ?, ?)"); // Prepare Statement (Create Subscription)

            // Parameter(s)

            $subID = generateUniqueID($conn, 'subscriptions', 'SBR'); // Generate Id

            $subType = 'INVESTMENT';

            $item = $planData['name'];

            $duration = $planData['lifetime']; 

            $start = timeGMT('l, M d Y, (H:i) [T]'); // For Email

            $seconds = ($duration * 24 * 60 * 60); // Convert Duration To Seconds

            $ends = time() + $seconds; // Calculate Lifespan

            $expiryDate = date('Y-m-d H:i:s', $ends); // Format Date

            mysqli_stmt_bind_param($stmt3, "ssssss", $subID, $user, $item, $subType, $planId, $expiryDate); // Bind Parameter(s)

            if (mysqli_stmt_execute($stmt) && mysqli_stmt_execute($stmt2) && mysqli_stmt_execute($stmt3)) { // Execute Statement(s)

                $cycle = $planData['timing'];

                $return = $planData['return'];

                $interest = $planData['interest'];

                $unit = $planData['factor'];

                $payouts = payoutSchedule($amount, $interest, $return, $duration, $cycle, $unit); // Generate Payout Schedule

                $stmt4 = mysqli_prepare($conn, "INSERT INTO `payout_schedule` (`sub_id`, `user_id`, `amount`, `due`) VALUES(?, ?, ?, ?)");

                foreach($payouts as $payout) {

                    mysqli_stmt_bind_param($stmt4, "ssss", $subID, $user, $payout['amount'], $payout['date']);

                    mysqli_stmt_execute($stmt4);

                }

                mysqli_stmt_close($stmt4);

                $invested = true; // Update Flag

            }

            // Close Statements

            mysqli_stmt_close($stmt);
            
            mysqli_stmt_close($stmt2);

            mysqli_stmt_close($stmt3);

            // For Email

            $expiry = new DateTime("@$ends"); // Convert to DateTime Object

            $expiry->setTimezone(new DateTimeZone('GMT')); // Convert to GMT

            $expires = date_format($expiry, 'l, M d Y, (H:i) [T]'); // Format Date

            $mail = investmentNotification($userData['firstname'], $plan, $dateTime);
            
            $subject = 'Investment Notification #' . mt_rand(10000000, 99999999);

        } else {

            echo json_encode(['refresh' => true]);

            exit;

        }

        // Send Email

        $plain = makePlain($mail);

        $deliver = @deliverByPHPMailer($subject, $mail, $plain, $userData['email'], join(' ', [$userData['firstname'], $userData['lastname']]));

        if (!$deliver) {

            @deliverByPHPMail($userData['email'], $subject, $mail); // Fallback

        }

    }

    echo json_encode(['invest' => $invested, 'pay' => $pay]); // Encode JSON Response

    exit;

?>