<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Function Definition(s)

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        $user = $_SESSION['USER-ID'];

        $userData = userData($user, $conn); // Get User Data

        if (!isset($userData)) {

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Sanitize Field(s)

        $referred = filter_var($_REQUEST['invitee'], FILTER_SANITIZE_EMAIL);

        $emailInUse = emailExists($referred, $conn); // Check If Email Is In Use

        if ($emailInUse) {

            echo json_encode(['invalidGuest' => true]); // Encode JSON Response

            exit; // End Run

        }

        $referrer = join(' ', [$userData['firstname'], $userData['lastname']]);

        $refCode = generateUniqueID($cardFee, 'invites'); // Generate ID

        // Create Invite

        $created = false; // Flag

        $stmt = mysqli_prepare($conn, "INSERT INTO `invites` (`ref_code`, `referrer`) VALUES(?, ?)"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $refCode, $user); // Bind Parameters

        if (mysqli_stmt_execute($stmt)) { // Execute Statement
        
            $created = true;
            
        }

        mysqli_stmt_close($stmt); // Close Statement

        if (!$created) {

            echo json_encode(['inviteError' => true]);

            exit; // End Run

        }

        $delivered = true; // Mail Delivery Flag

        $link = SITE_BASE_URL . '/auth/join?invite=' . urlencode(encrypt($refCode)); // Invite Link;

        $subject = 'Come Aboard! Secure, Simple, and Personalized Banking Awaits';

        $mail = referralMail($referrer . '(' . $userData['email'] . ')', $link); // Mail

        $delivered = @deliverByPHPMailer($subject, $mail, makePlain($mail), $referred, $referred, $userData['email'], $referrer);

        if (!$delivered) {

            $delivered = @deliverByPHPMail($referred, $subject, $mail, $userData['email']); // Fallback

        }

        // Draft Message

        if (!$delivered) {

            // Delete Invite

            $stmt = mysqli_prepare($conn, "DELETE FROM `invites` WHERE `ref_code` = ?"); // Prepare Statement

            mysqli_stmt_bind_param($stmt, "s", $refCode); // Bind Parameters

            mysqli_stmt_execute($stmt); // Execute Statement

        }

        echo json_encode(['inviteSent' => $delivered]);

    }

?>