<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Functions File

    require('../../vendor/autoload.php'); // Composer Package(s) File

    require('../engines/mail-delivery-engine.php'); // Mail Fxns

    require('../engines/mail-drafts.php'); // Mail Drafts

    header('Content-Type: apllication/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['REG-ID'])) {

            echo json_encode(['sessionError' => true]); // Encode JSON Response

            exit; // End Run

        }

        $id = filter_var($_SESSION['REG-ID'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userData = userData($id, $conn); // Get User Data

        // Sanitize Fields

        $citizen = filter_var(trim($_REQUEST['origin']), FILTER_SANITIZE_SPECIAL_CHARS);

        $dob = sanitizeDate($_REQUEST['dob']);

        $religion = filter_var(trim($_REQUEST['religion']), FILTER_SANITIZE_SPECIAL_CHARS);

        $job = filter_var(trim($_REQUEST['occupation']), FILTER_SANITIZE_SPECIAL_CHARS);

        $earnings = filter_var($_REQUEST['income'], FILTER_SANITIZE_SPECIAL_CHARS);

        $marital = filter_var($_REQUEST['marital'], FILTER_SANITIZE_SPECIAL_CHARS);

        $street = filter_var(trim($_REQUEST['addr']), FILTER_SANITIZE_SPECIAL_CHARS);

        $state = filter_var($_REQUEST['state'], FILTER_SANITIZE_SPECIAL_CHARS);

        $city = filter_var(trim($_REQUEST['city']), FILTER_SANITIZE_SPECIAL_CHARS);

        $zip = filter_var(trim($_REQUEST['zip_code']), FILTER_SANITIZE_SPECIAL_CHARS);

        $tag = filter_var(trim($_REQUEST['username']), FILTER_SANITIZE_SPECIAL_CHARS);

        $type = filter_var($_REQUEST['acc_type'], FILTER_SANITIZE_SPECIAL_CHARS);

        $nFname = filter_var(trim($_REQUEST['nok_fname']), FILTER_SANITIZE_SPECIAL_CHARS);

        $nMname = filter_var(trim($_REQUEST['nok_mname']), FILTER_SANITIZE_SPECIAL_CHARS);

        $nLname = filter_var(trim($_REQUEST['nok_lname']), FILTER_SANITIZE_SPECIAL_CHARS);

        $nDob = sanitizeDate($_REQUEST['nok_dob']);

        $rel = filter_var(trim($_REQUEST['nok_rel']), FILTER_SANITIZE_SPECIAL_CHARS);

        $nAddr = filter_var(trim($_REQUEST['nok_addr']), FILTER_SANITIZE_SPECIAL_CHARS);

        $currency = filter_var(strtoupper($_REQUEST['currency']), FILTER_SANITIZE_SPECIAL_CHARS);

        // Fetch Bank

        $bank = null;
        
        $bankInfo = mysqli_prepare($conn, "SELECT * FROM `banks` WHERE `country` = CASE WHEN EXISTS (SELECT 1 FROM `banks` WHERE `country` = ?) THEN ? ELSE ? END ORDER BY RAND() LIMIT 1;"); // Prepare Statement

        $country = $currCountryCodes[$currency] ?? '';

        $default = 'DEFAULT';

        mysqli_stmt_bind_param($bankInfo, "sss", $country, $country, $default); // Bind Parameter(s)

        mysqli_stmt_execute($bankInfo); // Execute Statement

        $result = mysqli_stmt_get_result($bankInfo); // Get Statement Result

        if (mysqli_num_rows($result) === 1) {

            while ($row = mysqli_fetch_assoc($result)) {

                $bank = $row['bank_id'];

            }

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($bankInfo); // Close Statement

        // Update User Data

        $dataSaved = false; // Flag

        $augment = mysqli_prepare($conn, "UPDATE `users` SET `nationality` = ?, `dob` = ?, `religion` = ?, `occupation` = ?, `earnings_range` = ?, `marital_status` = ?, `street_address` = ?, `city` = ?, `state` = ?, `zip_code` = ?, `username` = ?, `nok_fname` = ?, `nok_mname` = ?, `nok_lname` = ?, `nok_dob` = ?, `nok_rel` = ?, `nok_address` = ?, `otp` = ?, `otp_validity` = ? WHERE `user_id` = ?"); // Prepare Statement

        // Additional Parameter(s)

        $code = mt_rand(100000, 999999); // Generate OTP

        // OTP Validity

        $validityPeriod = (5 * 60); // 5 Mintues to Seconds

        $validTill = time() + $validityPeriod; // Calculate Datetime

        $validTill = date('Y-m-d H:i:s', $validTill); // Format Datetime

        mysqli_stmt_bind_param($augment, "sssssssssssssssssiss", $citizen, $dob, $religion, $job, $earnings, $marital, $street, $city, $state, $zip, $tag, $nFname, $nMname, $nLname, $nDob, $rel, $nAddr, $code, $validTill, $id); // Bind Parameter(s)

        // Create Account

        $createAccount = mysqli_prepare($conn, "INSERT INTO `accounts` (`user_id`, `acc_id`, `acc_num`, `currency`, `type`, `class`, `bank_id`) VALUES(?, ?, ?, ?, ?, ?, ?)"); // Prepare Statement

        // Parameter(s)

        $accNum = mt_rand(10000000, 999999999);

        $idAcc = generateUniqueID($conn, 'accounts', $currency);

        $primary = 'PRIMARY';

        mysqli_stmt_bind_param($createAccount, "ssissss", $id, $idAcc, $accNum, $currency, $type, $primary, $bank); // Bind Parameter(s)

        if (mysqli_stmt_execute($augment) && mysqli_stmt_execute($createAccount)) { // Execute Statements

            $dataSaved = true; // Update Flag

        }

        if ($dataSaved) {

            // unset($_SESSION['REG-ID']); // Unset Session

            // Send OTP

            $mail = registrationOTP($userData['firstname'], $code); // Message

            $plain = makePlain($mail);

            $recipientName = join(' ', [$userData['firstname'], $userData['lastname']]);

            $deliver = @deliverByPHPMailer('Verify Your Identity', $mail, $plain, $userData['email'], $recipientName);

            if (!$deliver) {

                @deliverByPHPMail($userData['email'], 'Verify Your Identity', $mail);

            }

        }

        echo json_encode(['regAugmented' => $dataSaved]); // Encode JSON Response

        exit; // Terminate

    }

?>