<?php

    // Credentials

    require('../config/config.php'); // Configuration File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        // Sanitize Data [Pre-validated Phone Number]

        $tel = filter_var($_POST['phone'], FILTER_SANITIZE_SPECIAL_CHARS);

        $inUse = false; // Flag

        // Search For Email

        $locateLine = mysqli_prepare($conn, "SELECT * FROM `users` WHERE `telephone` = CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($locateLine, "s", $tel); // Bind Parameter(s)

        mysqli_stmt_execute($locateLine); // Execute Statement

        $result = mysqli_stmt_get_result($locateLine); // Get Statement Result

        if (mysqli_num_rows($result) === 1) { // Get Result Mass

            $inUse = true; // Update Flag

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($locateLine); // Close Statement

        // Send Response

        echo json_encode(['lineTaken' => $inUse]); // Encode JSON Response

        exit(); // End Run

    }

?>