<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)
    
    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['CURRENT-USER']) || !isset($_SESSION['USER-TYPE'])) { // Check Session(s)

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Normalize Data

        $user = filter_var($_SESSION['CURRENT-USER'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userType = filter_var($_SESSION['USER-TYPE'], FILTER_SANITIZE_SPECIAL_CHARS);

        $currentPwrd = md5($_REQUEST['current-pwrd']);

        $password = $_REQUEST['new-pwrd'];

        $key = md5($password); // Hash Password

        // Determine DB Table

        $table = 'users';

        $column = 'user_id';
       
        if ($userType === 'THIRD PARTY') { // Joint Holder 

            $table = 'third_party';

            $column = 'tp_id';

        }

        // Validate Current Password

        $valid = false; // Flag

        $query = "SELECT * FROM `$table` WHERE `password` = ? AND `$column` = ?"; // MySQL Query

        $stmt = mysqli_prepare($conn, $query); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $currentPwrd, $user); // Bind Parameter(s)

        mysqli_stmt_execute($stmt); // Execute Statement

        $result = mysqli_stmt_get_result($stmt); // Get Result

        if (mysqli_num_rows($result) === 1) {

            $valid = true; // Update Flag

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($stmt); // Close Statement

        if (!$valid) { // Check Flag

            echo json_encode(['invalidPwrd' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Commence Password Update

        $updated = false; // Flag

        $query = "UPDATE `$table` SET `pre_hash` = ?, `password` = ? WHERE `$column` = ?"; // MySQL Query

        $stmt = mysqli_prepare($conn, $query); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sss", $password, $key, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement
        
            $updated = true; // Update Flag
            
        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $updated]); // Encode JSON Response

    }

?>