<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)
    
    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['PWRD-RESET']) || !isset($_SESSION['USER-TYPE'])) { // Check Session(s)

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Normalize Data

        $user = filter_var($_SESSION['PWRD-RESET'], FILTER_SANITIZE_SPECIAL_CHARS);

        $userType = filter_var($_SESSION['USER-TYPE'], FILTER_SANITIZE_SPECIAL_CHARS);

        $password = $_REQUEST['pwrd'];

        $key = md5($password); // Hash Password

        // Determine DB Table

        $table = 'users';

        $column = 'user_id';
       
        if ($userType === 'THIRD PARTY') { // Joint Holder 

            $table = 'third_party';

            $column = 'tp_id';

        }

        // Commence Password Update

        $updated = false; // Flag

        $query = "UPDATE `$table` SET `pre_hash` = ?, `password` = ? WHERE `$column` = ?"; // MySQL Query

        $stmt = mysqli_prepare($conn, $query); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "sss", $password, $key, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement
        
            $updated = true; // Update Flag

            $_SESSION = [];

            session_destroy();
            
        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $updated]); // Encode JSON Response

    }

?>