<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Sessions

    require('../config/config.php'); // Configuration File

    require('../engines/fxns.php'); // Functions File

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        $tag = filter_var($_REQUEST['tag'], FILTER_SANITIZE_SPECIAL_CHARS);

        $located = false; // Flag

        $results = []; // Initialize $results

        if (!isset($_SESSION['USER-ID'])) {

            echo json_encode(['refresh' => true]);

            exit;

        }

        $user = $_SESSION['USER-ID'];

        // Locate User

        $locate = mysqli_prepare($conn, "SELECT `A`.*, `B`.`acc_id`, `B`.`currency` FROM `users` AS `A` LEFT JOIN `accounts` AS `B` ON CAST(`A`.`user_id` AS BINARY) = CAST(`B`.`user_id` AS BINARY) WHERE (`A`.`username` = CAST(? AS BINARY) OR `A`.`email` = CAST(? AS BINARY)) AND `A`.`user_id` != CAST(? AS BINARY)"); // Prepare Statement

        mysqli_stmt_bind_param($locate, "sss", $tag, $tag, $user); // Bind Parameter(s)

        mysqli_stmt_execute($locate); // Execute Statement

        $result = mysqli_stmt_get_result($locate); // Get Statement Result

        if (mysqli_num_rows($result) > 0) { // Get Mass

            $located = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result Data

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($locate); // Close Statement  

        if ($located) {

            foreach ($data as $row):

                $name = join(' ', [$row['fname'], $row['mname'], $row['lname']]);

                // <div class="pRi_row">
                
                //     <input type="radio" name="user" value="' . $row['user_id'] . '" required>

                //     <p>' . $name . '</p>
                
                // </div>

                // $subResult = '<div class="formRadio_item pseudoRadio">

                //     <img src="https://flagcdn.com/'. strtolower($currCountryCodes[$row['currency']]) . '.svg" alt>

                //     <label for="asset" translate="no">' . $row['currency'] . '</label>

                //     <input type="radio" name="asset" value="' . $row['acc_id'] . '">

                // </div>';

                // Ensure all fields are available
                $name = htmlspecialchars(join(' ', [$row['fname'], $row['mname'], $row['lname']]));
                $currency = isset($currCountryCodes[$row['currency']]) ? strtolower($currCountryCodes[$row['currency']]) : 'default';

                // Build the sub-result block
                $subResult[] = '<div class="formRadio_item pseudoRadio">
                    <img src="https://flagcdn.com/' . $currency . '.svg" alt>
                    <label for="account" translate="no">' . htmlspecialchars($row['currency']) . '</label>
                    <input type="radio" name="account" value="' . htmlspecialchars($row['acc_id']) . '">
                </div>';

            endforeach;  

            // Append the results
            $results[] = '<div class="pRi_row">
                <div>
                
                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8.10573 7.24666C8.03906 7.24 7.95906 7.24 7.88573 7.24666C6.29906 7.19333 5.03906 5.89333 5.03906 4.29333C5.03906 2.65999 6.35906 1.33333 7.99906 1.33333C9.6324 1.33333 10.9591 2.65999 10.9591 4.29333C10.9524 5.89333 9.6924 7.19333 8.10573 7.24666Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M4.7725 9.70667C3.15917 10.7867 3.15917 12.5467 4.7725 13.62C6.60583 14.8467 9.6125 14.8467 11.4458 13.62C13.0592 12.54 13.0592 10.78 11.4458 9.70667C9.61917 8.48667 6.6125 8.48667 4.7725 9.70667Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>
                <p>' . $name . '</p>
            </div>
            <div class="form_item">
                <label for="account">Currency</label>
                    <div class="form_radio">' . implode('', $subResult) . '</div>
                    
            </div>';

            // $results[] = '<div class="pRi_row">
                
            //     <p>' . $name . '</p>
                
            // </div>
            
            // <div class="form_radio">' . $subResult . '</div>';

            echo json_encode(['located' => true, 'results' => implode('', $results)]);

        } else {

            echo json_encode(['located' => false]);

        }    

    }

?>