<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Session(s)

    require('../config/config.php'); // Configuration Setup

    require('../engines/fxns.php'); // Function Definition(s)

    header('Content-Type: application/json'); // Communication Protocol

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {

        if (!isset($_SESSION['USER-ID'])) { // Check Session(s)

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Normalize Data

        $user = filter_var($_SESSION['USER-ID'], FILTER_SANITIZE_SPECIAL_CHARS);

        $answer = filter_var(trim($_REQUEST['answer-1']), FILTER_SANITIZE_SPECIAL_CHARS);

        $answerB = filter_var(trim($_REQUEST['answer-2']), FILTER_SANITIZE_SPECIAL_CHARS);

        $tPIN = join('', $_REQUEST['new-tpin']);

        $tPIN = filter_var($tPIN, FILTER_SANITIZE_NUMBER_INT);

        $userData = userData($user, $conn); // Get User Data

        if (!$userData) { // User Not Found

            echo json_encode(['refresh' => true]); // Encode JSON Response

            exit; // End Run

        }

        // Validate Answers

        if ($answer != $userData['answer-1'] || $answerB != $userData['answer-2']) {

            echo json_encode(['ansError' => true]);

            exit; // End Run

        }

        // Commence Update

        $updated = false; // Flag

        $stmt = mysqli_prepare($conn, "UPDATE `users` SET `trans_pin` = ? WHERE `user_id` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($stmt, "ss", $tPIN, $user); // Bind Parameter(s)

        if (mysqli_stmt_execute($stmt)) { // Execute Statement
        
            $updated = true; // Update Flag
            
        }

        mysqli_stmt_close($stmt); // Close Statement

        echo json_encode(['updated' => $updated]); // Encode JSON Response

    }

?>