<?php

    require('../partials/header.php');

    $extraScripts = <<<HTML
    
        <!-- Replace with TradingView's Lightweight Charts / HighCharts  -->

        <!-- Chart.js -->

        <!-- <script src="../resources/chart.js/Chart.min.js"></script> -->

    HTML;

?>

<section id="balance">

    <div class="dash_banner">

        <div class="dashBanner_header hnx">
            
            <div class="dhb_Bitem">
                
                <h4 class="dashBanner_title">Account Balances <span class="text-min">(<?= accountCount($user_id, $conn) ?>)</span></h4>

                <a class="radial_link" id="iQ_veil">

                    <svg class="default" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7.99995 5.61333C8.27386 5.61333 8.54135 5.65977 8.79276 5.74824C8.54091 5.65941 8.27363 5.61333 7.99995 5.61333ZM7.99995 5.61333C6.68381 5.61333 5.61328 6.68385 5.61328 7.99999M7.99995 5.61333C6.68276 5.61333 5.61328 6.6828 5.61328 7.99999M5.61328 7.99999C5.61328 8.2739 5.65972 8.5414 5.74819 8.7928C5.65936 8.54096 5.61328 8.27368 5.61328 7.99999Z" fill="#2467E3" stroke="#2467E3"></path><path d="M3.73323 12.34C3.6199 12.34 3.4999 12.3 3.40656 12.22C2.69323 11.6133 2.05323 10.8667 1.50656 10C0.799896 8.9 0.799896 7.10666 1.50656 6C3.13323 3.45333 5.4999 1.98666 7.9999 1.98666C9.46656 1.98666 10.9132 2.49333 12.1799 3.44666C12.3999 3.61333 12.4466 3.92666 12.2799 4.14666C12.1132 4.36666 11.7999 4.41333 11.5799 4.24666C10.4866 3.42 9.24656 2.98666 7.9999 2.98666C5.84656 2.98666 3.78656 4.28 2.34656 6.54C1.84656 7.32 1.84656 8.68 2.34656 9.46C2.84656 10.24 3.4199 10.9133 4.05323 11.46C4.2599 11.64 4.28656 11.9533 4.10656 12.1667C4.01323 12.28 3.87323 12.34 3.73323 12.34Z" fill="#2467E3"></path><path d="M7.99972 14.0133C7.11305 14.0133 6.24638 13.8333 5.41305 13.48C5.15972 13.3733 5.03972 13.08 5.14638 12.8267C5.25305 12.5733 5.54638 12.4533 5.79972 12.56C6.50638 12.86 7.24638 13.0133 7.99305 13.0133C10.1464 13.0133 12.2064 11.72 13.6464 9.46C14.1464 8.68 14.1464 7.32 13.6464 6.54C13.4397 6.21334 13.213 5.9 12.973 5.60667C12.7997 5.39334 12.833 5.08 13.0464 4.9C13.2597 4.72667 13.573 4.75334 13.753 4.97334C14.013 5.29334 14.2664 5.64 14.493 6C15.1997 7.1 15.1997 8.89334 14.493 10C12.8664 12.5467 10.4997 14.0133 7.99972 14.0133Z" fill="#2467E3"></path><path d="M8.45973 10.8467C8.22639 10.8467 8.01306 10.68 7.96639 10.44C7.91306 10.1667 8.09306 9.90667 8.36639 9.86C9.09973 9.72667 9.71306 9.11333 9.84639 8.38C9.89973 8.10667 10.1597 7.93333 10.4331 7.98C10.7064 8.03333 10.8864 8.29333 10.8331 8.56667C10.6197 9.72 9.69973 10.6333 8.55306 10.8467C8.51973 10.84 8.49306 10.8467 8.45973 10.8467Z" fill="#2467E3"></path><path d="M1.33427 15.1667C1.2076 15.1667 1.08094 15.12 0.980938 15.02C0.787604 14.8267 0.787604 14.5067 0.980938 14.3133L5.96094 9.33334C6.15427 9.14001 6.47427 9.14001 6.6676 9.33334C6.86094 9.52667 6.86094 9.84667 6.6676 10.04L1.6876 15.02C1.5876 15.12 1.46094 15.1667 1.33427 15.1667Z" fill="#2467E3"></path><path d="M9.68583 6.81334C9.55917 6.81334 9.4325 6.76667 9.3325 6.66667C9.13917 6.47334 9.13917 6.15334 9.3325 5.96001L14.3125 0.980007C14.5058 0.786673 14.8258 0.786673 15.0192 0.980007C15.2125 1.17334 15.2125 1.49334 15.0192 1.68667L10.0392 6.66667C9.93917 6.76667 9.8125 6.81334 9.68583 6.81334Z" fill="#2467E3"></path></svg>

                    <svg class="toggle" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7.99995 10.3867C6.68276 10.3867 5.61328 9.31718 5.61328 7.99999M7.99995 10.3867C9.31714 10.3867 10.3866 9.31718 10.3866 7.99999M7.99995 10.3867C9.31609 10.3867 10.3866 9.31614 10.3866 7.99999M7.99995 10.3867C6.68381 10.3867 5.61328 9.31614 5.61328 7.99999M5.61328 7.99999C5.61328 6.6828 6.68276 5.61333 7.99995 5.61333M5.61328 7.99999C5.61328 6.68385 6.68381 5.61333 7.99995 5.61333M10.3866 7.99999C10.3866 6.6828 9.31714 5.61333 7.99995 5.61333M10.3866 7.99999C10.3866 6.68385 9.31609 5.61333 7.99995 5.61333" fill="#2467E3" stroke="#2467E3"></path><path d="M8.0007 14.0133C5.49404 14.0133 3.12737 12.5467 1.5007 10C0.794036 8.9 0.794036 7.10666 1.5007 6C3.13404 3.45333 5.5007 1.98666 8.0007 1.98666C10.5007 1.98666 12.8674 3.45333 14.494 6C15.2007 7.1 15.2007 8.89333 14.494 10C12.8674 12.5467 10.5007 14.0133 8.0007 14.0133ZM8.0007 2.98666C5.84737 2.98666 3.78737 4.28 2.34737 6.54C1.84737 7.32 1.84737 8.68 2.34737 9.46C3.78737 11.72 5.84737 13.0133 8.0007 13.0133C10.154 13.0133 12.214 11.72 13.654 9.46C14.154 8.68 14.154 7.32 13.654 6.54C12.214 4.28 10.154 2.98666 8.0007 2.98666Z" fill="#2467E3"></path></svg>

                </a>

            </div>

            <div class="dhb_Bitem btn_con">

                <button class="pg_btn variantMichb<?= ($userType == 'THIRD PARTY') ? ' inaccessible' : null ?>"<?= ($userType == 'THIRD PARTY') ? null : ' iQ-target="#newAcc"' ?>>

                    <span>Add An Account</span>

                    <div class="pgBtn_icon">

                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2 8H14" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M8 14V2" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                    </div>

                </button>

            </div>
            
        </div>

        <div class="dashBanner_con">

            <div class="dashBanner_item ex<?= $userAccounts && ($userAccounts) > 0 ? ' iQ_panels' : null ?>">
                
                <div class="acc_tab noScrollBar" style="flex-wrap: wrap; gap: 0.7em;">

                    <?php 

                        if ($userAccounts) {

                            // Iterate Through User Accont(s)

                            foreach ($userAccounts as $account):

                                $currency = $account['currency'];

                                $flag = 'https://flagcdn.com/' . strtolower($currCountryCodes[$currency]) . '.svg';

                            ?>  
                            
                            <a class="acc_switch iQ_panelSwitch">

                                <img class="dshBi_icon flag_icon" src="<?= $flag ?>" alt="">

                                <span><?= $currency ?></span>

                            </a>

                            <?php endforeach;

                        } else { ?>

                            <a class="acc_switch">

                                <span>No Account</span>

                            </a>

                        <?php }    

                    ?>
                    
                </div>

                <div class="acct">

                    <?php

                        if ($userAccounts) {
                    
                            // Iterate Through User Accouts

                            foreach ($userAccounts as $account):

                                $balance = $account['balance'];

                                $currency  = $account['currency'];

                                $symbol = $currSymbol[$currency];

                                $pending = $account['pending_balance'];

                            ?>

                            <div class="acct_details n_displ iQ_panel">

                                <div class="bal_box bdr" id="available">

                                    <div class="txbox">

                                        <p class="b title">Available <?= $currency ?> Balance</p>

                                        <p class="acct_desc">

                                            <span class="txSmall"><?= $symbol; ?></span>

                                            <span><span class="txLarge"><?= number_format($balance, 2); ?></span></span>

                                        </p>

                                    </div>  

                                </div>

                                <div class="bal_box" id="pending">

                                    <div class="txbox">

                                        <p class="b title">Pending <?= $currency; ?> Balance</p>

                                        <p class="acct_desc">

                                            <span class="txSmall"><?= $symbol ?></span>

                                            <span><span class="txLarge"><?= number_format($pending, 2); ?></span></span>

                                        </p>

                                    </div>  

                                </div>

                            </div>

                            <?php endforeach;
                            
                        } else { ?>

                            <div class="acct_details">

                                <div class="bal_box bdr" id="available">

                                    <div class="txbox">

                                        <p class="b title">No Account</p>

                                    </div>  

                                </div>

                                <div class="bal_box" id="pending">

                                    <div class="txbox">

                                        <p class="b title">Add an account</p>

                                    </div>  

                                </div>

                            </div>

                        <?php }
                    
                    ?>

                    <?php

                        if ($userAccounts) { ?>

                            <div class="acct_actions">

                                <button class="pg_btn" iQ-target="#addFunds">

                                    <span>Add Money</span>

                                    <div class="pgBtn_icon">

                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2 8H14" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M8 14V2" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                    </div>

                                </button>

                                <?php

                                    if (accountCount($user_id, $conn) > 1 && $userType != 'THIRD PARTY') { ?>

                                        <button class="pg_btn" iQ-target="#convFunds">

                                            <span>Convert Funds</span>

                                            <div class="pgBtn_icon">

                                                <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12.02 6.96635L14.5 4.48633L12.02 2.00635" stroke="#2D3443" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.5 4.48633L14.5 4.48633" stroke="#2D3443" stroke-linecap="round" stroke-linejoin="round"></path><path d="M4.97998 9.0332L2.5 11.5132L4.97998 13.9932" stroke="#2D3443" stroke-linecap="round" stroke-linejoin="round"></path><path d="M14.5 11.5127L2.5 11.5127" stroke="#2D3443" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                            </div>

                                        </button>

                                    <?php }
                                    
                                ?>

                                <button class="pg_btn"<?= ($currentUserStatus != 'TRANSFER DISABLED' && $currentUserStatus != 'INACTIVE') ? ' iQ-target="#sendFunds"' : 'onclick="return(toast({text: \'Transfers ' . ltrim($currentUserStatus, 'TRANSFER ') . '\', type: \'warning\', duration: 2000}))"' ?>>

                                    <span>Send Money</span>

                                    <div class="pgBtn_icon">

                                        <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M13.5002 3L4.16684 12.3333" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M6.6535 3L13.5002 3V9.84667" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                                    </div>

                                </button>

                            </div>

                        <?php }
                        
                    ?>

                </div>

            </div>

        </div>

    </div>

</section>

<section id="expense-insight">

    <div class="dash_banner">

        <div class="dashBanner_header hnx">
            
            <div class="dhb_Bitem">
                
                <h4 class="dashBanner_title">Expense Insight</h4>

                <img class="dshBi_icon" src="../assets/media/icons/insight.svg" alt="">

            </div>
            
        </div>

        <!-- <div class="dashBanner_con"></div> -->

        <div class="overview-con">

        <div class="overview-box stats" id="stats">

            <div class="overview-box-item">

                <select class="swatch-field" id="accountSelector">

                    <?php
                    
                        foreach ($userAccounts as $row): ?>

                            <option value="<?= $row['acc_id'] ?>"><?= $row['currency'] . ' ' . substr($row['acc_num'], 0, 3) . str_repeat('*', strlen(substr($row['acc_num'], 4))) ?></option>

                        <?php endforeach;

                    ?>

                </select>

            </div>

            <div class="overview-box-item">

                <div class="acc-info">

                    <img class="flag-icon" src="../assets/media/images/eur.svg" alt="">

                    <div class="text-box">

                        <p class="text-min">United States Dollar</p>

                        <p class="balance">$23,074.22 (USD)</p>

                    </div>

                </div>

                <div class="summary-con">

                    <div class="summary-box">

                        <div class="text-box">

                            <p><span class="text-min">70%</span></p>

                            <p>$20,000.778</p>

                        </div>

                    </div>

                    <div class="summary-box">

                        <div class="text-box">

                            <p><span class="text-min">70%</span></p>

                            <p>$20,000.778</p>

                        </div>

                    </div>

                </div>

            </div>

            <div class="overview-box-item">

                <div class="swatch-btns" id="range">

                    <button class="swatch-btn" type="button" value="1M">1M</button>

                    <button class="swatch-btn" type="button" value="3M">3M</button>

                    <button class="swatch-btn" type="button" value="6M">6M</button>

                    <button class="swatch-btn" type="button" value="1Y">1Y</button>

                    <button class="swatch-btn active" type="button" value="ALL">ALL</button>

                </div>

            </div>    

        </div>

        <div class="overview-box graph" id="graph" style="background-color: transparent;">

            <canvas id="overview-graph"></canvas>

        </div>

    </div>

    </div>

</section>

<!-- <section id="overview">

    <div class="overview-con">

        <div class="overview-box stats" id="stats">

            <div class="overview-box-item">

                <select class="swatch-field" id="accountSelector">

                    <?php
                    
                        foreach ($userAccounts as $row): ?>

                            <option value="<?= $row['acc_id'] ?>"><?= $row['currency'] . ' ' . substr($row['acc_num'], 0, 3) . str_repeat('*', strlen(substr($row['acc_num'], 4))) ?></option>

                        <?php endforeach;

                    ?>

                </select>

            </div>

            <div class="overview-box-item">

                <div class="acc-info">

                    <img class="flag-icon" src="../assets/media/images/eur.svg" alt="">

                    <div class="text-box">

                        <p class="text-min">United States Dollar</p>

                        <p class="balance">$23,074.22 (USD)</p>

                    </div>

                </div>

                <div class="summary-con">

                    <div class="summary-box">

                        <div class="text-box">

                            <p><span class="text-min">70%</span></p>

                            <p>$20,000.778</p>

                        </div>

                    </div>

                    <div class="summary-box">

                        <div class="text-box">

                            <p><span class="text-min">70%</span></p>

                            <p>$20,000.778</p>

                        </div>

                    </div>

                </div>

            </div>

            <div class="overview-box-item">

                <div class="swatch-btns" id="range">

                    <button class="swatch-btn" type="button" value="1M">1M</button>

                    <button class="swatch-btn" type="button" value="3M">3M</button>

                    <button class="swatch-btn" type="button" value="6M">6M</button>

                    <button class="swatch-btn" type="button" value="1Y">1Y</button>

                    <button class="swatch-btn active" type="button" value="ALL">ALL</button>

                </div>

            </div>    

        </div>

        <div class="overview-box graph" id="graph" style="background-color: transparent;">

            <canvas id="overview-graph"></canvas>

        </div>

    </div>

</section> -->

<!-- <section id="r_transac">

    <div class="dash_banner">

        <div class="dashBanner_header">

            <h4 class="dashBanner_title">Recent Transactions</h4>

            <div class="dhb_Bitem">

                <a href="transactions" class="form_link">See all</a>

            </div>

        </div>

        <div class="table_con">

            <table>

                <thead>

                    <tr>

                        <th>Date</th>

                        <th>Amount</th>

                        <th class="mobile-0">Type</th>

                        <th class="mobile-0">Description</th>

                        <th class="mobile-0">Status</th>

                        <th>Actions</th>

                    </tr>

                </thead>

                <tbody>

                    <?php
                    
                        // Get Most Recent Transactions

                        $foundTransc = false; // Flag

                        $transactions = mysqli_prepare($conn, "SELECT * FROM `transactions` WHERE `user_id` = ? ORDER BY `date` DESC LIMIT 5"); // Prepare Statement

                        mysqli_stmt_bind_param($transactions, "s", $user_id); // Bind Parameter(s) 

                        mysqli_stmt_execute($transactions); // Execute Statement

                        $result = mysqli_stmt_get_result($transactions); // Get Result

                        if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                            $foundTransc = true; // Update Flag

                            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result Data

                        }

                        mysqli_free_result($result); // Free Result

                        mysqli_stmt_close($transactions); // Close Statement

                        // Check Flag

                        if ($foundTransc) {

                            // Iterate Through Data 

                            foreach ($data as $row) :

                                $currency = $row['currency'];

                                $symbol = $currSymbol[$currency];

                                $date = date('l M d, Y', strtotime($row['date']));

                                $type = $row['type'];

                                $desc = $row['descr'] == null ? '-' : $row['descr'];

                                $amount = '<span translate="no">' . '</span>' . $symbol . number_format($row['amount'], 2);

                                $status = $row['status'];

                                $id = $row['trans_id'];

                                if ($type == 'CREDIT') {

                                    $type = '<span class="i-element green">'. $type .'</span>';

                                } else {

                                    $type = '<span class="i-element red">'. $type .'</span>';

                                }

                                if ($status === 'COMPLETED') {

                                    $icon = '<svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z" fill="currentColor"></path></g></svg>';

                                    $class = ' verified';

                                } else if ($status === 'INCOMPLETE' || $status === 'DISPUTED') {

                                    $icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-alert mr-2 h-4 w-4"><circle cx="12" cy="12" r="10"></circle><line x1="12" x2="12" y1="8" y2="12"></line><line x1="12" x2="12.01" y1="16" y2="16"></line></svg>';

                                    $class = ' error';

                                } else {

                                    $icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-timer mr-2 h-4 w-4 text-muted-foreground"><line x1="10" x2="14" y1="2" y2="2"></line><line x1="12" x2="15" y1="14" y2="11"></line><circle cx="12" cy="14" r="8"></circle></svg>';

                                    $class = ' orange';

                                }

                                $status = '<div class="verif v2 sm'. $class .'">

                                    <div class="icon">' . $icon . '</div>       
                                    
                                    <span>' . ucwords($status) . '</span>
                            
                                </div>';

                            ?>
                            
                            <tr>

                                <td><?= $date ?></td>

                                <td><?= $amount . '<sup class="label" translate="no">' . $currency . '</sup>' ?></td>

                                <td class="mobile-0"><?= $type ?></td>

                                <td class="mobile-0"><?= $desc ?></td>

                                <td class="mobile-0"><?= $status ?></td>

                                <td>

                                    <div class="flx">

                                        <div class="iQ_rqustCon">

                                            <input type="hidden" value="<?= $id ?>">

                                            <span class="badge pill iQ_rqust" iQ-target="#iQ_transDetails">Details</span>

                                        </div>

                                        <div class="iQ_rqustCon2">

                                            <input type="hidden" value="<?= $id ?>">

                                            <span class="badge pill plain iQ_rqust" iQ-target="#iQ_transReceipt">Receipt</span>

                                        </div>

                                    </div>    

                                </td>

                            </tr>

                            <?php endforeach;

                        } else {

                            emptyTable('Ready to make your first transaction?');

                        }

                    ?>

                </tbody>

            </table>

        </div>

    </div>

</section> -->

<!-- MODAL: Add New Account -->

<div class="popup_window variantB n_displ">

    <div class="popup_con n_displ" id="newAcc">

        <div class="popup_box noScrollBar">

            <div class="popupBox_header">

                <p>Add New Account</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="var(--pg-svg)" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="var(--pg-svg)" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <p style="color: var(--pg-greyB); font-size: 0.9rem;">Select your choice of currency to add</p>

                <form method="post" id="accForm">

                    <div class="form_item">

                        <label for="acc-type">Account Type</label>

                        <select name="acc-type" class="form_field">
                                        
                            <option value="0">Select an Account Type</option> 
                            <option value="CHECKING">Checking Account</option>
                            <option value="SAVINGS">Saving Account</option>
                            <option value="FIXED DEPOSIT">Fixed Deposit Account</option>
                            <option value="CURRENT">Current Account</option>
                            <option value="JOINT">Joint Account</option>
                            <!-- <option value="BUSINESS">Business Account</option> -->
                            <option value="NON RESIDENT">Non Resident Account</option>
                            <!-- <option value="CORPERATE BUSINESS">Corperate Business Account</option> -->
                            <!-- <option value="INVESTMENT">Investment Account</option> -->
                                    
                        </select>

                    </div>

                    <div class="acc-options">

                        <?php

                            $currencies = []; // Store User Currencies

                            $requests = []; // Store Currenncy Requests

                            $stmt = mysqli_prepare($conn, "SELECT `A`.`currency` AS `currencies`, `B`.`identifier` AS `requests` FROM `accounts` AS `A` LEFT JOIN `requests` AS `B` ON `A`.`user_id` = `B`.`user_id` AND `B`.`type` = ? WHERE `A`.`user_id` = ? ORDER BY `A`.`currency`, `B`.`identifier` DESC");

                            $type = 'ACCOUNT';

                            mysqli_stmt_bind_param($stmt, "ss", $type, $user_id); // Bind Parameter(s)

                            mysqli_stmt_execute($stmt); // Execute Statement

                            $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                            if (mysqli_num_rows($result) > 0) {

                                while ($row = mysqli_fetch_assoc($result)) {

                                    $currencies[] = $row['currencies'];

                                    $requests[] = $row['requests'];

                                }

                            }

                            mysqli_free_result($result); // Free Result

                            mysqli_stmt_close($stmt); // Close Statement

                            // Merge currencies and requests arrays to exclude both from $currCodeNames
                            $excludeCurrencies = array_merge($currencies, $requests);

                            // Filter out NULL or invalid values (non-scalar values) from $excludeCurrencies
                            $excludeCurrencies = array_filter($excludeCurrencies, function($value) {
                                return is_scalar($value); // Keep only scalar values (strings or integers)
                            });

                            // Filter out the user's currencies and requests from the $currCodeNames array
                            $filter = array_diff_key($currCodeNames, array_flip($excludeCurrencies));
                        
                            foreach ($filter as $code => $name): // Get Remaining Currencies ?>

                                <div class="acc-option">

                                    <input type="radio" name="currency" value="<?= $code ?>">

                                    <div class="acc-curr">

                                        <img class="flag" src="https://flagcdn.com/<?= strtolower($currCountryCodes[$code]) ?>.svg" alt="">

                                        <p><?= $name ?><span translate="no"><?= ' (' . $code . ')' ?></span></p>

                                    </div>

                                </div>

                            <?php endforeach;

                        ?>

                    </div>    

                    <div class="form_item formBtn_con">

                        <button class="form_btn" type="submit" name="addAcct" id="addAcct">Proceed</button>
                        
                    </div>

                </form>    

            </div>

        </div>

    </div>

</div>

<?php

    require('../partials/footer.php');

?>            