<?php

    require('../partials/service-header.php');

    if (isset($_SESSION['TRANSF-ID'])) {

        echo '<script>
        
            window.location.href = "transaction-success";
        
        </script>';

        exit;

    }

    // Check User's KYC

    if ($userType === 'USER') {

        $kycState = $userData['kyc-status'] ?? 'UNVERIFIED';

        if ($kycState == 'UNVERIFIED' || $kycState == 'REJECTED') {

            echo '<script>
            
                popup({
                
                    header: "KYC Required!",

                    title: "Transfer Disabled!",

                    text: "Transfers are disabled at the moment, in order to enable transfers you\'ll have to complete the KYC verification. Would you like to proceed to KYC verification?",

                    showConfirmBtn: true,

                    type: "warning"

                }).then((confirmed) => {
                
                    if (confirmed) {

                        window.location.href = "kyc"
                    
                    } else {
                    
                        window.history.back(-1);
                        
                    }
                
                });
            
            </script>';

        } else if ($kycState == 'PROCESSING') {

            echo '<script>
            
                popup({
                
                    header: "KYC Required!",

                    title: "Transfer Disabled!",

                    text: "Transfers are disabled at the moment, as your KYC is still under verification",

                    type: "info"

                }).then(() => {
                
                    window.history.back(-1);
                        
                });
            
            </script>';

        }

    }

    if (isset($_REQUEST['type'])) {

        $type = filter_var($_REQUEST['type'], FILTER_SANITIZE_SPECIAL_CHARS);

        $param = 'CROSS-BORDER TRANSFER';

        if ($type == 'local') {

            $param = 'LOCAL TRANSFER';

        }

        // Get Beneficiaries

        $hasBeneficiary = false; // Flag

        $beneficiaries = mysqli_prepare($conn, "SELECT * FROM `beneficiaries` WHERE `user_id` = ? AND `type` = ?"); // Prepare Statement

        mysqli_stmt_bind_param($beneficiaries, "ss", $currentUser, $param); // Bind Parameter(s)

        mysqli_stmt_execute($beneficiaries); // Execute Statement

        $result = mysqli_stmt_get_result($beneficiaries); // Get Statement Result

        if (mysqli_num_rows($result) > 0) { // Get Result's Mass

            $hasBeneficiary = true; // Update Flag

            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result's Data

        }

        mysqli_free_result($result); // Free Result

        mysqli_stmt_close($beneficiaries); // Close Result

    }
    
?>

<div class="viewBox max">

    <div class="vbox_item">

        <div class="flx col">

            <p class="special_title">Send to a new recipient</p>

            <p style="font-size: 0.8rem;">Select a beneficiary or send to a new recipient</p>

        </div>    

    </div>

    <div class="vbox_item">

        <div class="jzzvtBox">

            <div class="boxItem">

                <?php
                
                    // Check Flag

                    if ($hasBeneficiary) { ?>


                        <div class="form_item">

                            <label for="transDest">Saved Beneficiaries</label>

                            <select class="form_field iQ_focus search" id="transDest">

                                <option value="0">Select beneficiary</option>

                                <?php
                                
                                    // Iterate Through Data

                                    foreach ($data as $row): ?>

                                        <option value="<?= $row['id'] ?>"><?= $row['name'] . ' ('. substr($row['account'], 0, 4) .'***)' ?></option>                              

                                    <?php endforeach;    
                                
                                ?>

                            </select>

                        </div>
                        
                        <div class="form_item">

                            <button class="form_btn" id="transNav">Continue</button>

                        </div>

                        <?php

                    } else {

                        echo '<div class="flx col">

                            <div class="jzzvtIcon">

                                <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M15.0002 3.3335C10.6335 3.3335 7.0835 6.8835 7.0835 11.2502C7.0835 15.5335 10.4335 19.0002 14.8002 19.1502C14.9335 19.1335 15.0668 19.1335 15.1668 19.1502C15.2002 19.1502 15.2168 19.1502 15.2502 19.1502C15.2668 19.1502 15.2668 19.1502 15.2835 19.1502C19.5502 19.0002 22.9002 15.5335 22.9168 11.2502C22.9168 6.8835 19.3668 3.3335 15.0002 3.3335Z" fill="currentColor"></path><path d="M23.4666 23.5833C18.8166 20.4833 11.2333 20.4833 6.54994 23.5833C4.43327 25 3.2666 26.9166 3.2666 28.9666C3.2666 31.0166 4.43327 32.9166 6.53327 34.3166C8.8666 35.8833 11.9333 36.6666 14.9999 36.6666C18.0666 36.6666 21.1333 35.8833 23.4666 34.3166C25.5666 32.9 26.7333 31 26.7333 28.9333C26.7166 26.8833 25.5666 24.9833 23.4666 23.5833Z" fill="currentColor"></path><path d="M33.3166 12.2332C33.5833 15.4665 31.2833 18.2998 28.0999 18.6832C28.0833 18.6832 28.0833 18.6832 28.0666 18.6832H28.0166C27.9166 18.6832 27.8166 18.6832 27.7333 18.7165C26.1166 18.7998 24.6333 18.2832 23.5166 17.3332C25.2333 15.7998 26.2166 13.4998 26.0166 10.9998C25.8999 9.64984 25.4333 8.41651 24.7333 7.36651C25.3666 7.04984 26.0999 6.84984 26.8499 6.78317C30.1166 6.49984 33.0333 8.93317 33.3166 12.2332Z" fill="currentColor"></path><path d="M36.6502 27.6498C36.5169 29.2665 35.4836 30.6665 33.7502 31.6165C32.0836 32.5332 29.9836 32.9665 27.9002 32.9165C29.1002 31.8332 29.8002 30.4832 29.9336 29.0498C30.1002 26.9832 29.1169 24.9998 27.1502 23.4165C26.0336 22.5332 24.7336 21.8332 23.3169 21.3165C27.0002 20.2498 31.6336 20.9665 34.4836 23.2665C36.0169 24.4998 36.8002 26.0498 36.6502 27.6498Z" fill="currentColor"></path></svg>

                            </div>

                            <p>No Saved beneficiaries</p>

                        </div>';

                    }
                
                ?>

            </div>

            <div class="boxItem">

                <a class="jzzvtLink" href="<?= $_REQUEST['type'] == 'wire' ? 'wire' : 'transfer' ?>">

                    <div class="icon">

                        <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M8.49984 8.00016C10.3408 8.00016 11.8332 6.50778 11.8332 4.66683C11.8332 2.82588 10.3408 1.3335 8.49984 1.3335C6.65889 1.3335 5.1665 2.82588 5.1665 4.66683C5.1665 6.50778 6.65889 8.00016 8.49984 8.00016Z" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.77344 14.6667C2.77344 12.0867 5.3401 10 8.5001 10C9.1401 10 9.76011 10.0867 10.3401 10.2467" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"></path><path d="M15.1668 12.0002C15.1668 12.2135 15.1402 12.4202 15.0868 12.6202C15.0268 12.8868 14.9202 13.1468 14.7802 13.3735C14.3202 14.1468 13.4735 14.6668 12.5002 14.6668C11.8135 14.6668 11.1935 14.4068 10.7268 13.9801C10.5268 13.8068 10.3535 13.6002 10.2202 13.3735C9.97349 12.9735 9.8335 12.5002 9.8335 12.0002C9.8335 11.2802 10.1202 10.6202 10.5868 10.1402C11.0735 9.64018 11.7535 9.3335 12.5002 9.3335C13.2868 9.3335 14.0002 9.67351 14.4802 10.2202C14.9068 10.6935 15.1668 11.3202 15.1668 12.0002Z" stroke="currentColor" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M13.4935 11.9863H11.5068" stroke="currentColor" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M12.5 11.0132V13.0065" stroke="currentColor" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                    </div>

                    <span>Send to a new recipient</span>

                    <div class="icon">

                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12.025 4.94189L17.0834 10.0002L12.025 15.0586" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.91663 10H16.9416" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                    </div>

                </a>

            </div>

        </div>

    </div>

</div>

<?php

    require('../partials/service-footer.php');

?>