<?php

    require('../partials/header.php');

    $pendingMail = true;

    $sess = ['MAIL', 'SUBJECT', 'RECIPIENT', 'MAIL-DEST'];

     foreach ($sess as $ses) {

         if (!isset($_SESSION[$ses])) {

             $pendingMail = false;

        }

     }

    if ($pendingMail) {

        require('../vendor/autoload.php'); // Composer Package File

        require('../controls/engines/mail-delivery-engine.php'); // Mail Delivery Functions

        $mail = $_SESSION['MAIL'];

        $subject = $_SESSION['SUBJECT'];

        $recipientName = $_SESSION['RECIPIENT'];

        $dest = $_SESSION['MAIL-DEST'];

        $deliver = @deliverByPHPMailer($subject, $mail, makePlain($mail), $dest, $recipientName);

        if (!$deliver) {

            $deliver = @deliverByPHPMail($dest, $subject, $mail); //  Fallback

        }

        foreach ($sess as $ses) {

            unset($_SESSION[$ses]);

        }

    }

?>

<?php

    if (DISPLAY_UI == 'ENABLED') { ?>

        <section class="user-info">

            <div class="font-sm" style="text-align: end; padding: 0.35em 1em; /*background-color: var(--pg-txt); color: var(--pg-bg);*/ margin-bottom: 1.2em; border-radius: 0.25em; font-size: 0.6em">
                
                <?php
                
                    $data = activeLog($token, $user_id, $userType, $conn);

                    if ($userType === 'THIRD PARTY') {

                        echo '(ACCESS LIMITED) LOGGED IN as <i translate="no">'. join(' ', [$thirdParty['firstname'], $thirdParty['lastname']]) . '</i> INTO <i translate="no">' . join(' ', [$userData['firstname'], $userData['lastname']]) . '\'s</i> ACCOUNT ' . $data;

                    } else {

                        echo prevLog($token, $user_id, $conn, null, 'Last Login: ') . $data;

                    }

                ?>

            </div>

        </section>

    <?php }

?>

<section id="notification">

    <?php

        // KYC Banner
    
        if ($userData['kyc-status'] == null || $userData['kyc-status'] != 'VERIFIED') {

            ?>

            <div class="dash_banner jzzvt">

                <div class="jzzvt_box txt">

                    <h4>Unlock new account privileges by completing your KYC</h4>

                    <p>Verify your identity to start enjoying <?= $siteName ?></p>

                </div>

                <div class="jzzvt_box prime">

                    <?php
                    
                        if ($userData['kyc-status'] != 'PROCESSING') {

                            echo '<a role="button" iQ-target="#iQ_kyc">Complete Your Account Setup</a>';

                        } else {

                            echo '<a role="button" disabled>Validating KYC...</a>';

                        }

                    ?>

                    <div class="jzzvt_icon"></div>

                </div>

            </div>
            
            <?php

        }

    ?>

</section>

<section id="balance">

    <div class="dash_banner">

        <div class="dashBanner_header">

            <div class="dhb_Bitem">
                
                <h4 class="dashBanner_title">Account Balances <span class="text-min">(<?= ($userAccounts) ? count($userAccounts) : 0 ?>)</span></h4>

                <a class="radial_link" id="iQ_veil">

                    <svg class="default" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7.99995 5.61333C8.27386 5.61333 8.54135 5.65977 8.79276 5.74824C8.54091 5.65941 8.27363 5.61333 7.99995 5.61333ZM7.99995 5.61333C6.68381 5.61333 5.61328 6.68385 5.61328 7.99999M7.99995 5.61333C6.68276 5.61333 5.61328 6.6828 5.61328 7.99999M5.61328 7.99999C5.61328 8.2739 5.65972 8.5414 5.74819 8.7928C5.65936 8.54096 5.61328 8.27368 5.61328 7.99999Z" fill="#2467E3" stroke="#2467E3"></path><path d="M3.73323 12.34C3.6199 12.34 3.4999 12.3 3.40656 12.22C2.69323 11.6133 2.05323 10.8667 1.50656 10C0.799896 8.9 0.799896 7.10666 1.50656 6C3.13323 3.45333 5.4999 1.98666 7.9999 1.98666C9.46656 1.98666 10.9132 2.49333 12.1799 3.44666C12.3999 3.61333 12.4466 3.92666 12.2799 4.14666C12.1132 4.36666 11.7999 4.41333 11.5799 4.24666C10.4866 3.42 9.24656 2.98666 7.9999 2.98666C5.84656 2.98666 3.78656 4.28 2.34656 6.54C1.84656 7.32 1.84656 8.68 2.34656 9.46C2.84656 10.24 3.4199 10.9133 4.05323 11.46C4.2599 11.64 4.28656 11.9533 4.10656 12.1667C4.01323 12.28 3.87323 12.34 3.73323 12.34Z" fill="#2467E3"></path><path d="M7.99972 14.0133C7.11305 14.0133 6.24638 13.8333 5.41305 13.48C5.15972 13.3733 5.03972 13.08 5.14638 12.8267C5.25305 12.5733 5.54638 12.4533 5.79972 12.56C6.50638 12.86 7.24638 13.0133 7.99305 13.0133C10.1464 13.0133 12.2064 11.72 13.6464 9.46C14.1464 8.68 14.1464 7.32 13.6464 6.54C13.4397 6.21334 13.213 5.9 12.973 5.60667C12.7997 5.39334 12.833 5.08 13.0464 4.9C13.2597 4.72667 13.573 4.75334 13.753 4.97334C14.013 5.29334 14.2664 5.64 14.493 6C15.1997 7.1 15.1997 8.89334 14.493 10C12.8664 12.5467 10.4997 14.0133 7.99972 14.0133Z" fill="#2467E3"></path><path d="M8.45973 10.8467C8.22639 10.8467 8.01306 10.68 7.96639 10.44C7.91306 10.1667 8.09306 9.90667 8.36639 9.86C9.09973 9.72667 9.71306 9.11333 9.84639 8.38C9.89973 8.10667 10.1597 7.93333 10.4331 7.98C10.7064 8.03333 10.8864 8.29333 10.8331 8.56667C10.6197 9.72 9.69973 10.6333 8.55306 10.8467C8.51973 10.84 8.49306 10.8467 8.45973 10.8467Z" fill="#2467E3"></path><path d="M1.33427 15.1667C1.2076 15.1667 1.08094 15.12 0.980938 15.02C0.787604 14.8267 0.787604 14.5067 0.980938 14.3133L5.96094 9.33334C6.15427 9.14001 6.47427 9.14001 6.6676 9.33334C6.86094 9.52667 6.86094 9.84667 6.6676 10.04L1.6876 15.02C1.5876 15.12 1.46094 15.1667 1.33427 15.1667Z" fill="#2467E3"></path><path d="M9.68583 6.81334C9.55917 6.81334 9.4325 6.76667 9.3325 6.66667C9.13917 6.47334 9.13917 6.15334 9.3325 5.96001L14.3125 0.980007C14.5058 0.786673 14.8258 0.786673 15.0192 0.980007C15.2125 1.17334 15.2125 1.49334 15.0192 1.68667L10.0392 6.66667C9.93917 6.76667 9.8125 6.81334 9.68583 6.81334Z" fill="#2467E3"></path></svg>

                    <svg class="toggle" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7.99995 10.3867C6.68276 10.3867 5.61328 9.31718 5.61328 7.99999M7.99995 10.3867C9.31714 10.3867 10.3866 9.31718 10.3866 7.99999M7.99995 10.3867C9.31609 10.3867 10.3866 9.31614 10.3866 7.99999M7.99995 10.3867C6.68381 10.3867 5.61328 9.31614 5.61328 7.99999M5.61328 7.99999C5.61328 6.6828 6.68276 5.61333 7.99995 5.61333M5.61328 7.99999C5.61328 6.68385 6.68381 5.61333 7.99995 5.61333M10.3866 7.99999C10.3866 6.6828 9.31714 5.61333 7.99995 5.61333M10.3866 7.99999C10.3866 6.68385 9.31609 5.61333 7.99995 5.61333" fill="#2467E3" stroke="#2467E3"></path><path d="M8.0007 14.0133C5.49404 14.0133 3.12737 12.5467 1.5007 10C0.794036 8.9 0.794036 7.10666 1.5007 6C3.13404 3.45333 5.5007 1.98666 8.0007 1.98666C10.5007 1.98666 12.8674 3.45333 14.494 6C15.2007 7.1 15.2007 8.89333 14.494 10C12.8674 12.5467 10.5007 14.0133 8.0007 14.0133ZM8.0007 2.98666C5.84737 2.98666 3.78737 4.28 2.34737 6.54C1.84737 7.32 1.84737 8.68 2.34737 9.46C3.78737 11.72 5.84737 13.0133 8.0007 13.0133C10.154 13.0133 12.214 11.72 13.654 9.46C14.154 8.68 14.154 7.32 13.654 6.54C12.214 4.28 10.154 2.98666 8.0007 2.98666Z" fill="#2467E3"></path></svg>

                </a>

            </div>

        </div>

        <div data-simplebar class="dashBanner_con bal" id="balances-PC">

            <?php

                if ($userAccounts) {

                    // Iterate Through Accounts

                    foreach ($userAccounts as $account):

                        $id = $account['acc_id'];

                        $balance = $account['balance'];

                        $currency  = $account['currency'];

                        $type = $account['type'];

                        $symbol = '<span translate="no">' . $currSymbol[$currency] . '</span>' ?? '';

                        $flag = $currCountryCodes[$currency];

                        $name = ucwords($currCodeNames[$currency]) ?? '';

                        $icon = null;

                        $inactive = null;

                        if ($currentUserStatus == 'INACTIVE') {

                            $inactive = ' no-access';

                            $type = 'INACTIVE';

                        }

                        if ($account['class'] == 'PRIMARY') {

                            $icon = <<<HTML

                                <div class="icon" style="min-width: 1.5rem; color: var(--OmenXBlue);">
                            
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18"><path d="M4 6.5 6 8l3-3 3 3 2-1.5V10H4V6.5ZM14 13v-2H4v2h10Z" fill="currentColor"/></svg>

                                </div>

                            HTML;

                        }

                    ?>

                    <div class="dashBanner_item<?= ((count($userAccounts) < 3) ? ' min' : '') . $inactive ?>" iQ-target="#iQ_accDetails">

                        <input type="hidden" value="<?= $id ?>">

                        <a class="pos-rel">

                            <p class="acc-class"><?= $type ?></p>

                            <div class="flx jStart">

                                <img class="dshBi_icon flag_icon" src="https://flagcdn.com/<?= strtolower($flag); ?>.svg" alt="">

                                <p><?= $currency ?></p>

                                <?= $icon ?>

                            </div>    

                            <div class="txbox">

                                <p><?= $name ?></p>

                                <p class="acct_desc">

                                    <span class="txSmall"><?= $symbol; ?></span>

                                    <span><span class="txLarge"><?= number_format($balance, 2); ?></span></span>

                                </p>

                            </div>   

                        </a>

                    </div>

                    <?php endforeach;

                } else { ?>

                    <div class="dashBanner_item min">

                        <a class="pos-rel">   

                            <div class="txbox">

                                <p>No Account Found!</p>

                                <p class="acct_desc">

                                    <span class="txLarge">Add an account!</span>

                                </p>

                            </div>   

                        </a>

                    </div>

                <?php }

            ?>

        </div>

        <div class="overview-con" id="balances-mobile">

            <div class="overview-box stats pos-rel">   

                <div class="overview-box-item">

                    <select class="swatch-field" id="account-target">

                        <?php

                            if ($userAccounts) {
                        
                                foreach ($userAccounts as $row): ?>

                                    <option value="<?= $row['acc_id'] ?>"><?= $row['currency'] . ' ' . substr($row['acc_num'], 0, 3) . str_repeat('*', strlen(substr($row['acc_num'], 4))) ?></option>

                                <?php endforeach;

                            }

                        ?>

                    </select>

                </div>

                <div class="overview-box-item" id="account-display"></div>

            </div>

        </div>

    </div>

</section>

<section id="quick-actions">

    <div class="dash_banner">

        <div class="dashBanner_header">

            <h4 class="dashBanner_title">Quick Actions</h4>

        </div>

        <div data-simplebar class="dashBanner_con pdr mobile-grid">

            <div class="dashBanner_item">

                <a iQ-target="#addFunds">

                    <img class="dshBi_icon" src="../assets/media/icons/deposit.svg" alt="">

                    <div class="txbox">

                        <p class="txTitle">Add Money</p>

                        <p class="desc">Fund your account(s) instantly</p>

                    </div>

                </a>

            </div>

            <div class="dashBanner_item">

                <a iQ-target="#sendFunds">

                    <img class="dshBi_icon" src="../assets/media/icons/send.svg" alt="">

                    <div class="txbox">

                        <p class="txTitle">Send Money</p>

                        <p class="desc">Send money to 80+ countries instantly</p>

                    </div>

                </a>

            </div>

            <div class="dashBanner_item">

                <a href="cards">

                    <img class="dshBi_icon" src="../assets/media/icons/card-sm.svg" alt="">

                    <div class="txbox">

                        <p class="txTitle">Virtual Card</p>

                        <p class="desc">Shop, subscribe and pay bills securely online</p>

                    </div>


                </a>

                
            </div>

            <div class="dashBanner_item">

                <a href="invoices">

                    <img class="dshBi_icon" src="../assets/media/icons/invoice.svg" alt="">

                    <div class="txbox">

                        <p class="txTitle">Invoices</p>

                        <p class="desc">Create and send multi-currency invoices to clients and employers</p>

                    </div>

                </a>
                
            </div>

            <div class="dashBanner_item blur">

                <a>

                    <div class="state_device">

                        <span>Coming Soon</span>

                    </div>

                    <img class="dshBi_icon" src="../assets/media/icons/bill.svg" alt="">

                    <div class="txbox">

                        <p class="txTitle">Pay Bills</p>

                        <p class="desc">Pay for your internet, cable subscription, utility bills, & more</p>

                    </div>

                </a>

            </div>

        </div>

    </div>

</section>

<section id="recent-transactions">

    <div class="dash_banner">

        <div class="dashBanner_header">

            <h4 class="dashBanner_title">Recent Transactions</h4>

            <div class="dhb_Bitem">

                <a href="transactions" class="form_link">See all</a>

            </div>

        </div>

        <div class="table_con">

            <table>

                <thead>

                    <tr>

                        <th>Date</th>

                        <th>Amount</th>

                        <th class="mobile-0">Type</th>

                        <th class="mobile-0">Description</th>

                        <th class="mobile-0">Status</th>

                        <th>Actions</th>

                    </tr>

                </thead>

                <tbody>

                    <?php
                    
                        // Get Most Recent Transactions

                        $foundTransc = false; // Flag

                        $transactions = mysqli_prepare($conn, "SELECT * FROM `transactions` WHERE `user_id` = ? ORDER BY `date` DESC LIMIT 5"); // Prepare Statement

                        mysqli_stmt_bind_param($transactions, "s", $currentUser); // Bind Parameter(s) 

                        mysqli_stmt_execute($transactions); // Execute Statement

                        $result = mysqli_stmt_get_result($transactions); // Get Result

                        if (mysqli_num_rows($result) > 0) { // Compare Result Mass

                            $foundTransc = true; // Update Flag

                            $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Get Result Data

                        }

                        mysqli_free_result($result); // Free Result

                        mysqli_stmt_close($transactions); // Close Statement

                        // Check Flag

                        if ($foundTransc) {

                            // Iterate Through Data 

                            foreach ($data as $row) :

                                $currency = $row['currency'];

                                $symbol = $currSymbol[$currency];

                                $date = date('l M d, Y', strtotime($row['date']));

                                $type = $row['type'];

                                $desc = $row['descr'] == null ? '-' : $row['descr'];

                                $amount = '<span translate="no">' . '</span>' . $symbol . number_format($row['amount'], 2);

                                $status = $row['status'];

                                $id = $row['trans_id'];

                                if ($type == 'CREDIT') {

                                    $type = '<span class="i-element green">'. $type .'</span>';

                                } else {

                                    $type = '<span class="i-element red">'. $type .'</span>';

                                }

                                if ($status === 'COMPLETED') {

                                    $icon = '<svg viewBox="0 0 22 22" aria-label="Verified account" role="img"><g><path d="M20.396 11c-.018-.646-.215-1.275-.57-1.816-.354-.54-.852-.972-1.438-1.246.223-.607.27-1.264.14-1.897-.131-.634-.437-1.218-.882-1.687-.47-.445-1.053-.75-1.687-.882-.633-.13-1.29-.083-1.897.14-.273-.587-.704-1.086-1.245-1.44S11.647 1.62 11 1.604c-.646.017-1.273.213-1.813.568s-.969.854-1.24 1.44c-.608-.223-1.267-.272-1.902-.14-.635.13-1.22.436-1.69.882-.445.47-.749 1.055-.878 1.688-.13.633-.08 1.29.144 1.896-.587.274-1.087.705-1.443 1.245-.356.54-.555 1.17-.574 1.817.02.647.218 1.276.574 1.817.356.54.856.972 1.443 1.245-.224.606-.274 1.263-.144 1.896.13.634.433 1.218.877 1.688.47.443 1.054.747 1.687.878.633.132 1.29.084 1.897-.136.274.586.705 1.084 1.246 1.439.54.354 1.17.551 1.816.569.647-.016 1.276-.213 1.817-.567s.972-.854 1.245-1.44c.604.239 1.266.296 1.903.164.636-.132 1.22-.447 1.68-.907.46-.46.776-1.044.908-1.681s.075-1.299-.165-1.903c.586-.274 1.084-.705 1.439-1.246.354-.54.551-1.17.569-1.816zM9.662 14.85l-3.429-3.428 1.293-1.302 2.072 2.072 4.4-4.794 1.347 1.246z" fill="currentColor"></path></g></svg>';

                                    $class = ' verified';

                                } else if ($status === 'INCOMPLETE' || $status === 'DISPUTED') {

                                    $icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-alert mr-2 h-4 w-4"><circle cx="12" cy="12" r="10"></circle><line x1="12" x2="12" y1="8" y2="12"></line><line x1="12" x2="12.01" y1="16" y2="16"></line></svg>';

                                    $class = ' error';

                                } else {

                                    $icon = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-timer mr-2 h-4 w-4 text-muted-foreground"><line x1="10" x2="14" y1="2" y2="2"></line><line x1="12" x2="15" y1="14" y2="11"></line><circle cx="12" cy="14" r="8"></circle></svg>';

                                    $class = ' orange';

                                }

                                $status = '<div class="verif v2 sm'. $class .'">

                                    <div class="icon">' . $icon . '</div>       
                                    
                                    <span>' . ucwords($status) . '</span>
                            
                                </div>';

                            ?>
                            
                            <tr>

                                <td><?= $date ?></td>

                                <td><?= $amount . '<sup class="label" translate="no">' . $currency . '</sup>' ?></td>

                                <td class="mobile-0"><?= $type ?></td>

                                <td class="mobile-0"><?= $desc ?></td>

                                <td class="mobile-0"><?= $status ?></td>

                                <td>

                                    <div class="flx">

                                        <div class="fetch-trans-details mobile-0">

                                            <input type="hidden" value="<?= $id ?>">

                                            <span class="badge pill iQ_rqust" iQ-target="#iQ_transDetails">Details</span>

                                        </div>

                                        <div class="iQ_rqustCon2">

                                            <input type="hidden" value="<?= $id ?>">

                                            <span class="badge pill plain iQ_rqust" iQ-target="#iQ_transReceipt">Receipt</span>

                                        </div>

                                    </div>    

                                </td>

                            </tr>

                            <?php endforeach;

                        } else {

                            emptyTable('Ready to make your first transaction?');

                        }

                    ?>

                </tbody>

            </table>

        </div>

    </div>

</section>

<style>

    .swatch-field {

        width: 126% !important;

    }

</style>

<?php

    require('../partials/footer.php');

?>                