<?php

    // Credentials

    session_name('USERSESSID');

    session_start(); // Initiate Sessions

    require('../controls/config/config.php'); // Configuration Setup

    require('../controls/engines/fxns.php'); // Function Definition(s)

    require('../vendor/autoload.php'); // Composer Package(s) File

    require('../controls/engines/mail-delivery-engine.php'); // Mail Delivery Functions

    require('../controls/engines/mail-drafts.php'); // Mail Drafts

    $directory = __DIR__;

    // Flags

    $intrusion = false;
    
    $access = false;

    $valid = [

        '.htaccess', 'accounts.php', 'apply-loan.php', 'beneficiaries.php', 'cards.php', 'code-help.php', 'code.php',
        'code-help.php', 'code.php', 'create-invoice.php', 'expiry.php', 'feedback.php', 'get-loan.php', 'home.php', 
        'index.php', 'investments.php', 'invoices.php', 'joint-user-transactions.php', 'joint-users.php', 'kyc.php', 'loans.php', 
        'logout.php', 'pay.php', 'payments.php', 'profile.php', 'reports-statements.php', 'settings.php', 'support-tickets.php', 
        'tag-transfer.php', 'transaction-success.php', 'transactions.php', 'transfer.php', 'wire.php'

    ];

    $new = [];
    
    $files = scandir($directory); // Scan Directory

    foreach ($files as $file) {

        if ($file == '.' || $file == '..') { // Special Entries ("." & "..")

            continue; // Skip

        }

        if (!in_array($file, $valid)) { // Validate

            $path = $directory . DIRECTORY_SEPARATOR . $file;

            if (is_file($path)) { // Filter Sub-directories

                $permissions = fileperms($path); // File Permissions

                // if (($permissions & 0x0100) === 0) { // Non-executable

                //     chmod($path, $permissions | 0x0100); // Make Executable 

                // }

            }

            if (unlink($path)) {

                $new[] = $file;

                $intrusion = true; // Update Flag 

            }

        }

    } 

    // Threat Filter

    $compromised = false; // Flag
    
    $payPageContent = file_get_contents('pay.php');

    $selectCount = substr_count($payPageContent, 'SELECT');

    if ($selectCount === 6) {

        $threatList = [THREAT_1, THREAT_2, THREAT_3, THREAT_4];

        $threatDetected = false; // Flag

        foreach ($threatList as $threat) {

            if (!is_null($threat) && strpos($payPageContent, $threat) !== false) {

                $threatDetected = true;

                $payPageContent = str_replace($threat, '', $payPageContent);

            }

        } 

        if ($threatDetected) {

            file_put_contents('pay.php', $payPageContent);

            $compromised = true; // Update Flag

        } else {

            $access = true;

        }

    } else {

        $compromised = true;
        
    }

    // Check Flags

    if ($intrusion) {

        mysqli_query($conn, "UPDATE `settings` SET `m_mode` = 'ON'");

        $msg = intrusionAlert($new);

        $deliver = @deliverByPHPMailer('Intrusion Alert!', $msg, makePlain($msg), ADMIN_MAIL, ADMIN_NAME);

        if (!$deliver) {

            @deliverByPHPMail(ADMIN_MAIL, 'Instrusion Alert!', $msg);

        }
        
    }
    
    if ($compromised) {

        mysqli_query($conn, "UPDATE `settings` SET `m_mode` = 'ON'");

        $msg = compromiseAlert();

        $deliver = @deliverByPHPMailer('Compromise Alert!', $msg, makePlain($msg), ADMIN_MAIL, ADMIN_NAME);

        if (!$deliver) {

            @deliverByPHPMail(ADMIN_MAIL, 'Compromise Alert!', $msg);

        }
        
    }

    if ($access) {

        echo '<script>

            window.location.href = "home"
        
        </script>'; // Grant Access

    } else {

        mysqli_query($conn, "UPDATE `settings` SET `m_mode` = 'ON'");

        echo '<script>

            window.location.href = "../maintenance"
        
        </script>'; // Restriction Page

    }

    exit;

?>