<?php

    require('../partials/header.php');

    blockThirdParty(); // Block Third Party User

    // Check For USD Account

    $accountUSD = currencyAccountData('USD', $user_id, $conn);

    if (!$accountUSD) {

        echo "<script>
        
            popup({

                header: 'ATTENTION!',

                title: 'USD Account Required',

                text: 'You will need a USD account in order to invest.',

                type: 'warning',

            }).then(() => {

                window.location.href = 'accounts';

            });

        </script>";

        // exit;

    }

?>

<section id="plans">

    <div class="dash_banner">

        <div class="dashBanner_header">
                    
            <div class="dhb_Bitem">
                
                <h4 class="dashBanner_title">Plans</h4>

            </div>

        </div>

        <?php
        
            $plans = false; // Flag

            $stmt = mysqli_prepare($conn, "SELECT * FROM `investments`"); // Prepare Statement (Get Plans)

            mysqli_stmt_execute($stmt); // Execute Statement

            $result = mysqli_stmt_get_result($stmt); // Get Result

            if (mysqli_num_rows($result) > 0) {

                $plans = true; // Update Flag

                $data = mysqli_fetch_all($result, MYSQLI_ASSOC); // Hold Result Data

            }

            mysqli_free_result($result); // Free Result
            
            mysqli_stmt_close($stmt); // Close Statement

            // Check Flag

            if ($plans) { ?>
            
                <div class="dashBanner_con grid x3">
                    
                    <?php

                        foreach ($data as $row):

                            $id = $row['inv_id'];

                            $image = $row['image'];

                            $name = $row['name'];

                            $type = $row['category'];

                            $min = $row['min_amount'];

                            $max = $row['max_amount'];

                            $duration = $row['duration'] . ' day(s)';

                            $risk = $row['risk_factor'];

                            $interest = $row['interest_rate'] . '%';

                            $protocol = $row['return_type'];

                            $frequency = $row['frequency'];

                            $descr = $row['descr']; 
                            
                            if ($protocol == 'VARIABLE') {

                                $interest = 'Up to ' . $interest;

                            } 
                            
                            $spread = null;

                            if ($min != null && $min > 0) {

                                $spread = ($max - $min); // Update Spread

                            } ?>

                            <div class="dashBanner_item min">

                                <a>

                                    <?php
                                    
                                        if ($image != null) {

                                            $image = SITE_BASE_URL . '/' . str_replace('../', '', $image); ?>

                                            <img class="dshBi_icon flag_icon" src="<?= $image ?>" alt="">

                                        <?php }

                                    ?>

                                    <div class="txbox">

                                        <p class="txTitle"><?= $name ?> <sup class="label"><?= $type ?></sup></p>

                                        <!-- <p><?= ($min != null) ? '<span translate="no">$</span>' . number_format($min, 2) . ' - ' : null ?><?= '<span translate="no">$</span>' . number_format($max, 2) ?></p>

                                        <p><?= $duration ?></p> -->

                                        <p class="desc"><?= $descr ?></p>

                                        <p class="tick">Price: <?= ($min != null) ? '<span translate="no">$</span>' . number_format($min, 2) . ' - ' : null ?><?= '<span translate="no">$</span>' . number_format($max, 2) ?></p>

                                        <p class="tick">Cycle: <?= $duration ?></p>

                                        <?php
                                        
                                            if ($spread != null) {

                                                echo '<p class="tick">Spread: <span translate="no">$</span>', number_format($spread, 2) ,'</p>';

                                            }
                                        
                                        ?>

                                        <p class="tick">ROI: <?= $protocol ?></p>

                                        <p class="tick">Rate: <?= $interest ?></p>

                                        <p class="tick">Payout: <?= $frequency ?></p>

                                    </div>

                                    <div class="plan-data" style="margin-top: auto;">

                                        <input type="hidden" name="inv-id" value="<?= $id ?>">

                                        <input type="hidden" name="inv-name" value="<?= $name ?>">

                                        <?php

                                            if ($min) { ?>

                                                <input type="hidden" name="inv-min" value="<?= $min ?>">

                                            <?php }

                                        ?>    

                                        <input type="hidden" name="inv-max" value="<?= $max ?>">

                                        <button class="form_btn plan-apply" iQ-target="#iQ_invest">Invest</button>

                                        <div class="flx jSpaceBtw" style="margin-top: 2em; padding: 0.5em 0; border-top: 1px solid currentColor;">

                                            <div class="icon" style="width: 1.5em; color: orange;">

                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" fill="currentColor" viewBox="0 0 611.999 611.999" xml:space="preserve">
                                                    <path d="M216.02,611.195c5.978,3.178,12.284-3.704,8.624-9.4c-19.866-30.919-38.678-82.947-8.706-149.952   c49.982-111.737,80.396-169.609,80.396-169.609s16.177,67.536,60.029,127.585c42.205,57.793,65.306,130.478,28.064,191.029   c-3.495,5.683,2.668,12.388,8.607,9.349c46.1-23.582,97.806-70.885,103.64-165.017c2.151-28.764-1.075-69.034-17.206-119.851   c-20.741-64.406-46.239-94.459-60.992-107.365c-4.413-3.861-11.276-0.439-10.914,5.413c4.299,69.494-21.845,87.129-36.726,47.386   c-5.943-15.874-9.409-43.33-9.409-76.766c0-55.665-16.15-112.967-51.755-159.531c-9.259-12.109-20.093-23.424-32.523-33.073   c-4.5-3.494-11.023,0.018-10.611,5.7c2.734,37.736,0.257,145.885-94.624,275.089c-86.029,119.851-52.693,211.896-40.864,236.826   C153.666,566.767,185.212,594.814,216.02,611.195z"/>
                                                </svg>

                                            </div>

                                            <p><?= strtoupper($risk) ?></p>

                                        </div>

                                    </div>

                                </a>

                            </div>

                        <?php endforeach;
                    
                    ?>

                </div>

            <?php } else { ?>

                <div class="unavailable flx col">

                    <div class="icon">

                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-lg shrink-0"><path d="M13 12C13 11.4477 12.5523 11 12 11C11.4477 11 11 11.4477 11 12V16C11 16.5523 11.4477 17 12 17C12.5523 17 13 16.5523 13 16V12Z" fill="currentColor"></path><path d="M12 9.5C12.6904 9.5 13.25 8.94036 13.25 8.25C13.25 7.55964 12.6904 7 12 7C11.3096 7 10.75 7.55964 10.75 8.25C10.75 8.94036 11.3096 9.5 12 9.5Z" fill="currentColor"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2ZM4 12C4 7.58172 7.58172 4 12 4C16.4183 4 20 7.58172 20 12C20 16.4183 16.4183 20 12 20C7.58172 20 4 16.4183 4 12Z" fill="currentColor"></path></svg>

                    </div>

                    <p>Sorry! Plans are Unavailable at the moment.</p>

                </div>

            <?php }
        
        ?>

    </div>

</section>

<!-- Modal: Investment Plan -->

<div class="popup_window variantB n_displ" role="dialog">

    <div id="iQ_invest" class="popup_con variantB n_displ">

        <div class="radial_icon popup_closeBtn iQ_terminator">

            <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

        </div>

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header variantB">

                <p>Invest</p>

            </div>

            <div class="modal_box">

                <form id="investForm" method="post">

                    <div class="form_item">

                        <input name="plan-id" id="plan-id" type="hidden">

                        <label for="plan-name">Commodity</label>

                        <input name="plan-name" id="plan-name" type="text" class="form_field" readonly>

                    </div>

                    <div class="form_item">

                        <label for="plan-price">Amount (USD)</label>

                        <input name="plan-price" id="plan-price" type="number" step="0.01" class="form_field" required>

                    </div>

                    <?php
                    
                        if ($userData['investment-channel'] == 'BOTH') { ?>

                            <div class="form_item db">

                                <div class="form_item formBtn_con">

                                    <button name="transaction" value="DEPOSIT" class="form_btn" type="submit">Pay from Account</button>

                                </div>
                                
                                <div class="form_item formBtn_con">

                                    <button name="pay" value="PAY" class="form_btn" type="submit">More Options</button>

                                </div>

                            </div>

                        <?php } else { ?>

                            <div class="form_item formBtn_con">

                                <button name="invest" id="invest" value="<?= ($userData['investment-channel'] == 'PAY') ? 'PAY' : 'BALANCE' ?>" class="form_btn" type="submit">Proceed</button>
                                
                            </div>

                        <?php }
                    
                    ?>

                </form>

            </div>

        </div>

    </div>

</div>

<?php

    require('../partials/footer.php');

?>