<?php

    require('../partials/header.php');

    blockThirdParty(); // Block Third Party

?>

<section>

    <div class="dash_banner" style="min-height: 70vh;">

        <div class="dashBanner_con wrap">

            <div class="dashBanner_item blur">

                <a href="#">

                    <div class="state_device">

                        <span>Coming Soon</span>

                    </div>

                    <div class="radial_icon">

                        <img class="dshBi_icon" src="../assets/media/icons/proof.svg" alt="">

                    </div>

                    <div class="txbox">

                        <p class="txTitle">Proof of account</p>

                        <p class="desc">Verify your account ownership with a document from <?= $siteName ?>, confirming it's yours.</p>

                    </div>

                </a>

            </div>

            <div class="dashBanner_item">

                <a iQ-target="#iQ_stmt">

                    <div class="radial_icon">

                        <img class="dshBi_icon" src="../assets/media/icons/statement.svg" alt="">

                    </div>

                    <div class="txbox">

                        <p class="txTitle">Statement of account</p>

                        <p class="desc">View and track your transactions across all your accounts easily.</p>

                    </div>

                </a>

            </div>

            <div class="dashBanner_item blur">

                <a href="#">

                    <div class="state_device">

                        <span>Coming Soon</span>

                    </div>

                    <div class="radial_icon">

                        <img class="dshBi_icon" src="../assets/media/icons/insight.svg" alt="">

                    </div>

                    <div class="txbox">

                        <p class="txTitle">Expense insight</p>

                        <p class="desc">Take a look of your inflow and outflow activity across all your wallets</p>

                    </div>

                </a>

            </div>

        </div>

    </div>

</section>

<!-- Popup: Statement Download Request -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ_stmt" class="popup_con n_displ">

        <div class="popup_box noScrollBar">

            <div class="popupBox_header">

                <p>Account Statement</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="var(--pg-svg)" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="var(--pg-svg)" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <form id="stmtForm" method="post">

                    <div class="form_item">

                        <label for="account">Currency</label>

                        <select name="account" class="form_field">

                            <option value="0">Select Account Currency</option>

                            <?php

                                if ($userAccounts) {
                            
                                    foreach ($userAccounts as $account):

                                        echo '<option value="' . $account['acc_id'] . '">' . $currCodeNames[$account['currency']] . '(' . $account['currency'] . ')</option>';

                                    endforeach;

                                }
                            
                            ?>

                        </select>

                    </div>

                    <div class="form_item db">

                        <div class="form_item">

                            <label for="start">Start date</label>

                            <input type="date" name="start" class="form_field" required>

                        </div>

                        <div class="form_item">

                            <label for="end">End date</label>

                            <input type="date" name="end" class="form_field" required>

                        </div>

                    </div>

                    <div class="form_item radio">

                        <label for="format">Format</label>

                        <div class="iQ_radio" title="Married"><input type="radio" name="format" value="CSV" required> <span>.csv</span></div>

                        <div class="iQ_radio" title="Single"><input type="radio" name="format" value="PDF"> <span>.pdf</span></div>

                    </div>

                    <div class="form_item">

                        <button type="submit" name="getStmt" id="getStmt" class="form_btn">Download Statement</button>

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

<?php

    require('../partials/footer.php');

?>                