<?php

    require('../partials/header.php');

    blockThirdParty();

    $token = $_COOKIE['ACCESS-iD'] ?? null;

    // Fetch User's Activity Data

    $stmt = mysqli_prepare($conn, "SELECT * FROM `activity_logs` WHERE `user_id` = ? AND `token` = ?"); // Prepare Statement

    mysqli_stmt_bind_param($stmt, "ss", $user_id, $token); // Bind Parameter(s)

    mysqli_stmt_execute($stmt); // Execute Statement

    $result = mysqli_stmt_get_result($stmt); // Get Result

    if (mysqli_num_rows($result) === 1) {

        while ($row = mysqli_fetch_assoc($result)) {

            $ip = $row['ip_address'];
            
            $locale = $row['location'];

            $browser = $row['browser'];

            $device = $row['device']; 

            $longitude = $row['longitude'];

            $latitude = $row['latitude'];

            $timezone = $row['timezone'];

        }

    }

    mysqli_free_result($result);

    mysqli_stmt_close($stmt);

?>

<section id="settings">

    <div class="iQ_panels">

        <div class="dash_banner v2">

            <div class="page_panelTab noScrollBar" style="flex-wrap: wrap;">

                <div class="page_panelSwitch iQ_panelSwitch active" data-tab="security">Security</div>

                <div class="page_panelSwitch iQ_panelSwitch" data-tab="beneficiary">Beneficiaries</div>

                <div class="page_panelSwitch iQ_panelSwitch" data-tab="verif">Account Verification</div>

            </div>

        </div>

        <div class="iQ_panelDispl tabs">

            <div class="iQ_panel" id="security">

                <div class="dash_banner v2">

                    <div class="dashBanner_header">

                        <div class="dbHeader_item">

                            <h4 class="dashBanner_title">User Data</h4>

                        </div>

                    </div>

                    <div class="dashBanner_box">

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">IP Address</div>

                            <p translate="no"><?= $ip ?? '-'; ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Locale</div>

                            <p translate="no"><?= $locale ?? '-'; ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Longitude</div>

                            <p><?= $longitude ?? '-'; ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Latitude</div>

                            <p translate="no"><?= $latitude ?? '-' ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Browser</div>

                            <p><?= $browser ?? '-'; ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Device</div>

                            <p><?= $device ?? '-'; ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Last Visit</div>

                            <p><?= prevLog($token, $user_id, $conn, ($timezone ?? null)) ?? '-' ?></p>

                        </div>

                    </div>

                </div>

                <div class="dash_banner v2">

                    <div class="dashBanner_header">

                        <div class="dbHeader_item">

                            <h4 class="dashBanner_title">Security Settings</h4>

                        </div>

                    </div>

                    <div class="dashBanner_box v2">

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Login Alerts</div>

                            <p>Receive login alerts, sent to your email</p>

                            <button type="button" id="iQ_loginAlerts" class="toggle-btn" role="switch" aria-checked="<?= $userData['login-alerts'] == 'ENABLED' ? 'true' : 'false' ?>" value="<?= $userData['login-alerts'] == 'ENABLED' ? 'on' : 'off' ?>" title="Login Alert toggle">

                                <div class="toggle"></div>

                            </button>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">2FA</div>

                            <p>Enable two-factor-authentication</p>

                            <button type="button" id="iQ_2fa" class="toggle-btn" role="switch" aria-checked="<?= $userData['auth'] == 'ENABLED' ? 'true' : 'false' ?>" value="<?= $userData['auth'] == 'ENABLED' ? 'on' : 'off' ?>" title="OTP/2FA toggle">

                                <div class="toggle"></div>

                            </button>

                        </div>

                        <!-- <div class="dB_boxItem">

                            <div class="dB_boxHeading">Transaction Alert</div>

                            <p>Notifications on the status of your transactions</p>

                            <button type="button" id="" class="toggle-btn" role="switch" aria-checked="" value="" title="">

                                <div class="toggle"></div>

                            </button>

                        </div> -->

                    </div>

                    <br>

                    <div class="dashBanner_box v2">

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Reset Password</div>

                            <p>Reset your password at anytime</p>

                            <div class="dB_boxAccess" iQ-target="#iQ_resetPwrd">
                            
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48"><path fill="currentColor" stroke="currentColor" stroke-width="1.5" d="M40,32.578V40H32V36H28V32H24V28.766A10.689,10.689,0,0,1,19,30a10.9,10.9,0,0,1-5.547-1.5,11.106,11.106,0,0,1-2.219-1.719A11.373,11.373,0,0,1,9.5,24.547a10.4,10.4,0,0,1-1.109-2.625A11.616,11.616,0,0,1,8,19a10.9,10.9,0,0,1,1.5-5.547,11.106,11.106,0,0,1,1.719-2.219A11.373,11.373,0,0,1,13.453,9.5a10.4,10.4,0,0,1,2.625-1.109A11.616,11.616,0,0,1,19,8a10.9,10.9,0,0,1,5.547,1.5,11.106,11.106,0,0,1,2.219,1.719A11.373,11.373,0,0,1,28.5,13.453a10.4,10.4,0,0,1,1.109,2.625A11.616,11.616,0,0,1,30,19a10.015,10.015,0,0,1-.125,1.578,10.879,10.879,0,0,1-.359,1.531Zm-2,.844L27.219,22.641a14.716,14.716,0,0,0,.562-1.782A7.751,7.751,0,0,0,28,19a8.786,8.786,0,0,0-.7-3.5,8.9,8.9,0,0,0-1.938-2.859A9.269,9.269,0,0,0,22.5,10.719,8.9,8.9,0,0,0,19,10a8.786,8.786,0,0,0-3.5.7,8.9,8.9,0,0,0-2.859,1.938A9.269,9.269,0,0,0,10.719,15.5,8.9,8.9,0,0,0,10,19a8.786,8.786,0,0,0,.7,3.5,8.9,8.9,0,0,0,1.938,2.859A9.269,9.269,0,0,0,15.5,27.281a8.842,8.842,0,0,0,6.469.2A8.767,8.767,0,0,0,24.609,26H26v4h4v4h4v4h4ZM16,14a1.938,1.938,0,0,1,.781.156,2,2,0,0,1,.625.422,2.191,2.191,0,0,1,.438.641A1.705,1.705,0,0,1,18,16a1.938,1.938,0,0,1-.156.781,2,2,0,0,1-.422.625,2.191,2.191,0,0,1-.641.438A1.705,1.705,0,0,1,16,18a1.938,1.938,0,0,1-.781-.156,2,2,0,0,1-.625-.422,2.191,2.191,0,0,1-.438-.641A1.705,1.705,0,0,1,14,16a1.938,1.938,0,0,1,.156-.781,2,2,0,0,1,.422-.625,2.191,2.191,0,0,1,.641-.438A1.705,1.705,0,0,1,16,14Z"/></svg>
                            
                                <span>Proceed</span>
                            </div>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Update Transaction PIN</div>

                            <p>Set a New Transaction PIN</p>

                            <div class="dB_boxAccess" iQ-target="#iQ_tPIN">
                            
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48"><path fill="currentColor" stroke="currentColor" stroke-width="1.5" d="M40,32.578V40H32V36H28V32H24V28.766A10.689,10.689,0,0,1,19,30a10.9,10.9,0,0,1-5.547-1.5,11.106,11.106,0,0,1-2.219-1.719A11.373,11.373,0,0,1,9.5,24.547a10.4,10.4,0,0,1-1.109-2.625A11.616,11.616,0,0,1,8,19a10.9,10.9,0,0,1,1.5-5.547,11.106,11.106,0,0,1,1.719-2.219A11.373,11.373,0,0,1,13.453,9.5a10.4,10.4,0,0,1,2.625-1.109A11.616,11.616,0,0,1,19,8a10.9,10.9,0,0,1,5.547,1.5,11.106,11.106,0,0,1,2.219,1.719A11.373,11.373,0,0,1,28.5,13.453a10.4,10.4,0,0,1,1.109,2.625A11.616,11.616,0,0,1,30,19a10.015,10.015,0,0,1-.125,1.578,10.879,10.879,0,0,1-.359,1.531Zm-2,.844L27.219,22.641a14.716,14.716,0,0,0,.562-1.782A7.751,7.751,0,0,0,28,19a8.786,8.786,0,0,0-.7-3.5,8.9,8.9,0,0,0-1.938-2.859A9.269,9.269,0,0,0,22.5,10.719,8.9,8.9,0,0,0,19,10a8.786,8.786,0,0,0-3.5.7,8.9,8.9,0,0,0-2.859,1.938A9.269,9.269,0,0,0,10.719,15.5,8.9,8.9,0,0,0,10,19a8.786,8.786,0,0,0,.7,3.5,8.9,8.9,0,0,0,1.938,2.859A9.269,9.269,0,0,0,15.5,27.281a8.842,8.842,0,0,0,6.469.2A8.767,8.767,0,0,0,24.609,26H26v4h4v4h4v4h4ZM16,14a1.938,1.938,0,0,1,.781.156,2,2,0,0,1,.625.422,2.191,2.191,0,0,1,.438.641A1.705,1.705,0,0,1,18,16a1.938,1.938,0,0,1-.156.781,2,2,0,0,1-.422.625,2.191,2.191,0,0,1-.641.438A1.705,1.705,0,0,1,16,18a1.938,1.938,0,0,1-.781-.156,2,2,0,0,1-.625-.422,2.191,2.191,0,0,1-.438-.641A1.705,1.705,0,0,1,14,16a1.938,1.938,0,0,1,.156-.781,2,2,0,0,1,.422-.625,2.191,2.191,0,0,1,.641-.438A1.705,1.705,0,0,1,16,14Z"/></svg>
                            
                                <span>Proceed</span>
                            </div>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Delete Account</div>

                            <p>...</p>

                            <div class="dB_boxAccess" iQ-target="">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0"><path fill-rule="evenodd" clip-rule="evenodd" d="M10.5555 4C10.099 4 9.70052 4.30906 9.58693 4.75114L9.29382 5.8919H14.715L14.4219 4.75114C14.3083 4.30906 13.9098 4 13.4533 4H10.5555ZM16.7799 5.8919L16.3589 4.25342C16.0182 2.92719 14.8226 2 13.4533 2H10.5555C9.18616 2 7.99062 2.92719 7.64985 4.25342L7.22886 5.8919H4C3.44772 5.8919 3 6.33961 3 6.8919C3 7.44418 3.44772 7.8919 4 7.8919H4.10069L5.31544 19.3172C5.47763 20.8427 6.76455 22 8.29863 22H15.7014C17.2354 22 18.5224 20.8427 18.6846 19.3172L19.8993 7.8919H20C20.5523 7.8919 21 7.44418 21 6.8919C21 6.33961 20.5523 5.8919 20 5.8919H16.7799ZM17.888 7.8919H6.11196L7.30423 19.1057C7.3583 19.6142 7.78727 20 8.29863 20H15.7014C16.2127 20 16.6417 19.6142 16.6958 19.1057L17.888 7.8919ZM10 10C10.5523 10 11 10.4477 11 11V16C11 16.5523 10.5523 17 10 17C9.44772 17 9 16.5523 9 16V11C9 10.4477 9.44772 10 10 10ZM14 10C14.5523 10 15 10.4477 15 11V16C15 16.5523 14.5523 17 14 17C13.4477 17 13 16.5523 13 16V11C13 10.4477 13.4477 10 14 10Z" fill="currentColor"></path></svg>
                                <span>Proceed</span>
                            </div>

                        </div>

                    </div>

                </div>

                <div class="dash_banner v2">

                    <div class="dashBanner_header col">

                        <div class="dbHeader_item">

                            <h4 class="dashBanner_title">Devices and Sessions</h4>

                        </div>

                        <p class="text-min">You've logged in with these device(s):</p>

                    </div>

                    <div class="table_con" id="table-1">

                        <table>

                            <thead>

                                <tr>

                                    <th>Datetime</th>

                                    <th>Device</th>

                                    <th>Location</th>

                                    <th>Status</th>

                                    <!-- <th>Actions</th> -->
            
                                </tr>

                            </thead>

                            <tbody>

                                <?php
                                
                                    $found = false; // Flag

                                    $stmt = mysqli_prepare($conn, "SELECT * FROM `activity_logs` WHERE `user_id` = ? ORDER BY `logged_in` DESC"); // Prepare Statement

                                    $status = 'ACTIVE';

                                    mysqli_stmt_bind_param($stmt, "s", $user_id); // Bind Parameter(s)

                                    mysqli_stmt_execute($stmt); // Execute Statement

                                    $result = mysqli_stmt_get_result($stmt); // Get Statement Result

                                    if (mysqli_num_rows($result) > 0) {

                                        $found = true; // Update Flag

                                        $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

                                    }

                                    mysqli_free_result($result); // Free Result

                                    mysqli_stmt_close($stmt); // Close Statement

                                    // Consider Flag

                                    if ($found) {

                                        foreach ($data as $row):

                                            $token = $row['token'];

                                            $device = (is_null($row['device']) || empty($row['device'])) ? 'UNIDENTIFED' : $row['device'];

                                            $location = (is_null($row['location']) || empty($row['location'])) ? 'UNKNOWN' : $row['location'];

                                            $status = (is_null($row['status']) || empty($row['status'])) ? 'UNDETERMINED' : $row['status'];

                                            $logged = $row['logged_in'];
                                            
                                            $tZone = $row['timezone'] ?? 'UNKNOWN'; ?>

                                            <tr class="iQ_tRow">

                                                <td>

                                                    <p><?= date('l, M d, Y (H:i)', strtotime($logged)) ?></p>

                                                    <p class="text-min">Timezone: <?= $tZone ?></p>

                                                </td>

                                                <td><?= $device ?></td>

                                                <td><?= $location ?></td>

                                                <td><?= $status ?></td>

                                            </tr>

                                        <?php endforeach;    

                                    } else {

                                        emptyTable('Error, no logs!', '<svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M26.984 3.33331H13.0173C6.95065 3.33331 3.33398 6.94998 3.33398 13.0166V26.9666C3.33398 33.05 6.95065 36.6666 13.0173 36.6666H26.9673C33.034 36.6666 36.6507 33.05 36.6507 26.9833V13.0166C36.6673 6.94998 33.0507 3.33331 26.984 3.33331ZM28.7673 16.6L24.9173 21.5666C24.434 22.1833 23.7507 22.5833 22.9673 22.6666C22.184 22.7666 21.4173 22.55 20.8007 22.0666L17.7507 19.6666C17.634 19.5666 17.5007 19.5666 17.434 19.5833C17.3673 19.5833 17.2507 19.6166 17.1507 19.75L13.184 24.9C12.934 25.2166 12.5673 25.3833 12.2007 25.3833C11.934 25.3833 11.6673 25.3 11.434 25.1166C10.884 24.7 10.784 23.9166 11.2007 23.3666L15.1673 18.2166C15.6507 17.6 16.334 17.2 17.1173 17.1C17.884 17 18.6673 17.2166 19.284 17.7L22.334 20.1C22.4507 20.2 22.5673 20.2 22.6507 20.1833C22.7173 20.1833 22.834 20.15 22.934 20.0166L26.784 15.05C27.2007 14.5 28.0007 14.4 28.534 14.8333C29.084 15.2833 29.184 16.0666 28.7673 16.6Z" fill="#C2C9D6"></path></svg>');

                                    }
                                
                                ?>
                                
                            </tbody>

                        </table>

                        <div class="table_nav">

                            <button class="prevPage" disabled>

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.37999 3.95333L2.33333 8L6.37999 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M13.6667 8H2.44667" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                                
                                <span>Prev</span>
                        
                            </button>

                            <button class="nextPage" disabled>
                                
                                <span>Next</span>

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.62 3.95334L13.6667 8.00001L9.62 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.33331 8H13.5533" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                        
                            </button>

                        </div>

                    </div>

                </div>

            </div>

            <div class="iQ_panel n_displ" id="beneficiary">

                <div class="dash_banner jzzvt">

                    <div class="jzzvt_box txt">

                        <h4>Manage Beneficiaries</h4>

                        <p>Manage your saved beneficiaries.</p>

                    </div>

                    <div class="jzzvt_box prime">

                        <div class="jzzvt_icon" style="background-image: url(../assets/media/images/beneficiaries.webp)"></div>

                    </div>

                </div>
                
                <div class="dash_banner v2">

                    <div class="dashBanner_header col">

                        <div class="dbHeader_item">

                            <h4 class="dashBanner_title">Saved Beneficiaries</h4>

                        </div>

                    </div>

                    <div class="table_con" id="table-2">

                        <!-- Add Search Functionality-->

                        <table>

                            <thead>

                                <tr>

                                    <th>Name</th>

                                    <th>Transfer Type</th>

                                    <th class="mobile-0">Bank</th>

                                    <th>Actions</th>
            
                                </tr>

                            </thead>

                            <tbody>

                                <?php
                                
                                    // Commence Beneficiary Fetch

                                    $found = false; // Flag

                                    $stmt = mysqli_prepare($conn, "SELECT * FROM `beneficiaries` WHERE `user_id` = ?"); // Prepare Statement

                                    mysqli_stmt_bind_param($stmt, "s", $user_id); // Bind Parameter(s)

                                    mysqli_stmt_execute($stmt); // Execute Statement

                                    $result = mysqli_stmt_get_result($stmt); // Get Result

                                    if (mysqli_num_rows($result) > 0) {

                                        $found = true; // Update Flag

                                        $data = mysqli_fetch_all($result, MYSQLI_ASSOC);

                                    }

                                    mysqli_free_result($result); // Free Result

                                    mysqli_stmt_close($stmt); // Close Statement

                                    // Consider Flag

                                    if ($found) {

                                        foreach ($data as $row):

                                            $id = $row['id'];

                                            $name = $row['name'];

                                            $account = $row['account'];

                                            $currency = $row['currency'];

                                            $bank = $row['bank'];

                                            $type = $row['type'];

                                            $code = $row['banking_code'];

                                            $codeType = $row['banking_codetype']; ?>

                                            <tr class="iQ_tRow">

                                                <td>
                                                    <div class="flx col">
                                                        <p><?= $name ?></p>
                                                        <p class="font-sm"><?= $account .' (' . $currency . ')' ?></p>
                                                    </div>
                                                </td>

                                                <td>
                                                    <div class="flx col">
                                                        <p><?= $type ?></p>
                                                        <p class="font-sm"><?= ($type == 'CROSS-BORDER TRANSFER') ? $codeType .': ' . $code : null ?></p>
                                                    </div>
                                                </td>

                                                <td class="mobile-0"><?= $bank ?></td>

                                                <td>

                                                    <form class="beneficiary-form">

                                                        <div class="flx">

                                                            <input type="hidden" name="beneficiary-id" value="<?= $id ?>">

                                                            <button class="integrate" type="submit" value="EDIT" iQ-target="#editBeneficiary">
                                                                <span class="hint--bottom" aria-label="Edit">
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none"><path d="M8.84202 3.62602L3.36868 9.41935C3.16202 9.63935 2.96202 10.0727 2.92202 10.3727L2.67535 12.5327C2.58868 13.3127 3.14868 13.846 3.92202 13.7127L6.06868 13.346C6.36868 13.2927 6.78868 13.0727 6.99535 12.846L12.4687 7.05268C13.4154 6.05268 13.842 4.91268 12.3687 3.51935C10.902 2.13935 9.78868 2.62602 8.84202 3.62602Z" stroke="currentColor" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M7.92871 4.59241C8.21538 6.43241 9.70871 7.83907 11.562 8.02574" stroke="currentColor" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                                                                </span>
                                                            </button>

                                                            <button class="integrate red" type="submit" value="DELETE">
                                                                <span class="hint--bottom" aria-label="Delete">
                                                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 shrink-0"><path fill-rule="evenodd" clip-rule="evenodd" d="M10.5555 4C10.099 4 9.70052 4.30906 9.58693 4.75114L9.29382 5.8919H14.715L14.4219 4.75114C14.3083 4.30906 13.9098 4 13.4533 4H10.5555ZM16.7799 5.8919L16.3589 4.25342C16.0182 2.92719 14.8226 2 13.4533 2H10.5555C9.18616 2 7.99062 2.92719 7.64985 4.25342L7.22886 5.8919H4C3.44772 5.8919 3 6.33961 3 6.8919C3 7.44418 3.44772 7.8919 4 7.8919H4.10069L5.31544 19.3172C5.47763 20.8427 6.76455 22 8.29863 22H15.7014C17.2354 22 18.5224 20.8427 18.6846 19.3172L19.8993 7.8919H20C20.5523 7.8919 21 7.44418 21 6.8919C21 6.33961 20.5523 5.8919 20 5.8919H16.7799ZM17.888 7.8919H6.11196L7.30423 19.1057C7.3583 19.6142 7.78727 20 8.29863 20H15.7014C16.2127 20 16.6417 19.6142 16.6958 19.1057L17.888 7.8919ZM10 10C10.5523 10 11 10.4477 11 11V16C11 16.5523 10.5523 17 10 17C9.44772 17 9 16.5523 9 16V11C9 10.4477 9.44772 10 10 10ZM14 10C14.5523 10 15 10.4477 15 11V16C15 16.5523 14.5523 17 14 17C13.4477 17 13 16.5523 13 16V11C13 10.4477 13.4477 10 14 10Z" fill="currentColor"></path></svg>
                                                                </span>
                                                            </button>

                                                        </div>

                                                    </form>

                                                </td>

                                            </tr>

                                        <?php endforeach;    

                                    } else {

                                        emptyTable('No saved beneficiary!', '<svg width="71" height="72" viewBox="0 0 71 72" fill="none" xmlns="http://www.w3.org/2000/svg"><path opacity="0.4" d="M26.625 6.41667C18.8742 6.41667 12.5729 12.7179 12.5729 20.4688C12.5729 28.0717 18.5192 34.225 26.27 34.4913C26.5067 34.4617 26.7433 34.4617 26.9208 34.4913C26.98 34.4913 27.0096 34.4913 27.0687 34.4913C27.0983 34.4913 27.0983 34.4913 27.1279 34.4913C34.7012 34.225 40.6475 28.0717 40.6771 20.4688C40.6771 12.7179 34.3758 6.41667 26.625 6.41667Z" fill="#E6E6E6"></path><path d="M41.6533 42.3604C33.3996 36.8579 19.9392 36.8579 11.6263 42.3604C7.86917 44.875 5.79834 48.2771 5.79834 51.9158C5.79834 55.5546 7.86917 58.9271 11.5967 61.4121C15.7383 64.1929 21.1817 65.5833 26.625 65.5833C32.0683 65.5833 37.5117 64.1929 41.6533 61.4121C45.3808 58.8975 47.4517 55.525 47.4517 51.8567C47.4221 48.2179 45.3808 44.8454 41.6533 42.3604Z" fill="#E6E6E6"></path><path opacity="0.4" d="M59.1371 22.2142C59.6104 27.9533 55.5279 32.9825 49.8775 33.6629C49.8479 33.6629 49.8479 33.6629 49.8183 33.6629H49.7296C49.5521 33.6629 49.3746 33.6629 49.2266 33.7221C46.3571 33.87 43.7241 32.9529 41.7421 31.2667C44.7891 28.545 46.5346 24.4625 46.1796 20.025C45.9725 17.6287 45.1442 15.4396 43.9017 13.5758C45.0258 13.0137 46.3275 12.6587 47.6587 12.5404C53.4571 12.0375 58.6342 16.3567 59.1371 22.2142Z" fill="#E6E6E6"></path><path d="M65.0538 49.5788C64.8171 52.4483 62.9829 54.9333 59.9063 56.6196C56.9479 58.2467 53.2204 59.0158 49.5225 58.9271C51.6525 57.0042 52.895 54.6079 53.1317 52.0638C53.4275 48.3954 51.6821 44.875 48.1913 42.0646C46.2092 40.4967 43.9017 39.2542 41.3871 38.3371C47.925 36.4438 56.1492 37.7158 61.2079 41.7983C63.9296 43.9875 65.32 46.7388 65.0538 49.5788Z" fill="#E6E6E6"></path></svg>');

                                    }
                                
                                ?>
                                
                            </tbody>

                        </table>

                        <div class="table_nav">

                            <button class="prevPage" disabled>

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6.37999 3.95333L2.33333 8L6.37999 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M13.6667 8H2.44667" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                                
                                <span>Prev</span>
                        
                            </button>

                            <button class="nextPage" disabled>
                                
                                <span>Next</span>

                                <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.62 3.95334L13.6667 8.00001L9.62 12.0467" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path><path d="M2.33331 8H13.5533" stroke="#2D3443" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                        
                            </button>

                        </div>

                    </div>

                </div>

            </div>

            <div class="iQ_panel n_displ" id="verif">

                <div class="dash_banner v2">

                    <div class="dashBanner_header">

                        <div class="dbHeader_item">

                            <h4 class="dashBanner_title">Address Information</h4>

                        </div>

                    </div>

                    <div class="dashBanner_box">

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Country</div>

                            <p translate="no"><?= $userData['country'] != null ? $userData['country'] : '-' ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">State</div>

                            <p translate="no"><?= $userData['state'] != null ? $userData['state'] : '-' ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">City</div>

                            <p><?= $userData['city'] != null ? $userData['city'] : '-' ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Street address</div>

                            <p translate="no"><?= $userData['street'] != null ? $userData['street'] : '-' ?>
                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Zip Code</div>

                            <p><?= $userData['zip'] != null ? $userData['zip'] : '-' ?></p>

                        </div>

                    </div>

                </div>

                <div class="dash_banner v2">

                    <div class="dashBanner_header">

                        <div class="dbHeader_item">

                            <h4 class="dashBanner_title">Identity Verification</h4>

                        </div>

                    </div>

                    <div class="dashBanner_box">

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Document Type</div>

                            <p translate="no"><?= $userData['proof-type'] != null ? $userData['proof-type'] : '-' ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Document Number</div>

                            <p translate="no"><?= $userData['id-num'] != null ? $userData['id-num'] : '-' ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Issuing Country</div>

                            <p><?= $userData['id-nation'] != null ? $userData['id-nation'] : '-' ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Issue date</div>

                            <p translate="no"><?= $userData['id-date'] != null ? date('d M, Y', strtotime($userData['id-date'])) : '-' ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Expiry Date</div>

                            <p><?= $userData['id-expires'] != null ? date('d M, Y', strtotime($userData['id-expires'])) : '-' ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Date Of Birth</div>

                            <p><?= $userData['dob'] != null ? date('d M, Y', strtotime($userData['dob'])) : '-' ?></p>

                        </div>

                        <div class="dB_boxItem">

                            <div class="dB_boxHeading">Submitted Document</div>

                            <?php
                            
                                if ($userData['proof-front'] != null && file_exists('../' . str_replace('../', '', $userData['proof-front']))) {

                                    echo '<div class="dB_boxAccess" iQ-target="#docID"><span>View</span></div>';

                                } else {

                                    echo '<p>-</p>';

                                }

                            ?>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</section>

<!-- MODAL: Reset Password -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ_resetPwrd" class="popup_con n_displ">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Reset Password</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <form id="reset-pwrd-form" method="post" autocomplete="off">

                    <div class="form_item">

                        <label for="current-pwrd">Current Password</label>

                        <input name="current-pwrd" placeholder="" class="form_field" required>

                    </div>

                    <div id="pwrd-criteria" class="n_displ">

                        <div class="form_item req">

                            <span class="bl">At Least:</span>

                            <div class="req_map">

                                <div class="req_key">

                                    <svg class="icon" width="15" height="15" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.2959 12.6403L11.2056 17.6759L20.3235 8.32413" stroke="#25B185" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>

                                    <span>8 characters</span>

                                </div>

                                <div class="req_key">

                                    <svg class="icon" width="15" height="15" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.2959 12.6403L11.2056 17.6759L20.3235 8.32413" stroke="#25B185" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>

                                    <span>An uppercase letter</span>

                                </div>

                                <div class="req_key">

                                    <svg class="icon" width="15" height="15" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.2959 12.6403L11.2056 17.6759L20.3235 8.32413" stroke="#25B185" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>

                                    <span>A lowercase letter</span>

                                </div>

                                <div class="req_key">

                                    <svg class="icon" width="15" height="15" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.2959 12.6403L11.2056 17.6759L20.3235 8.32413" stroke="#25B185" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>

                                    <span>A special character</span>

                                </div>

                                <div class="req_key">

                                    <svg class="icon" width="15" height="15" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.2959 12.6403L11.2056 17.6759L20.3235 8.32413" stroke="#25B185" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>

                                    <span>A number</span>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="form_item db">

                        <div class="form_item">

                            <label for="new-pwrd">New Password</label>

                            <div class="form_field pseudoField">

                            <input class="iQ_veilField" type="password" name="new-pwrd" placeholder="(At least 8 Characters)" required autocomplete="off">

                            <div class="iQ_veiler">

                                <svg class="default" slot="trailing-accessory" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0)">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M8.00006 12C5.2353 12 2.91494 10.3114 2.05613 8C2.91494 5.68865 5.2353 4 8.00006 4C10.7648 4 13.0852 5.68865 13.944 8C13.0852 10.3114 10.7648 12 8.00006 12ZM8.00006 2C4.26573 2 1.0761 4.38252 0.0450312 7.70349C-0.014929 7.89662 -0.014929 8.10338 0.0450312 8.29651C1.0761 11.6175 4.26573 14 8.00006 14C11.7344 14 14.924 11.6175 15.9551 8.29651C16.0151 8.10338 16.0151 7.89662 15.9551 7.70349C14.924 4.38252 11.7344 2 8.00006 2ZM8.00006 10C9.10463 10 10.0001 9.10457 10.0001 8C10.0001 6.89543 9.10463 6 8.00006 6C6.89549 6 6.00006 6.89543 6.00006 8C6.00006 9.10457 6.89549 10 8.00006 10Z" fill="currentColor" fill-opacity="0.3"></path>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0">
                                            <rect width="16" height="16" fill="currentColor"></rect>
                                        </clipPath>
                                    </defs>
                                </svg>

                                <svg class="toggle" slot="trailing-accessory" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0)">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M1.70711 0.292878C1.31658 -0.0976463 0.683418 -0.0976463 0.292893 0.292878C-0.0976311 0.683402 -0.0976311 1.31657 0.292893 1.70709L2.55013 3.96433C1.38429 4.94208 0.502299 6.23046 0.0449702 7.70347C-0.0149901 7.8966 -0.0149901 8.10337 0.0449702 8.29649C1.07604 11.6175 4.26567 14 8 14C9.33924 14 10.6084 13.6936 11.7331 13.1473L14.2929 15.7071C14.6834 16.0976 15.3166 16.0976 15.7071 15.7071C16.0976 15.3166 16.0976 14.6834 15.7071 14.2929L13.4499 12.0356C14.6157 11.0579 15.4977 9.76951 15.955 8.29649C16.015 8.10337 16.015 7.8966 15.955 7.70347C14.924 4.38251 11.7343 1.99998 8 1.99998C6.66076 1.99998 5.39158 2.30641 4.26689 2.85266L1.70711 0.292878ZM2.05607 7.99998C2.43683 6.97522 3.10489 6.07286 3.9716 5.3858L6.0677 7.4819C6.0235 7.64714 5.99994 7.82082 5.99994 8C5.99994 9.10457 6.89537 10 7.99994 10C8.17912 10 8.3528 9.97644 8.51804 9.93224L10.2077 11.6219C9.52221 11.866 8.77873 12 8 12C5.23524 12 2.91488 10.3113 2.05607 7.99998ZM9.93221 8.51798L12.0284 10.6142C12.8951 9.92711 13.5632 9.02475 13.9439 7.99998C13.0851 5.68863 10.7648 3.99998 8 3.99998C7.22127 3.99998 6.47779 4.13395 5.7923 4.37807L7.48196 6.06773C7.64716 6.02355 7.8208 6 7.99994 6C9.10451 6 9.99994 6.89543 9.99994 8C9.99994 8.17914 9.97639 8.35277 9.93221 8.51798Z" fill="currentColor" fill-opacity="0.3"></path>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0">
                                            <rect width="16" height="16" fill="currentColor"></rect>
                                        </clipPath>
                                    </defs>
                                </svg>

                            </div>

                            </div>

                        </div>

                        <div class="form_item">

                            <label for="confirm-pwrd">Confirm Password</label>

                            <div class="form_field pseudoField">

                                <input class="iQ_veilField" type="password" name="confirm-pwrd" placeholder="Retype Password" required autocomplete="off">

                                <div class="iQ_veiler">

                                    <svg class="default" slot="trailing-accessory" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0)">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M8.00006 12C5.2353 12 2.91494 10.3114 2.05613 8C2.91494 5.68865 5.2353 4 8.00006 4C10.7648 4 13.0852 5.68865 13.944 8C13.0852 10.3114 10.7648 12 8.00006 12ZM8.00006 2C4.26573 2 1.0761 4.38252 0.0450312 7.70349C-0.014929 7.89662 -0.014929 8.10338 0.0450312 8.29651C1.0761 11.6175 4.26573 14 8.00006 14C11.7344 14 14.924 11.6175 15.9551 8.29651C16.0151 8.10338 16.0151 7.89662 15.9551 7.70349C14.924 4.38252 11.7344 2 8.00006 2ZM8.00006 10C9.10463 10 10.0001 9.10457 10.0001 8C10.0001 6.89543 9.10463 6 8.00006 6C6.89549 6 6.00006 6.89543 6.00006 8C6.00006 9.10457 6.89549 10 8.00006 10Z" fill="currentColor" fill-opacity="0.3"></path>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0">
                                                <rect width="16" height="16" fill="currentColor"></rect>
                                            </clipPath>
                                        </defs>
                                    </svg>

                                    <svg class="toggle" slot="trailing-accessory" width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0)">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M1.70711 0.292878C1.31658 -0.0976463 0.683418 -0.0976463 0.292893 0.292878C-0.0976311 0.683402 -0.0976311 1.31657 0.292893 1.70709L2.55013 3.96433C1.38429 4.94208 0.502299 6.23046 0.0449702 7.70347C-0.0149901 7.8966 -0.0149901 8.10337 0.0449702 8.29649C1.07604 11.6175 4.26567 14 8 14C9.33924 14 10.6084 13.6936 11.7331 13.1473L14.2929 15.7071C14.6834 16.0976 15.3166 16.0976 15.7071 15.7071C16.0976 15.3166 16.0976 14.6834 15.7071 14.2929L13.4499 12.0356C14.6157 11.0579 15.4977 9.76951 15.955 8.29649C16.015 8.10337 16.015 7.8966 15.955 7.70347C14.924 4.38251 11.7343 1.99998 8 1.99998C6.66076 1.99998 5.39158 2.30641 4.26689 2.85266L1.70711 0.292878ZM2.05607 7.99998C2.43683 6.97522 3.10489 6.07286 3.9716 5.3858L6.0677 7.4819C6.0235 7.64714 5.99994 7.82082 5.99994 8C5.99994 9.10457 6.89537 10 7.99994 10C8.17912 10 8.3528 9.97644 8.51804 9.93224L10.2077 11.6219C9.52221 11.866 8.77873 12 8 12C5.23524 12 2.91488 10.3113 2.05607 7.99998ZM9.93221 8.51798L12.0284 10.6142C12.8951 9.92711 13.5632 9.02475 13.9439 7.99998C13.0851 5.68863 10.7648 3.99998 8 3.99998C7.22127 3.99998 6.47779 4.13395 5.7923 4.37807L7.48196 6.06773C7.64716 6.02355 7.8208 6 7.99994 6C9.10451 6 9.99994 6.89543 9.99994 8C9.99994 8.17914 9.97639 8.35277 9.93221 8.51798Z" fill="currentColor" fill-opacity="0.3"></path>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0">
                                                <rect width="16" height="16" fill="currentColor"></rect>
                                            </clipPath>
                                        </defs>
                                    </svg>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="form_item">

                        <button id="reset-pwrd" class="form_btn" type="submit">Proceed</button>

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

<!-- MODAL: Update Transaction PIN -->

<div class="popup_window n_displ" role="dialog">

    <div id="iQ_tPIN" class="popup_con n_displ">

        <div class="popup_box noScrollBar float_up">

            <div class="popupBox_header">

                <p>Update Transaction PIN</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <form id="update-tpin-form" method="post" autocomplete="off">

                    <div class="form_item db">

                        <div class="form_item">

                            <label for="answer-1"><?= $userData['secret-question'] ?></label>

                            <input type="text" name="answer-1" class="form_field" required>

                        </div>

                        <div class="form_item">

                            <label for="answer-2"><?= $userData['secret-questionB'] ?></label>

                            <input type="text" name="answer-2" class="form_field" required>

                        </div>

                    </div>

                    <p class="form_info">Enter New Transaction PIN</p>

                    <div class="form_item mltpl">

                        <input type="text" name="new-tpin[]" class="form_field iQ_field iQ_fieldNum" maxlength="1" required autofocus aria-autocomplete="none">

                        <input type="text" name="new-tpin[]" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                        <input type="text" name="new-tpin[]" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                        <input type="text" name="new-tpin[]" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                        <input type="text" name="new-tpin[]" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                        <input type="text" name="new-tpin[]" class="form_field iQ_field iQ_fieldNum" maxlength="1" required aria-autocomplete="none">

                    </div>

                    <div class="form_item">

                        <button id="update-tpin" class="form_btn" type="submit">Proceed</button>

                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

<!-- MODAL: ID Document -->

<div class="popup_window n_displ" role="dialog">

    <div id="docID" class="popup_con n_displ">

        <div class="popup_box noScrollBar">

            <div class="popupBox_header">

                <p>Identity Proof</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box">

                <div class="form_item" style="justify-content: center; user-select: none;">

                    <div id="img-displ">

                        <?php
                            
                            if ($userData['proof-front'] != null) {

                                echo '<img src="' . $siteURL . '/' . str_replace('../', '', $userData['proof-front']). '" alt>';

                            }
                        
                        ?>

                    </div>

                    <div>

                        <i style="font-size: 0.8rem;">Submitted Document</i>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

<!-- MODAL: Beneficiary Edit -->

<div class="popup_window n_displ" role="dialog">

    <div id="editBeneficiary" class="popup_con n_displ">

        <div class="popup_box noScrollBar">

            <div class="popupBox_header">

                <p>Edit Beneficiary</p>

                <div class="radial_icon iQ_terminator">

                    <svg width="15" height="15" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg" class="close-icon"><path d="M5.80032 5.79883L13.1229 13.1214" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path><path d="M5.79958 13.1214L13.1222 5.79883" stroke="white" stroke-width="1.68132" stroke-linecap="round" stroke-linejoin="round"></path></svg>

                </div>

            </div>

            <div class="modal_box" id="beneficiaryView"></div>

        </div>

    </div>

</div>

<?php

    require('../partials/footer.php');

?>            